/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.logging.Logger;

class OidExpr
extends Expr {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/OidExpr"));
    private Table _table;
    private int _tableIndex;

    OidExpr(Table table, int tableIndex) {
        this._table = table;
        this._tableIndex = tableIndex;
    }

    public Class getType() {
        return Long.TYPE;
    }

    public String getName() {
        return "resin_oid";
    }

    public Table getTable() {
        return this._table;
    }

    public boolean isNull(QueryContext context) throws SQLException {
        return false;
    }

    public String evalString(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return String.valueOf(row.getRowAddress());
    }

    public int evalInt(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return (int)row.getRowAddress();
    }

    public long evalLong(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getRowAddress();
    }

    public double evalDouble(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getRowAddress();
    }

    public String toString() {
        return "OidExpr[" + this._tableIndex + "]";
    }
}

