/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Block;
import com.caucho.db.store.Store;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.util.LongKeyClockCache;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;

public class BlockManager {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/store/Block"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/store/Block"));
    private LongKeyClockCache<Block> _blockCache;
    private int _maxBlockEntries = 128;

    public void setMaxBlockEntries(int maxBlockEntries) {
        this._maxBlockEntries = maxBlockEntries;
    }

    public void init() {
        this._blockCache = new LongKeyClockCache(this._maxBlockEntries);
    }

    public Block getBlock(Store store, long blockId) {
        Block block = this._blockCache.get(blockId);
        if (block != null) {
            if (block.allocate()) {
                return block;
            }
            block = null;
        }
        block = new Block(store, blockId, store.getLock());
        block.allocate();
        this._blockCache.put(blockId, block);
        return block;
    }
}

