/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.Database;
import com.caucho.db.store.Block;
import com.caucho.db.store.BlockManager;
import com.caucho.db.store.Lock;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.util.logging.Logger;

public class Store {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/store/Store"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/store/Store"));
    public static final int BLOCK_BITS = 16;
    public static final int BLOCK_SIZE = 65536;
    public static final int BLOCK_INDEX_MASK = 65535;
    public static final long BLOCK_MASK = -65536L;
    public static final long BLOCK_OFFSET_MASK = 65535L;
    public static final int ALLOC_FREE = 0;
    private static final int ALLOC_ROW = 1;
    private static final int ALLOC_USED = 2;
    private static final int ALLOC_FRAGMENT = 3;
    private static final int ALLOC_MASK = 3;
    public static final int FRAGMENT_MAX_SIZE = 32768;
    public static final int FRAGMENT_HEADER = 1024;
    public static final long FRAGMENT_CLOCK_MIN = 262144L;
    public static final int STORE_CREATE_END = 1024;
    private static final int STORE_FRAGMENT_SIZE_OFFSET = 16;
    private static final int STORE_FRAGMENT_FREE_OFFSET = 24;
    protected final Database _database;
    protected final BlockManager _blockManager;
    private final String _name;
    private final int _id;
    private final Path _path;
    private long _fileSize;
    private long _blockCount;
    private byte[] _allocationTable;
    private long _clockAddr;
    private long _fragmentClockAddr;
    private long _fragmentClockTotal;
    private long _fragmentClockUsed;
    private SoftReference<RandomAccessFile> _cachedRowFile;
    private Lock _tableLock;

    public Store(Database database, String name, Lock tableLock) {
        this._database = database;
        this._blockManager = this._database.getBlockManager();
        this._name = name;
        this._path = this._database.getPath().lookup(this._name + ".db");
        this._id = database.generateTableId();
        if (tableLock == null) {
            tableLock = new Lock(this._id);
        }
        this._tableLock = tableLock;
    }

    public String getName() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public Lock getLock() {
        return this._tableLock;
    }

    public BlockManager getBlockManager() {
        return this._blockManager;
    }

    static long blockIndexToAddr(long blockIndex) {
        return blockIndex << 16;
    }

    public final long blockIndexToBlockId(long blockIndex) {
        return (blockIndex << 16) + (long)this._id;
    }

    public final long addressToBlockId(long address) {
        return (address & 0xFFFFFFFFFFFF0000L) + (long)this._id;
    }

    public static long blockIdToAddress(long blockId) {
        return blockId & 0xFFFFFFFFFFFF0000L;
    }

    public static long blockIdToAddress(long blockId, int offset) {
        return (blockId & 0xFFFFFFFFFFFF0000L) + (long)offset;
    }

    public void create() throws IOException, SQLException {
        this._path.getParent().mkdirs();
        if (this._path.exists()) {
            throw new SQLException(L.l("Table `{0}' already exists.  CREATE can not override an existing table.", this._name));
        }
        this._allocationTable = new byte[8192];
        this.setAllocation(0L, 2);
        this.setAllocation(1L, 2);
        byte[] buffer = new byte[65536];
        this.writeBlock(0L, buffer, 0, 65536);
        this.writeBlock(65536L, buffer, 0, 65536);
        this.writeBlock(0L, this._allocationTable, 0, this._allocationTable.length);
        this._blockCount = 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        this._allocationTable = new byte[8192];
        RandomAccessFile file = this.openRowFile();
        try {
            this._fileSize = file.length();
            this._blockCount = (this._fileSize + 65536L - 1L) / 65536L;
            this.readBlock(0L, this._allocationTable, 0, 8192);
        }
        finally {
            file.close();
        }
    }

    public void remove() throws SQLException {
        try {
            this._path.remove();
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    public long firstRow(long blockId) throws IOException {
        if (blockId <= 65536L) {
            blockId = 65536L;
        }
        for (long blockIndex = blockId >> 16; blockIndex < this._blockCount; ++blockIndex) {
            if (this.getAllocation(blockIndex) != 1) continue;
            return this.blockIndexToBlockId(blockIndex);
        }
        return -1L;
    }

    public long firstFragment(long blockId) throws IOException {
        if (blockId <= 65536L) {
            blockId = 65536L;
        }
        for (long blockIndex = blockId >> 16; blockIndex < this._blockCount; ++blockIndex) {
            if (this.getAllocation(blockIndex) != 3) continue;
            return this.blockIndexToBlockId(blockIndex);
        }
        return -1L;
    }

    public Block getBlock(long blockId) {
        return this._blockManager.getBlock(this, blockId);
    }

    public Block readBlock(long blockId) throws IOException {
        Block block = this._blockManager.getBlock(this, blockId);
        block.read();
        return block;
    }

    public Block allocateRow() throws IOException {
        return this.allocateBlock(1);
    }

    public Block allocate() throws IOException {
        return this.allocateBlock(2);
    }

    public Block allocateFragment() throws IOException {
        return this.allocateBlock(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block allocateBlock(int code) throws IOException {
        byte[] byArray = this._allocationTable;
        synchronized (this._allocationTable) {
            long blockIndex;
            long end = this._blockCount + 1L;
            for (blockIndex = 0L; blockIndex < end && this.getAllocation(blockIndex) != 0; ++blockIndex) {
            }
            if ((long)(4 * this._allocationTable.length) <= blockIndex) {
                throw new IllegalStateException("allocation table full");
            }
            this.setAllocation(blockIndex, code);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            this.saveAllocation();
            long blockId = this.blockIndexToBlockId(blockIndex);
            Block block = this._blockManager.getBlock(this, blockId);
            byte[] buffer = block.getBuffer();
            for (int i = 0; i < 65536; ++i) {
                buffer[i] = 0;
            }
            this.writeBlock(blockId & 0xFFFFFFFFFFFF0000L, buffer, 0, 65536);
            return block;
        }
    }

    public final int getAllocation(long blockIndex) {
        int allocOffset = (int)(blockIndex >> 2);
        int allocBits = 2 * (int)(blockIndex & 3L);
        return this._allocationTable[allocOffset] >> allocBits & 3;
    }

    public void setAllocation(long blockIndex, int code) {
        int allocOffset = (int)(blockIndex >> 2);
        int allocBits = 2 * (int)(blockIndex & 3L);
        int mask = 3 << allocBits;
        this._allocationTable[allocOffset] = (byte)(this._allocationTable[allocOffset] & ~mask | code << allocBits);
    }

    public void saveAllocation() throws IOException {
        this.writeBlock(0L, this._allocationTable, 0, this._allocationTable.length);
    }

    public long writeFragment(byte[] buffer, int offset, int length) throws IOException {
        if (32768 < length) {
            throw new IllegalArgumentException();
        }
        boolean isLoop = false;
        while (true) {
            int spaceFree;
            Block block;
            long freeBlockId;
            if ((freeBlockId = this.firstFragment(this._fragmentClockAddr)) >= 0L) {
                block = this.getBlock(freeBlockId);
                if (freeBlockId != this._fragmentClockAddr) {
                    this._fragmentClockTotal += 65536L;
                    this._fragmentClockUsed += (long)Store.readShort(block.getBuffer(), 0);
                }
            } else {
                if (!isLoop && 262144L < this._fragmentClockTotal && 4L * this._fragmentClockUsed < this._fragmentClockTotal) {
                    this._fragmentClockAddr = 0L;
                    this._fragmentClockUsed = 0L;
                    this._fragmentClockTotal = 0L;
                    isLoop = true;
                    continue;
                }
                block = this.allocateFragment();
                this._fragmentClockTotal += 65536L;
            }
            this._fragmentClockAddr = block.getBlockId();
            byte[] blockBuffer = block.getBuffer();
            int spaceUsed = Store.readShort(blockBuffer, 0);
            if (spaceUsed == 0) {
                spaceUsed = 1024;
                this._fragmentClockUsed += 1024L;
                Store.writeShort(blockBuffer, 0, 1024);
                Store.writeShort(blockBuffer, 2, 4);
            }
            if (offset <= (spaceFree = blockBuffer.length - spaceUsed)) {
                for (int i = Store.readShort(blockBuffer, 2); i < 1024; i += 4) {
                    int fragmentOffset = Store.readShort(blockBuffer, i);
                    if (fragmentOffset != 0) continue;
                    Store.writeShort(blockBuffer, i, spaceUsed);
                    Store.writeShort(blockBuffer, i + 2, length);
                    Store.writeShort(blockBuffer, 0, spaceUsed + length);
                    Store.writeShort(blockBuffer, 2, i + 4);
                    System.arraycopy(buffer, offset, blockBuffer, spaceUsed, length);
                    long blockId = (block.getBlockId() & 0xFFFFFFFFFFFF0000L) + (long)i;
                    block.write();
                    block.free();
                    this._fragmentClockUsed += (long)length;
                    return blockId;
                }
            }
            this._fragmentClockUsed += (long)(65536 - spaceUsed);
            this._fragmentClockAddr += 65536L;
            block.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlock(long blockId, byte[] buffer, int offset, int length) throws IOException {
        RandomAccessFile is = this.openRowFile();
        long blockAddress = blockId & 0xFFFFFFFFFFFF0000L;
        try {
            is.seek(blockAddress);
            int readLen = is.read(buffer, offset, length);
            if (readLen < 0) {
                for (int i = 0; i < 65536; ++i) {
                    buffer[i] = 0;
                }
            }
            this.freeRowFile(is);
            is = null;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlock(long blockAddress, byte[] buffer, int offset, int length) throws IOException {
        RandomAccessFile os = this.openRowFile();
        try {
            os.seek(blockAddress);
            os.write(buffer, offset, length);
            this.freeRowFile(os);
            if (this._fileSize < blockAddress + (long)length) {
                this._fileSize = blockAddress + (long)length;
                this._blockCount = (this._fileSize + 65536L - 1L) / 65536L;
            }
            os = null;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openRowFile() throws IOException {
        RandomAccessFile file = null;
        Store store = this;
        synchronized (store) {
            SoftReference<RandomAccessFile> ref = this._cachedRowFile;
            this._cachedRowFile = null;
            if (ref != null) {
                file = ref.get();
            }
        }
        if (file != null) {
            return file;
        }
        file = new RandomAccessFile(this._path.getNativePath(), "rw");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeRowFile(RandomAccessFile file) throws IOException {
        Store store = this;
        synchronized (store) {
            if (this._cachedRowFile == null) {
                this._cachedRowFile = new SoftReference<RandomAccessFile>(file);
                return;
            }
        }
        file.close();
    }

    private static void writeShort(byte[] buffer, int offset, int v) {
        buffer[offset + 0] = (byte)(v >> 8);
        buffer[offset + 1] = (byte)v;
    }

    private static int readShort(byte[] buffer, int offset) {
        return (buffer[offset + 0] & 0xFF) << 8 | buffer[offset + 1] & 0xFF;
    }

    public String toString() {
        return "Store[" + this._id + "]";
    }
}

