/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Row;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.logging.Logger;

public abstract class Column {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/table/Column"));
    public static final int NONE = 0;
    public static final int VARCHAR = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int DOUBLE = 4;
    public static final int DATE = 5;
    public static final int BLOB = 6;
    private final Row _row;
    private final String _name;
    protected final int _columnOffset;
    protected final int _nullOffset;
    protected final byte _nullMask;
    private Table _table;
    private boolean _isPrimaryKey;
    private boolean _isUnique;
    private boolean _isNotNull;
    private int _autoIncrementMin = -1;
    private Expr _defaultExpr;
    private BTree _index;

    public abstract int getTypeCode();

    public abstract int getDeclarationSize();

    abstract int getLength();

    public abstract String getString(byte[] var1, int var2) throws SQLException;

    abstract void setString(Transaction var1, byte[] var2, int var3, String var4) throws SQLException;

    Column(Row row, String name) {
        this._row = row;
        this._name = name;
        this._columnOffset = this._row.getLength();
        this._nullOffset = this._row.getNullOffset();
        this._nullMask = this._row.getNullMask();
    }

    public String getName() {
        return this._name;
    }

    void setTable(Table table) {
        this._table = table;
    }

    public Table getTable() {
        return this._table;
    }

    int getColumnOffset() {
        return this._columnOffset;
    }

    public Class getJavaType() {
        return ClassLiteral.getClass((String)"java/lang/Object");
    }

    public boolean isPrimaryKey() {
        return this._isPrimaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this._isPrimaryKey = primaryKey;
    }

    public boolean isUnique() {
        return this._isUnique;
    }

    public void setUnique() {
        this._isUnique = true;
    }

    public BTree getIndex() {
        return this._index;
    }

    public void setIndex(BTree index) {
        this._index = index;
    }

    public KeyCompare getIndexKeyCompare() {
        return null;
    }

    public void setNotNull() {
        this._isNotNull = true;
    }

    public boolean isNotNull() {
        return this._isNotNull;
    }

    public void setDefault(Expr expr) {
        this._defaultExpr = expr;
    }

    public Expr getDefault() {
        return this._defaultExpr;
    }

    public void setAutoIncrement(int min) {
        this._autoIncrementMin = min;
    }

    public int getAutoIncrement() {
        return this._autoIncrementMin;
    }

    public final boolean isNull(byte[] block, int rowOffset) {
        return (block[rowOffset + this._nullOffset] & this._nullMask) == 0;
    }

    public final void setNull(byte[] block, int rowOffset) {
        int n = rowOffset + this._nullOffset;
        block[n] = (byte)(block[n] & ~this._nullMask);
    }

    protected final void setNonNull(byte[] block, int rowOffset) {
        int n = rowOffset + this._nullOffset;
        block[n] = (byte)(block[n] | this._nullMask);
    }

    public int getInteger(byte[] block, int rowOffset) throws SQLException {
        String str = this.getString(block, rowOffset);
        if (str == null) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    void setInteger(Transaction xa, byte[] block, int rowOffset, int value) throws SQLException {
        this.setString(xa, block, rowOffset, String.valueOf(value));
    }

    public long getLong(byte[] block, int rowOffset) throws SQLException {
        String str = this.getString(block, rowOffset);
        if (str == null) {
            return 0L;
        }
        return Long.parseLong(str);
    }

    void setLong(Transaction xa, byte[] block, int rowOffset, long value) throws SQLException {
        this.setString(xa, block, rowOffset, String.valueOf(value));
    }

    public double getDouble(byte[] block, int rowOffset) throws SQLException {
        String str = this.getString(block, rowOffset);
        if (str == null) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    void setDouble(Transaction xa, byte[] block, int rowOffset, double value) throws SQLException {
        this.setString(xa, block, rowOffset, String.valueOf(value));
    }

    void setExpr(Transaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(context)) {
            this.setNull(block, rowOffset);
        } else {
            this.setString(xa, block, rowOffset, expr.evalString(context));
        }
    }

    public long getDate(byte[] block, int rowOffset) throws SQLException {
        throw new UnsupportedOperationException();
    }

    void setDate(Transaction xa, byte[] block, int rowOffset, double value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isEqual(byte[] block, int rowOffset, byte[] buffer, int offset, int length) {
        return false;
    }

    public boolean isEqual(byte[] buffer1, int rowOffset1, byte[] buffer2, int rowOffset2) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqual(byte[] block, int rowOffset, String string) {
        return false;
    }

    public void evalToResult(byte[] block, int rowOffset, SelectResult result) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void set(Transaction xa, TableIterator iter, Expr expr, QueryContext context) throws SQLException {
        iter.setDirty();
        this.setString(xa, iter.getBuffer(), iter.getRowOffset(), expr.evalString(context));
    }

    void setIndex(Transaction xa, byte[] block, int rowOffset, long rowAddr, QueryContext context) throws SQLException {
    }

    void delete(Transaction xa, byte[] block, int rowOffset) throws SQLException {
    }
}

