/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.index.KeyCompare;
import com.caucho.db.index.StringKeyCompare;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Row;
import com.caucho.util.CharBuffer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;

class StringColumn
extends Column {
    private final int _maxLength;

    StringColumn(Row row, String name, int maxLength) {
        super(row, name);
        if (maxLength < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        if (255 < maxLength) {
            throw new IllegalArgumentException("length too big");
        }
        this._maxLength = maxLength;
    }

    public int getTypeCode() {
        return 1;
    }

    public Class getJavaType() {
        return ClassLiteral.getClass((String)"java/lang/String");
    }

    public int getDeclarationSize() {
        return this._maxLength;
    }

    public int getLength() {
        return 2 * this._maxLength + 1;
    }

    public KeyCompare getIndexKeyCompare() {
        return new StringKeyCompare();
    }

    void setString(Transaction xa, byte[] block, int rowOffset, String str) {
        int startOffset = rowOffset + this._columnOffset;
        if (str == null) {
            this.setNull(block, rowOffset);
            return;
        }
        int len = str.length();
        int offset = startOffset + 1;
        int maxOffset = offset + 2 * this._maxLength;
        for (int i = 0; i < len && offset < maxOffset; ++i) {
            char ch = str.charAt(i);
            block[offset++] = (byte)(ch >> 8);
            block[offset++] = (byte)ch;
        }
        block[startOffset] = (byte)len;
        this.setNonNull(block, rowOffset);
    }

    public String getString(byte[] block, int rowOffset) {
        if (this.isNull(block, rowOffset)) {
            return null;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        CharBuffer cb = CharBuffer.allocate();
        int offset = startOffset + 1;
        int endOffset = offset + 2 * len;
        while (offset < endOffset) {
            int ch1 = block[offset++] & 0xFF;
            int ch2 = block[offset++] & 0xFF;
            cb.append((char)((ch1 << 8) + ch2));
        }
        return cb.close();
    }

    void setExpr(Transaction xa, byte[] block, int rowOffset, Expr expr, QueryContext context) throws SQLException {
        if (expr.isNull(null)) {
            this.setNull(block, rowOffset);
        } else {
            this.setString(xa, block, rowOffset, expr.evalString(context));
        }
    }

    public boolean isEqual(byte[] block1, int rowOffset1, byte[] block2, int rowOffset2) {
        if (this.isNull(block1, rowOffset1) != this.isNull(block2, rowOffset2)) {
            return false;
        }
        int startOffset1 = rowOffset1 + this._columnOffset;
        int len1 = block1[startOffset1] & 0xFF;
        int startOffset2 = rowOffset2 + this._columnOffset;
        int len2 = block2[startOffset2] & 0xFF;
        if (len1 != len2) {
            return false;
        }
        for (int i = 2 * len1; i > 0; --i) {
            if (block1[startOffset1 + i] == block2[startOffset2 + i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(byte[] block, int rowOffset, byte[] buffer, int offset, int length) {
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        if (len != length) {
            return false;
        }
        int blockOffset = startOffset + 1;
        int endOffset = blockOffset + 2 * len;
        while (blockOffset < endOffset) {
            if (block[blockOffset++] == buffer[offset++]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(byte[] block, int rowOffset, String value) {
        if (value == null) {
            return this.isNull(block, rowOffset);
        }
        if (this.isNull(block, rowOffset)) {
            return false;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        int strLength = value.length();
        int strOffset = 0;
        int offset = startOffset + 1;
        int endOffset = offset + 2 * len;
        while (offset < endOffset && strOffset < strLength) {
            char ch;
            int ch1;
            if ((ch1 = ((block[offset++] & 0xFF) << 8) + (block[offset++] & 0xFF)) == (ch = value.charAt(strOffset++))) continue;
            return false;
        }
        return offset == endOffset && strOffset == strLength;
    }

    public void evalToResult(byte[] block, int rowOffset, SelectResult result) {
        if (this.isNull(block, rowOffset)) {
            result.writeNull();
            return;
        }
        int startOffset = rowOffset + this._columnOffset;
        int len = block[startOffset] & 0xFF;
        result.writeString(block, startOffset + 1, len);
    }

    void setIndex(Transaction xa, byte[] block, int rowOffset, long rowAddr, QueryContext context) throws SQLException {
        BTree index = this.getIndex();
        if (index == null) {
            return;
        }
        index.insert(block, rowOffset + this._columnOffset, this.getLength(), rowAddr);
    }

    void delete(Transaction xa, byte[] block, int rowOffset) throws SQLException {
        BTree index = this.getIndex();
        if (index != null) {
            index.remove(block, rowOffset + this._columnOffset, this.getLength());
        }
    }

    public String toString() {
        return "StringColumn[" + this.getName() + "]";
    }
}

