/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.doclet;

import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDoclet {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/doclet/EjbDoclet"));
    private JavaWriter _out;
    private int _depth;
    private boolean _isLineStart;
    private ArrayList<ClassDoc> _mainClasses;

    public static int optionLength(String option) {
        if (option.equals("-path")) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc root) {
        String[][] options = root.options();
        Path path = null;
        for (int i = 0; i < options.length; ++i) {
            String[] args = options[i];
            if (!args[0].equals("-path")) continue;
            path = Vfs.lookup(args[1]);
        }
        if (path == null) {
            throw new IllegalArgumentException("-path is expected");
        }
        try {
            WriteStream os = path.openWrite();
            try {
                new XmlDoclet().printRootDoc(os, root);
            }
            finally {
                os.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void printRootDoc(WriteStream os, RootDoc root) throws IOException {
        int i;
        this._out = new JavaWriter(os);
        this._out.println("<doclet>");
        this._mainClasses = new ArrayList();
        ArrayList<ClassDoc> classList = new ArrayList<ClassDoc>();
        ClassDoc[] classes = root.specifiedClasses();
        for (i = 0; i < classes.length; ++i) {
            this._mainClasses.add(classes[i]);
            this.addClasses(classList, classes[i]);
        }
        Collections.sort(classList, new ClassCmp());
        for (i = 0; i < classList.size(); ++i) {
            this.printClassDoc(classList.get(i));
        }
        this._out.println("</doclet>");
    }

    private void addClasses(ArrayList<ClassDoc> classList, ClassDoc cl) {
        if (cl == null) {
            return;
        }
        if (classList.contains(cl)) {
            return;
        }
        classList.add(cl);
        this.addClasses(classList, cl.superclass());
        ClassDoc[] interfaces = cl.interfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.addClasses(classList, interfaces[i]);
        }
    }

    private void printClassDoc(ClassDoc classDoc) throws IOException {
        boolean isFull = this._mainClasses.contains(classDoc);
        this.println("<class>");
        this.pushDepth();
        this.println(new StringBuffer().append("<name>").append(classDoc.qualifiedName()).append("</name>").toString());
        this.printPosition((Doc)classDoc);
        ClassDoc superclass = classDoc.superclass();
        if (superclass != null) {
            this.println(new StringBuffer().append("<superclass>").append(superclass.qualifiedName()).append("</superclass>").toString());
        }
        ClassDoc[] interfaces = classDoc.interfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.println(new StringBuffer().append("<interface>").append(interfaces[i].qualifiedName()).append("</interface>").toString());
        }
        if (isFull) {
            this.printTags((Doc)classDoc);
            MethodDoc[] methods = classDoc.methods();
            for (int i = 0; i < methods.length; ++i) {
                this.printMethodDoc(methods[i]);
            }
        }
        this.popDepth();
        this.println("</class>");
    }

    private void printMethodDoc(MethodDoc methodDoc) throws IOException {
        this.println("<method>");
        this.pushDepth();
        this.println(new StringBuffer().append("<name>").append(methodDoc.name()).append("</name>").toString());
        this.printPosition((Doc)methodDoc);
        Type type = methodDoc.returnType();
        this.println(new StringBuffer().append("<return-type>").append(type.qualifiedTypeName()).append("</return-type>").toString());
        Parameter[] parameters = methodDoc.parameters();
        for (int i = 0; i < parameters.length; ++i) {
            this.println("<param>");
            this.pushDepth();
            this.println(new StringBuffer().append("<name>").append(parameters[i].name()).append("</name>").toString());
            this.println(new StringBuffer().append("<type>").append(parameters[i].typeName()).append("</type>").toString());
            this.popDepth();
            this.println("</param>");
        }
        this.printTags((Doc)methodDoc);
        this.popDepth();
        this.println("</method>");
    }

    private void printTags(Doc doc) throws IOException {
        Tag[] tags = doc.tags();
        for (int i = 0; i < tags.length; ++i) {
            this.println("<tag>");
            this.println(new StringBuffer().append("  <name>").append(tags[i].name()).append("</name>").toString());
            this.print("  <text>");
            this.printEscape(tags[i].text());
            this.println("</text>");
            this.println("</tag>");
        }
    }

    private void printPosition(Doc doc) throws IOException {
        SourcePosition position = doc.position();
        if (position != null) {
            this.println(new StringBuffer().append("<position>").append(position.file().toString()).append(':').append(position.line()).append(": </position>").toString());
        }
    }

    private void print(String s) throws IOException {
        this._out.print(s);
    }

    private void println() throws IOException {
        this._out.println();
    }

    private void println(String s) throws IOException {
        this._out.println(s);
    }

    private void pushDepth() throws IOException {
        this._out.pushDepth();
    }

    private void popDepth() throws IOException {
        this._out.popDepth();
    }

    private void printEscape(String string) throws IOException {
        block5: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    this._out.print("&lt;");
                    continue block5;
                }
                case '>': {
                    this._out.print("&gt;");
                    continue block5;
                }
                case '&': {
                    this._out.print("&amp;");
                    continue block5;
                }
                default: {
                    this._out.print(ch);
                }
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassCmp
    implements Comparator<ClassDoc> {
        ClassCmp() {
        }

        @Override
        public int compare(ClassDoc cl1, ClassDoc cl2) {
            if (cl1.equals(cl2)) {
                return 0;
            }
            if (ClassCmp.isAssignableFrom(cl1, cl2)) {
                return -1;
            }
            if (ClassCmp.isAssignableFrom(cl2, cl1)) {
                return 1;
            }
            return 0;
        }

        private static boolean isAssignableFrom(ClassDoc cl1, ClassDoc cl2) {
            if (cl2 == null) {
                return false;
            }
            if (cl1.equals(cl2)) {
                return true;
            }
            if (ClassCmp.isAssignableFrom(cl1, cl2.superclass())) {
                return true;
            }
            ClassDoc[] interfaces = cl2.interfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!ClassCmp.isAssignableFrom(cl1, interfaces[i])) continue;
                return true;
            }
            return false;
        }
    }
}

