/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.config.BuilderProgram;
import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.EJBMetaDataImpl;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.protocol.SameJVMClientContainer;
import com.caucho.ejb.session.SessionServer;
import com.caucho.ejb.session.StatelessServer;
import com.caucho.ejb.xa.EjbTransactionManager;
import com.caucho.ejb.xa.TransactionContext;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.ejb.HomeHandle;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public abstract class AbstractServer {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/AbstractServer"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/AbstractServer"));
    protected String _ejbName;
    protected String _serverId;
    protected EjbServerManager _ejbManager;
    protected HashMap<String, HandleEncoder> _protocolEncoderMap;
    protected HandleEncoder _handleEncoder;
    protected DataSource _dataSource;
    protected DynamicClassLoader _loader;
    protected SameJVMClientContainer _jvmClient;
    protected Class _contextImplClass;
    protected Class _remoteHomeClass;
    protected Class _remoteObjectClass;
    protected Class _primaryKeyClass;
    protected Class _remoteStubClass;
    protected Class _homeStubClass;
    protected HomeHandle _homeHandle;
    protected EJBHome _remoteHome;
    protected EJBHome _remoteHomeView;
    protected EJBLocalHome _localHome;
    protected EJBMetaDataImpl _metaData;
    protected long _transactionTimeout;
    protected BuilderProgram _initProgram;

    public abstract AbstractContext getContext(Object var1, boolean var2) throws FinderException;

    public AbstractServer(EjbServerManager manager) {
        this._ejbManager = manager;
        DynamicClassLoader loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        this.setClassLoader(loader);
    }

    public void setEJBName(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = "/" + ejbName;
        }
        while (ejbName.endsWith("/")) {
            ejbName = ejbName.substring(0, ejbName.length() - 1);
        }
        this._ejbName = ejbName;
    }

    public void setContextImplClass(Class cl) {
        this._contextImplClass = cl;
    }

    public void setRemoteHomeClass(Class cl) {
        this._remoteHomeClass = cl;
    }

    public Class getRemoteHomeClass() {
        return this._remoteHomeClass;
    }

    public void setRemoteObjectClass(Class cl) {
        this._remoteObjectClass = cl;
    }

    public Class getRemoteObjectClass() {
        return this._remoteObjectClass;
    }

    public HandleEncoder getHandleEncoder(String protocol) {
        HandleEncoder encoder;
        if (this._protocolEncoderMap != null && (encoder = this._protocolEncoderMap.get(protocol)) != null) {
            return encoder;
        }
        try {
            Class keyClass = this.getPrimaryKeyClass();
            encoder = this._ejbManager.getProtocolManager().createHandleEncoder(this, keyClass, protocol);
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
        if (this._protocolEncoderMap == null) {
            this._protocolEncoderMap = new HashMap(8);
        }
        this._protocolEncoderMap.put(protocol, encoder);
        return encoder;
    }

    public String encodeId(Object primaryKey) {
        return String.valueOf(primaryKey);
    }

    public HandleEncoder addHandleEncoder(String protocol, String serverId) {
        HandleEncoder encoder;
        if (this._protocolEncoderMap != null && (encoder = this._protocolEncoderMap.get(protocol)) != null) {
            return encoder;
        }
        try {
            Class keyClass = this.getPrimaryKeyClass();
            encoder = new HandleEncoder(this, serverId + this._ejbName);
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
        if (this._protocolEncoderMap == null) {
            this._protocolEncoderMap = new HashMap(8);
        }
        this._protocolEncoderMap.put(protocol, encoder);
        return encoder;
    }

    public HandleEncoder getHandleEncoder() {
        return this.getHandleEncoder(EjbProtocolManager.getThreadProtocol());
    }

    public void setHandleEncoder(HandleEncoder encoder) {
        if (this._homeHandle != null) {
            this._homeHandle = null;
        }
        this._handleEncoder = encoder;
    }

    public UserTransaction getUserTransaction() {
        return this._ejbManager.getTransactionManager().getUserTransaction();
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public String getServerId() {
        if (this._serverId == null) {
            this._serverId = this.getHandleEncoder().getServerId();
        }
        return this._serverId;
    }

    public EjbServerManager getContainer() {
        return this._ejbManager;
    }

    public EjbServerManager getServerManager() {
        return this._ejbManager;
    }

    public void setTransactionTimeout(long timeout) {
        this._transactionTimeout = timeout;
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public void invalidateCache() {
    }

    public void remove(AbstractHandle handle) {
        throw new UnsupportedOperationException();
    }

    public void remove(Object primaryKey) {
        throw new UnsupportedOperationException();
    }

    public DynamicClassLoader getClassLoader() {
        return this._loader;
    }

    public void setClassLoader(DynamicClassLoader loader) {
        this._loader = loader;
    }

    public Class getBeanSkelClass() {
        return this._contextImplClass;
    }

    public Class getRemoteStubClass() {
        return this._remoteStubClass;
    }

    public Class getHomeStubClass() {
        return this._homeStubClass;
    }

    public EJBMetaData getEJBMetaData() {
        if (this._metaData == null) {
            try {
                this._metaData = new EJBMetaDataImpl(this.getEJBHome(), this.getRemoteHomeClass(), this.getRemoteObjectClass(), this.getPrimaryKeyClass());
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            if (this instanceof StatelessServer) {
                this._metaData.setSession(true);
                this._metaData.setStatelessSession(true);
            } else if (this instanceof SessionServer) {
                this._metaData.setSession(true);
            }
        }
        return this._metaData;
    }

    public HomeHandle getHomeHandle() {
        if (this._homeHandle == null) {
            this._homeHandle = this.getHandleEncoder().createHomeHandle();
        }
        return this._homeHandle;
    }

    void setEJBHome(EJBHome remoteHome) {
        this._remoteHome = remoteHome;
    }

    public EJBHome getEJBHome() throws RemoteException {
        return this._remoteHomeView;
    }

    EJBHome getClientHome() throws RemoteException {
        return this.getEJBHome();
    }

    public Object getHomeObject() {
        return this._remoteHomeView;
    }

    public Object getRemoteObject() {
        return this.getHomeObject();
    }

    public Object getClientLocalHome() {
        return this._localHome;
    }

    public Object getClientObject() {
        return this.getClientLocalHome();
    }

    public EJBLocalHome getEJBLocalHome() {
        return this._localHome;
    }

    public Class getPrimaryKeyClass() {
        return this._primaryKeyClass;
    }

    EJBLocalObject getEJBLocalObject(AbstractContext context) {
        throw new UnsupportedOperationException();
    }

    public EJBObject getEJBObject(Object key) throws FinderException {
        return this.getContext(key).getEJBObject();
    }

    public AbstractContext getContext(Object key) throws FinderException {
        return this.getContext(key, true);
    }

    public AbstractContext getContext(long key) throws FinderException {
        return this.getContext(new Long(key));
    }

    public EjbTransactionManager getTransactionManager() {
        return this._ejbManager.getTransactionManager();
    }

    public TransactionContext getTransaction() {
        return this._ejbManager.getTransactionManager().getTransactionContext();
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public void setInitProgram(BuilderProgram init) {
        this._initProgram = init;
    }

    public BuilderProgram getInitProgram() {
        return this._initProgram;
    }

    public void initInstance(Object instance) throws Throwable {
        if (this._initProgram != null) {
            this._initProgram.configure(instance);
        }
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public boolean isDead() {
        return this._ejbManager == null;
    }

    protected void destroy() {
        this._ejbManager = null;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public String toString() {
        String name = this.getClass().getName();
        int p = name.lastIndexOf(46);
        return name.substring(p + 1) + "[" + this._ejbName + "]";
    }
}

