/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.java.AbstractGenerator;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;

abstract class MarshalGenerator
extends AbstractGenerator {
    static IntMap immutableClasses;
    protected static Class readerClass;
    protected static Class inputStreamClass;
    protected static Class remoteClass;
    protected static Class nodeClass;
    Class _cl;
    String objClass;
    String fullName;
    String pkg;
    String className;
    protected int unique;
    protected ArrayList marshallClasses;
    protected ArrayList unmarshallClasses;
    protected ArrayList marshallArrays;
    protected ArrayList unmarshallArrays;

    MarshalGenerator() {
    }

    Path initClassNames(Class beanClass, String suffix) throws Exception {
        ClassLoader parentLoader = this.getParentLoader();
        if (parentLoader instanceof DynamicClassLoader) {
            DynamicClassLoader dcl = (DynamicClassLoader)parentLoader;
            dcl.make();
        }
        Path workPath = CauchoSystem.getWorkPath();
        this._cl = beanClass;
        this.fullName = this._cl.getName() + suffix;
        this.objClass = this._cl.getName();
        int p = this.objClass.lastIndexOf(46);
        if (p > 0) {
            this.objClass = this.objClass.substring(p + 1);
        }
        if ((p = this.fullName.lastIndexOf(46)) > 0) {
            this.pkg = this.fullName.substring(0, p);
            this.className = this.fullName.substring(p + 1);
        } else {
            this.className = this.fullName;
        }
        Path path = workPath.lookup(this.fullName.replace('.', '/') + ".java");
        path.getParent().mkdirs();
        return path;
    }

    protected String mangleMethodName(String name, Method method, boolean isFull) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(name);
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            cb.append('_');
            this.mangleClass(cb, params[i], isFull);
        }
        return cb.close();
    }

    protected String mangleMethodName(String name, Class[] param, boolean isFull) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(name);
        for (int i = 0; i < param.length; ++i) {
            cb.append('_');
            this.mangleClass(cb, param[i], isFull);
        }
        return cb.close();
    }

    private void mangleClass(CharBuffer cb, Class cl, boolean isFull) {
        String name = cl.getName();
        if (name.equals("boolean")) {
            cb.append("boolean");
        } else if (name.equals("int") || name.equals("short") || name.equals("byte")) {
            cb.append("int");
        } else if (name.equals("long")) {
            cb.append("long");
        } else if (name.equals("double") || name.equals("float")) {
            cb.append("double");
        } else if (name.equals("java.lang.String") || name.equals("com.caucho.util.CharBuffer") || name.equals("char") || name.equals("java.io.Reader")) {
            cb.append("string");
        } else if (name.equals("java.util.Date") || name.equals("com.caucho.util.QDate")) {
            cb.append("date");
        } else if (inputStreamClass.isAssignableFrom(cl) || name.equals("[B")) {
            cb.append("binary");
        } else if (cl.isArray()) {
            cb.append("array_");
            this.mangleClass(cb, cl.getComponentType(), isFull);
        } else if (name.equals("org.w3c.dom.Node") || name.equals("org.w3c.dom.Element") || name.equals("org.w3c.dom.Document")) {
            cb.append("xml");
        } else if (isFull) {
            cb.append(name);
        } else {
            int p = name.lastIndexOf(46);
            if (p > 0) {
                cb.append(name.substring(p + 1));
            } else {
                cb.append(name);
            }
        }
    }

    protected void printMethodDeclaration(String name, Method method) throws IOException {
        int i;
        Class<?> ret = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        Class<?>[] exns = method.getExceptionTypes();
        this.println();
        this.print("public ");
        this.printClass(ret);
        this.print(" " + name + "(");
        for (i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.printClass(params[i]);
            this.print(" _arg" + i);
        }
        this.println(")");
        if (exns.length > 0) {
            this.print("  throws ");
        }
        for (i = 0; i < exns.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.printClass(exns[i]);
        }
        if (exns.length > 0) {
            this.println();
        }
    }

    protected void printUnmarshalType(Class cl) throws IOException {
        String name = cl.getName();
        if (cl.equals(Boolean.TYPE)) {
            this.println("in.readBoolean();");
        } else if (cl.equals(Integer.TYPE)) {
            this.println("in.readInt();");
        } else if (cl.equals(Short.TYPE) || cl.equals(Character.TYPE) || cl.equals(Byte.TYPE)) {
            this.println("(" + name + ") in.readInt();");
        } else if (cl.equals(Long.TYPE)) {
            this.println("in.readLong();");
        } else if (cl.equals(Double.TYPE)) {
            this.println("in.readDouble();");
        } else if (cl.equals(Float.TYPE)) {
            this.println("(" + name + ") in.readDouble();");
        } else if (cl.equals(ClassLiteral.getClass((String)"java/lang/String"))) {
            this.println("in.readString();");
        } else if (cl.equals(ClassLiteral.getClass((String)"java/util/Date"))) {
            this.println("new java.util.Date(in.readUTCDate());");
        } else if (cl.equals(ClassLiteral.getClass((String)"[B"))) {
            this.println("in.readBytes();");
        } else if (ClassLiteral.getClass((String)"org/w3c/dom/Node").isAssignableFrom(cl)) {
            this.println("in.readNode();");
        } else if (cl.equals(ClassLiteral.getClass((String)"java/lang/Object"))) {
            this.println("in.readObject();");
        } else {
            this.print("(");
            this.printClass(cl);
            this.print(") in.readObject(");
            this.printClass(cl);
            this.println(".class);");
        }
    }

    protected void printMarshalType(Class cl, String var) throws IOException {
        String name = cl.getName();
        if (cl.equals(Void.TYPE)) {
            this.println("out.writeNull();");
        } else if (cl.equals(Boolean.TYPE)) {
            this.println("out.writeBoolean(" + var + ");");
        } else if (cl.equals(Integer.TYPE) || cl.equals(Short.TYPE) || cl.equals(Character.TYPE) || cl.equals(Byte.TYPE)) {
            this.println("out.writeInt(" + var + ");");
        } else if (cl.equals(Long.TYPE)) {
            this.println("out.writeLong(" + var + ");");
        } else if (cl.equals(Double.TYPE) || cl.equals(Float.TYPE)) {
            this.println("out.writeDouble(" + var + ");");
        } else if (cl.equals(ClassLiteral.getClass((String)"java/lang/String"))) {
            this.println("out.writeString(" + var + ");");
        } else if (cl.equals(ClassLiteral.getClass((String)"java/util/Date"))) {
            this.println("out.writeUTCDate(" + var + " == null ? 0 : " + var + ".getTime());");
        } else if (ClassLiteral.getClass((String)"org/w3c/dom/Node").isAssignableFrom(cl)) {
            this.println("out.writeXml(" + var + ");");
        } else if (cl.equals(ClassLiteral.getClass((String)"[B"))) {
            this.println("out.writeBytes(" + var + ");");
        } else {
            this.println("out.writeObject(" + var + ");");
        }
    }

    boolean needsSerialization(Class cl) {
        if (cl.isPrimitive()) {
            return false;
        }
        return immutableClasses.get(cl) < 0;
    }

    protected void printNewArray(Class cl) throws IOException {
        if (!cl.isArray()) {
            this.print(cl.getName());
            this.print("[length]");
        } else {
            this.printNewArray(cl.getComponentType());
            this.print("[]");
        }
    }

    static {
        readerClass = ClassLiteral.getClass((String)"java/io/Reader");
        inputStreamClass = ClassLiteral.getClass((String)"java/io/InputStream");
        remoteClass = ClassLiteral.getClass((String)"java/rmi/Remote");
        nodeClass = ClassLiteral.getClass((String)"org/w3c/dom/Node");
        immutableClasses = new IntMap();
        immutableClasses.put(ClassLiteral.getClass((String)"java/lang/String"), 1);
        immutableClasses.put(ClassLiteral.getClass((String)"java/lang/Byte"), 1);
        immutableClasses.put(ClassLiteral.getClass((String)"java/lang/Character"), 1);
        immutableClasses.put(ClassLiteral.getClass((String)"java/lang/Short"), 1);
        immutableClasses.put(ClassLiteral.getClass((String)"java/lang/Integer"), 1);
        immutableClasses.put(ClassLiteral.getClass((String)"java/lang/Long"), 1);
        immutableClasses.put(ClassLiteral.getClass((String)"java/lang/Float"), 1);
        immutableClasses.put(ClassLiteral.getClass((String)"java/lang/Double"), 1);
        immutableClasses.put(ClassLiteral.getClass((String)"java/lang/Class"), 1);
    }
}

