/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmpProperty;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class CmpField
extends CmpProperty {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/CmpProperty"));
    private String _sqlColumn;
    private String _abstractSQLType;
    private String _sqlType;
    private Class _javaType = ClassLiteral.getClass((String)"java/lang/String");

    public CmpField(EjbEntityBean entity) {
        super(entity);
    }

    public String getSQLColumn() {
        return this._sqlColumn;
    }

    public void setSQLColumn(String sqlColumn) {
        this._sqlColumn = sqlColumn;
    }

    public String getSQLType() {
        return this._sqlType;
    }

    public void setSQLType(String sqlType) {
        this._sqlType = sqlType;
    }

    public String getAbstractSQLType() {
        return this._abstractSQLType;
    }

    public void setAbstractSQLType(String sqlType) {
        this._abstractSQLType = sqlType;
    }

    public void setJavaType(Class javaType) {
        this._javaType = javaType;
    }

    public Class getJavaType() {
        return this._javaType;
    }

    public void init() throws ConfigException {
        String name = this.getName();
        String getterName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        this.getEntity();
        Method getter = EjbEntityBean.getMethod(this.getEntity().getEJBClass(), getterName, new Class[0]);
        if (getter == null) {
            throw new ConfigException(L.l("{0}: '{1}' is an unknown cmp-field.  cmp-fields must have matching getter methods.", (Object)this.getEntity().getEJBClass().getName(), name));
        }
        if (!Modifier.isPublic(getter.getModifiers())) {
            throw new ConfigException(L.l("{0}: '{1}' must be public.  cmp-fields getters must be public.", (Object)this.getEntity().getEJBClass().getName(), EjbBean.getFullMethodName(getter)));
        }
        if (!Modifier.isAbstract(getter.getModifiers()) && !this.getEntity().isAllowPOJO()) {
            throw new ConfigException(L.l("{0}: '{1}' must be abstract.  cmp-fields getters must be abstract.", (Object)this.getEntity().getEJBClass().getName(), EjbBean.getFullMethodName(getter)));
        }
        if (getter.getExceptionTypes().length != 0) {
            throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", this.getEntity().getEJBClass().getName(), EjbBean.getFullMethodName(getter), getter.getExceptionTypes()[0].getName()));
        }
        this._javaType = getter.getReturnType();
        if (Void.TYPE.equals(this._javaType)) {
            throw new ConfigException(L.l("{0}: '{1}' must not return void.  CMP fields must not return void.", (Object)this.getEntity().getEJBClass().getName(), this.getName()));
        }
        if (ClassLiteral.getClass((String)"javax/ejb/EJBLocalObject").isAssignableFrom(this._javaType)) {
            throw new ConfigException(L.l("{0}: '{1}' must not return an EJB interface.  CMP fields must return concrete values.", (Object)this.getEntity().getEJBClass().getName(), this.getName()));
        }
        if (ClassLiteral.getClass((String)"javax/ejb/EJBObject").isAssignableFrom(this._javaType)) {
            throw new ConfigException(L.l("{0}: '{1}' must not return an EJB interface.  CMP fields must return concrete values.", (Object)this.getEntity().getEJBClass().getName(), this.getName()));
        }
        String setterName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        this.getEntity();
        Method setter = EjbEntityBean.getMethod(this.getEntity().getEJBClass(), setterName, new Class[]{getter.getReturnType()});
        if (setter != null) {
            if (!Modifier.isPublic(setter.getModifiers())) {
                throw new ConfigException(L.l("{0}: '{1}' must be public.  cmp-fields setters must be public.", (Object)this.getEntity().getEJBClass().getName(), EjbBean.getFullMethodName(setter)));
            }
            if (!Void.TYPE.equals(setter.getReturnType())) {
                throw new ConfigException(L.l("{0}: '{1}' must return void.  cmp-fields setters must return void.", (Object)this.getEntity().getEJBClass().getName(), EjbBean.getFullMethodName(setter)));
            }
            if (!Modifier.isAbstract(setter.getModifiers()) && !this.getEntity().isAllowPOJO()) {
                throw new ConfigException(L.l("{0}: '{1}' must be abstract.  cmp-fields setters must be abstract.", (Object)this.getEntity().getEJBClass().getName(), EjbBean.getFullMethodName(getter)));
            }
            if (setter.getExceptionTypes().length != 0) {
                throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", this.getEntity().getEJBClass().getName(), EjbBean.getFullMethodName(setter), setter.getExceptionTypes()[0].getName()));
            }
        }
        if (this._sqlColumn == null) {
            this._sqlColumn = CmpField.toSqlName(this.getName());
        }
    }

    public IdField createId(AmberManager amberManager, EntityType type) throws ConfigException {
        Class dataType;
        String fieldName = this.getName();
        String sqlName = this.getSQLColumn();
        if (sqlName == null) {
            sqlName = CmpField.toSqlName(fieldName);
        }
        if ((dataType = this.getJavaType()) == null) {
            throw new NullPointerException(L.l("'{0}' is an unknown field", fieldName));
        }
        Type amberType = amberManager.createType(dataType);
        Column column = type.getTable().createColumn(sqlName, amberType);
        KeyPropertyField idField = new KeyPropertyField(type, fieldName, column);
        if (Integer.TYPE.equals(dataType) || Long.TYPE.equals(dataType) || ClassLiteral.getClass((String)"java/lang/Integer").equals(dataType) || ClassLiteral.getClass((String)"java/lang/Long").equals(dataType)) {
            JdbcMetaData metaData = amberManager.getMetaData();
            if (metaData.supportsIdentity()) {
                idField.setGenerator("identity");
                column.setGeneratorType("identity");
            } else if (metaData.supportsSequences()) {
                idField.setGenerator("sequence");
                column.setGeneratorType("sequence");
                String name = type.getTable().getName() + "_cseq";
                type.setGenerator(idField.getName(), amberManager.createSequenceGenerator(name, 10));
            }
        }
        return idField;
    }

    static String toSqlName(String name) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isUpperCase(ch)) {
                cb.append(ch);
                continue;
            }
            if (i > 0 && !Character.isUpperCase(name.charAt(i - 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            if (i + 1 < name.length() && !Character.isUpperCase(name.charAt(i + 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            cb.append(Character.toLowerCase(ch));
        }
        return cb.toString();
    }

    public String toString() {
        return "CmpField[" + this.getName() + "]";
    }
}

