/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmpCollectionSetter;
import com.caucho.ejb.cfg.CmpField;
import com.caucho.ejb.cfg.CmpGetter;
import com.caucho.ejb.cfg.CmpIdGetter;
import com.caucho.ejb.cfg.CmrManyToMany;
import com.caucho.ejb.cfg.CmrManyToOne;
import com.caucho.ejb.cfg.CmrMap;
import com.caucho.ejb.cfg.CmrOneToMany;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.cfg.EjbEntityView;
import com.caucho.ejb.cfg.EjbManyToOneSetMethod;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;

public class EjbCmpView
extends EjbEntityView {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbCmpView"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbCmpView"));
    private EjbEntityBean _entityBean;

    public EjbCmpView(EjbEntityBean bean, Class apiClass, String prefix) throws ConfigException {
        super(bean, apiClass, prefix);
        this._entityBean = bean;
    }

    protected EjbMethod introspectEJBMethod(Method method) throws ConfigException {
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith("ejbSelect") && Modifier.isAbstract(method.getModifiers())) {
            this._entityBean.addStubMethod(method);
            return null;
        }
        return super.introspectEJBMethod(method);
    }

    protected EjbMethod createBusinessMethod(Method apiMethod, Method implMethod) throws ConfigException {
        String methodName = implMethod.getName();
        Class<?>[] paramTypes = implMethod.getParameterTypes();
        if (methodName.startsWith("get") && methodName.length() > 3 && paramTypes.length == 0) {
            String fieldName = this.toFieldName(methodName.substring(3));
            CmpField field = this._entityBean.getCmpField(fieldName);
            if (field != null) {
                this.validateCmpMethod(implMethod);
                if (this.isLocal() && apiMethod.getExceptionTypes().length != 0) {
                    throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", apiMethod.getDeclaringClass().getName(), EjbBean.getFullMethodName(apiMethod), apiMethod.getExceptionTypes()[0].getName()));
                }
                if (field.isId()) {
                    return new CmpIdGetter(this, apiMethod, implMethod);
                }
                return new CmpGetter(this, apiMethod, implMethod);
            }
            CmrRelation rel = this._entityBean.getRelation(fieldName);
            if (rel != null) {
                this.validateCmpMethod(implMethod);
                rel.setHasGetter(true);
                return rel.createGetter(this, apiMethod, implMethod);
            }
            if (!Modifier.isAbstract(implMethod.getModifiers())) {
                this.validateCmpMethod(implMethod);
                return new EjbMethod(this, apiMethod, implMethod);
            }
        } else if (methodName.startsWith("get") && methodName.length() > 3 && paramTypes.length == 1) {
            String fieldName = this.toFieldName(methodName.substring(3));
            CmrRelation rel = this._entityBean.getRelation(fieldName);
            if (rel instanceof CmrMap) {
                CmrMap map = (CmrMap)rel;
                this.validateCmpMethod(implMethod);
                rel.setHasGetter(true);
                return new CmpGetter(this, apiMethod, implMethod);
            }
        } else if (methodName.startsWith("set") && methodName.length() > 3 && paramTypes.length == 1) {
            String fieldName = this.toFieldName(methodName.substring(3));
            CmpField field = this._entityBean.getCmpField(fieldName);
            if (field != null) {
                this.validateCmpMethod(implMethod);
                if (this.isLocal() && apiMethod.getExceptionTypes().length != 0) {
                    throw new ConfigException(L.l("{0}: '{1}' must not throw {2}.  Container managed fields and relations must not throw exceptions.", this._entityBean.getEJBClass().getName(), EjbBean.getFullMethodName(apiMethod), apiMethod.getExceptionTypes()[0].getName()));
                }
                return new EjbMethod(this, apiMethod, implMethod);
            }
            CmrRelation rel = this._entityBean.getRelation(fieldName);
            if (rel instanceof CmrOneToMany) {
                this.validateCmpMethod(implMethod);
                return new CmpCollectionSetter(this, apiMethod, implMethod);
            }
            if (rel instanceof CmrManyToOne) {
                this.validateCmpMethod(implMethod);
                CmrManyToOne manyToOne = (CmrManyToOne)rel;
                return new EjbManyToOneSetMethod(this, apiMethod, implMethod, manyToOne);
            }
            if (rel instanceof CmrManyToMany) {
                this.validateCmpMethod(implMethod);
                return new CmpCollectionSetter(this, apiMethod, implMethod);
            }
            if (!Modifier.isAbstract(implMethod.getModifiers())) {
                this.validateCmpMethod(implMethod);
                return new EjbMethod(this, apiMethod, implMethod);
            }
            throw new ConfigException(L.l("{0}: abstract setter {1}.", (Object)implMethod.getDeclaringClass().getName(), EjbCmpView.getFullMethodName(implMethod)));
        }
        return super.createBusinessMethod(apiMethod, implMethod);
    }

    protected String toFieldName(String name) {
        if (name.length() == 0) {
            return "";
        }
        if (name.length() == 1) {
            return String.valueOf(Character.toLowerCase(name.charAt(0)));
        }
        if (Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    protected void validateCmpMethod(Method implMethod) throws ConfigException {
        if (!Modifier.isPublic(implMethod.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must be public.  CMP method implementations must be public.", (Object)implMethod.getDeclaringClass().getName(), EjbCmpView.getFullMethodName(implMethod)));
        }
        if (Modifier.isStatic(implMethod.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be static.  CMP method implementations must not be static.", (Object)implMethod.getDeclaringClass().getName(), EjbCmpView.getFullMethodName(implMethod)));
        }
    }
}

