/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.types.JndiBuilder;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.SecurityIdentity;
import com.caucho.ejb.message.MessageServer;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.NamingException;

public class EjbMessageBean
extends EjbBean {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbMessageBean"));
    private ConnectionFactory _connectionFactory;
    private Destination _destination;
    private boolean _isContainerTransaction = true;
    private int _acknowledgeMode = 1;
    private String _selector;
    private String _subscriptionName;
    private String _destinationType;
    private String _destinationLink;

    public EjbMessageBean(EjbConfig config) {
        super(config);
    }

    public String getEJBKind() {
        return "message";
    }

    public void setEJBClass(Class ejbClass) throws ConfigException {
        super.setEJBClass(ejbClass);
        if (!ClassLiteral.getClass((String)"javax/jms/MessageListener").isAssignableFrom(ejbClass)) {
            throw this.error(L.l("'{0}' must implement javax.jms.MessageListener.  Every message-driven bean must implement MessageListener.", ejbClass.getName()));
        }
        if (!ClassLiteral.getClass((String)"javax/ejb/MessageDrivenBean").isAssignableFrom(ejbClass) && !this.isAllowPOJO()) {
            throw this.error(L.l("'{0}' must implement javax.ejb.MessageDrivenBean.  Every message-driven bean must implement MessageDrivenBean.", ejbClass.getName()));
        }
        if (Modifier.isAbstract(ejbClass.getModifiers())) {
            throw this.error(L.l("'{0}' must not be abstract.  Every message-driven bean must be a fully-implemented class.", ejbClass.getName()));
        }
        Method create = EjbMessageBean.getMethod(ejbClass, "ejbCreate", new Class[0]);
        if (create == null) {
            if (!this.isAllowPOJO()) {
                throw this.error(L.l("{0}: ejbCreate() method is missing.  Every message-driven bean must have an ejbCreate() method.", ejbClass.getName()));
            }
        } else if (!Modifier.isPublic(create.getModifiers())) {
            throw this.error(L.l("{0}: ejbCreate() must be public.  Every message-driven bean must have a public ejbCreate method.", ejbClass.getName()));
        }
    }

    public MessageDrivenDestination createMessageDrivenDestination() {
        return new MessageDrivenDestination();
    }

    public void setDestination(JndiBuilder destination) throws ConfigException, NamingException {
        if (!(destination.getObject() instanceof Destination)) {
            throw new ConfigException(L.l("`{0}' needs to implement javax.jms.Destination.", destination.getObject()));
        }
        this._destination = (Destination)destination.getObject();
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void setMessageDestinationType(String type) throws ConfigException, NamingException {
        this._destinationType = type;
    }

    public void setMessageDestinationLink(String link) throws ConfigException, NamingException {
        this._destinationLink = link;
    }

    public void setConnectionFactory(JndiBuilder factory) throws ConfigException, NamingException {
        if (!(factory.getObject() instanceof ConnectionFactory)) {
            throw new ConfigException(L.l("`{0}' needs to implement javax.jms.ConnectionFactory.", factory.getObject()));
        }
        this._connectionFactory = (ConnectionFactory)factory.getObject();
    }

    public ConnectionFactory getConnectionFactory() {
        return this._connectionFactory;
    }

    public boolean getContainerTransaction() {
        return this._isContainerTransaction;
    }

    public void setContainerTransaction(boolean isContainerTransaction) {
        this._isContainerTransaction = isContainerTransaction;
    }

    public int getAcknowledgeMode() {
        return this._acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this._acknowledgeMode = acknowledgeMode;
    }

    public String getSelector() {
        return this._selector;
    }

    public void setSelector(String selector) {
        this._selector = selector;
    }

    public String getSubscriptionName() {
        return this._subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this._subscriptionName = subscriptionName;
    }

    public void setTransactionType(String type) throws ConfigException {
        if (!type.equals("Container") && !type.equals("Bean")) {
            throw new ConfigException(L.l("`{0}' is an unknown transaction-type.  transaction-type must be `Bean' or `Container'.", type));
        }
    }

    public void setSecurityIdentity(SecurityIdentity identity) {
    }

    public ActivationConfig createActivationConfig() {
        return new ActivationConfig();
    }

    public void init() throws ConfigException {
    }

    public AbstractServer deployServer(EjbServerManager ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException {
        MessageServer server = new MessageServer(ejbManager);
        server.setEJBName(this.getEJBName());
        server.setContextImplClass(this.getEJBClass());
        server.setDestination(this._destination);
        server.setInitProgram(this.getInitProgram());
        return server;
    }

    public class MessageDrivenDestination {
        public void setDestinationType(String value) throws ConfigException, NamingException {
            EjbMessageBean.this.setMessageDestinationType(value);
        }

        public void setSubscriptionDurability(String durability) {
        }

        public void setJndiName(JndiBuilder destination) throws ConfigException, NamingException {
            EjbMessageBean.this.setDestination(destination);
        }
    }

    public static class ActivationConfigProperty {
        String _name;
        String _value;

        public void setActivationConfigPropertyName(String name) {
            this._name = name;
        }

        public void setActivationConfigPropertyValue(String value) {
            this._value = value;
        }
    }

    public class ActivationConfig {
        public void addActivationConfigProperty(ActivationConfigProperty prop) {
        }
    }
}

