/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;

public class EjbMethodPattern {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbMethodPattern"));
    public static final int RESIN_DATABASE = 0;
    public static final int RESIN_READ_ONLY = 1;
    public static final int RESIN_ROW_LOCK = 2;
    private EjbBean _bean;
    private String _location;
    private MethodSignature _signature;
    private int _resinIsolation = -1;
    private int _jdbcIsolation = -1;
    private boolean _queryLoadsBean = true;
    private boolean _relationLoadsBean;
    private String _query;
    private String _queryLocation;
    private int _transactionType = -1;
    private ArrayList _roles;

    public EjbMethodPattern() {
    }

    public EjbMethodPattern(EjbBean bean, MethodSignature signature) {
        this._bean = bean;
        this._signature = signature;
    }

    public void setBean(EjbBean bean) {
        this._bean = bean;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getLocation() {
        return this._location;
    }

    public void setSignature(MethodSignature sig) {
        this._signature = sig;
    }

    public MethodSignature getSignature() {
        return this._signature;
    }

    public String getName() {
        return this._signature.getName();
    }

    public boolean isReadOnly() {
        return this._resinIsolation == 1;
    }

    public int getResinIsolation() {
        return this._resinIsolation;
    }

    public void setResinIsolation(String isolation) throws ConfigException {
        if (isolation.equals("read-only")) {
            this._resinIsolation = 1;
        } else if (isolation.equals("database")) {
            this._resinIsolation = 0;
        } else if (isolation.equals("row-locking")) {
            this._resinIsolation = 2;
        } else {
            throw new ConfigException(L.l("`{0}' is an unknown value for resin-isolation.  Only 'read-only', 'database', and 'row-locking' are allowed.", isolation));
        }
    }

    public int getJDBCIsolation() {
        return this._jdbcIsolation;
    }

    public void setJDBCIsolation(int isolation) {
        this._jdbcIsolation = isolation;
    }

    public String getQuery() {
        return this._query;
    }

    public void setQuery(String query) {
        this._query = query;
    }

    public String getQueryLocation() {
        return this._queryLocation;
    }

    public void setQueryLocation(String location) {
        this._queryLocation = location;
    }

    public int getTransactionType() {
        if (this._transactionType >= 0) {
            return this._transactionType;
        }
        if (this.isReadOnly()) {
            return 2;
        }
        return 3;
    }

    public void setTransaction(int type) throws ConfigException {
        this._transactionType = type;
    }

    public void setTransAttribute(String type) throws ConfigException {
        if ("Required".equals(type)) {
            this._transactionType = 3;
        } else if ("RequiresNew".equals(type)) {
            this._transactionType = 4;
        } else if ("Mandatory".equals(type)) {
            this._transactionType = 5;
        } else if ("NotSupported".equals(type)) {
            this._transactionType = 1;
        } else if ("Never".equals(type)) {
            this._transactionType = 6;
        } else if ("Supports".equals(type)) {
            this._transactionType = 2;
        } else {
            throw new ConfigException(L.l("`{0}' is an unknown transaction type.  The transaction types are:\n  Required - creates a new transaction if none is active.\n  RequiresNew - always creates a new transaction.\n  Mandatory - requires an active transaction.\n  NotSupported - suspends any active transaction.\n  Never - forbids any active transaction.\n  Supports - allows a transaction or no transaction.", type));
        }
    }

    public boolean getQueryLoadsBean() {
        return this._queryLoadsBean;
    }

    public void setQueryLoadsBean(boolean loadBean) {
        this._queryLoadsBean = loadBean;
    }

    public boolean getRelationLoadsBean() {
        return this._relationLoadsBean;
    }

    public void setRelationLoadsBean(boolean loadBean) {
        this._relationLoadsBean = loadBean;
    }

    public ArrayList getRoles() {
        return this._roles;
    }

    public void setRoles(ArrayList roles) {
        this._roles = roles;
    }

    public void setRoles(String[] roles) {
        if (roles != null) {
            if (this._roles == null) {
                this._roles = new ArrayList();
            }
            String[] arr$ = roles;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String role = arr$[i$];
                this._roles.add(role);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof EjbMethodPattern)) {
            return false;
        }
        EjbMethodPattern method = (EjbMethodPattern)o;
        return this._signature.equals(method.getSignature());
    }

    public String toString() {
        return "EJBMethodPattern[" + this._signature.getName() + "]";
    }
}

