/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.java.AbstractGenerator;
import java.io.IOException;
import java.lang.reflect.Method;

class EJBHomeGenerator
extends AbstractGenerator {
    protected Class skelClass;
    protected Class remoteClass;
    protected String prefix = "_ejb_lh_";

    EJBHomeGenerator(Class remoteClass, Class skelClass) {
        this.skelClass = skelClass;
        this.remoteClass = remoteClass;
        this.setFullClassName("_ejb." + remoteClass.getName() + "__Stub");
    }

    public void generateJava() throws IOException {
        this.printHeader();
        Method[] methods = this.remoteClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.getName().startsWith("javax.ejb.") && !methodName.equals("getPrimaryKey") && !methodName.equals("getEJBMetaData")) continue;
            if (methodName.startsWith("create")) {
                this.printCreateMethod(method.getName(), method);
                continue;
            }
            this.printMethod(method.getName(), method);
        }
        this.printFooter();
    }

    protected void printHeader() throws IOException {
        if (this.getPackageName() != null) {
            this.println("package " + this.getPackageName() + ";");
        }
        this.println();
        this.println("import java.io.*;");
        this.println("import java.rmi.*;");
        this.println("import " + this.skelClass.getName() + ";");
        this.println("import " + this.remoteClass.getName() + ";");
        this.println();
        this.println("public class " + this.getClassName());
        this.println("  extends com.caucho.ejb.SessionHome");
        this.println("  implements " + this.remoteClass.getName());
        this.println("{");
        this.pushDepth();
        this.println("private " + this.skelClass.getName() + " obj;");
        this.println();
        this.println("protected void _init(com.caucho.ejb.SessionServer server, javax.ejb.SessionBean obj)");
        this.println("{");
        this.println("  this.server = server;");
        this.println("  this.obj = (" + this.skelClass.getName() + ") obj;");
        this.println("}");
    }

    protected void printMethod(String name, Method method) throws IOException {
        Class<?> ret = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        this.printMethodHeader(name, method);
        this.println("{");
        this.pushDepth();
        if (!ret.getName().equals("void")) {
            this.printClass(ret);
            this.println(" _ret;");
        }
        if (!ret.getName().equals("void")) {
            this.print("_ret = ");
        }
        this.print("obj." + this.prefix + method.getName() + "(");
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.print("a" + i);
        }
        this.println(");");
        if (!ret.getName().equals("void")) {
            this.println("return _ret;");
        }
        this.popDepth();
        this.println("}");
    }

    protected void printCreateMethod(String name, Method method) throws IOException {
        Class<?> ret = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        this.printMethodHeader(name, method);
        this.println("{");
        this.pushDepth();
        this.println("com.caucho.ejb.AbstractContext cxt;");
        this.print("cxt = ");
        this.print("obj." + this.prefix + method.getName() + "(");
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.print("a" + i);
        }
        this.println(");");
        this.println("return (" + ret.getName() + ") cxt.getEJBLocalObject();");
        this.popDepth();
        this.println("}");
    }

    void printFooter() throws IOException {
        this.popDepth();
        this.println("}");
    }
}

