/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.message;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractContext;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.message.MessageDrivenContextImpl;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class MessageServer
extends AbstractServer
implements ServerSessionPool {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/message/MessageServer"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/message/MessageServer"));
    private Connection _connection;
    private MessageConsumer _consumer;
    private Destination _destination;
    private String _subscriptionName;
    private String _selector;
    private int _acknowledgeMode = 1;
    private MessageDrivenContext _context;
    private MessageListener _listener;
    private MessageSessionServer _server;

    public MessageServer(EjbServerManager manager) {
        super(manager);
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
        Connection connection;
        Class cl = this._contextImplClass;
        this._listener = (MessageListener)cl.newInstance();
        this._context = new MessageDrivenContextImpl(this);
        if (this._listener instanceof MessageDrivenBean) {
            MessageDrivenBean bean = (MessageDrivenBean)this._listener;
            bean.setMessageDrivenContext(this._context);
        }
        Method create = null;
        try {
            create = cl.getMethod("ejbCreate", new Class[0]);
            create.invoke((Object)this._listener, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (this._destination == null) {
            throw new ConfigException(L.l("No destination is configured."));
        }
        Session session = null;
        ConnectionFactory factory = null;
        if (factory == null) {
            factory = this._ejbManager.getConnectionFactory();
        }
        if (factory == null) {
            throw new ConfigException(L.l("Message beans need a jms-connection-factory.  The ConnectionFactory object must be configured."));
        }
        this._connection = connection = factory.createConnection();
        boolean transacted = true;
        session = connection.createSession(transacted, this._acknowledgeMode);
        if (this._subscriptionName != null) {
            Topic topic = (Topic)this._destination;
            this._consumer = session.createDurableSubscriber(topic, this._subscriptionName, this._selector, true);
        } else {
            this._consumer = session.createConsumer(this._destination, this._selector);
        }
        this._consumer.setMessageListener(this._listener);
        this._connection.start();
    }

    void generate() throws Exception {
    }

    public ServerSession getServerSession() {
        return this._server;
    }

    public AbstractContext getContext(Object obj, boolean foo) {
        throw new UnsupportedOperationException();
    }

    public Connection getJMSConnection() {
        return this._connection;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void destroy() {
        try {
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (this._listener != null && this._listener instanceof MessageDrivenBean) {
            MessageDrivenBean bean = (MessageDrivenBean)this._listener;
            this._listener = null;
            bean.ejbRemove();
        }
    }

    static class MessageSessionServer
    implements Runnable,
    ServerSession {
        private Session _session;
        private MessageListener _listener;

        MessageSessionServer(Session session, MessageListener listener) throws JMSException {
            this._session = session;
            this._listener = listener;
            session.setMessageListener(listener);
        }

        public Session getSession() throws JMSException {
            return this._session;
        }

        public void start() {
            this._session.run();
        }

        public void run() {
        }
    }
}

