/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.metadata;

import com.caucho.config.ConfigException;
import com.caucho.config.types.InitProgram;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbSessionBean;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.entity2.EntityIntrospector;
import com.caucho.ejb.metadata.JndiInjectProgram;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.ejb.Inject;
import javax.ejb.Local;
import javax.ejb.MethodPermissions;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

public class Bean {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/metadata/Bean"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/metadata/Bean"));
    private EjbServerManager _ejbManager;
    private EntityIntrospector _introspector;
    private Class _type;
    private String _name;
    private ArrayList<InitProgram> _initList = new ArrayList();

    public Bean(EjbServerManager ejbManager, EntityIntrospector introspector) {
        this._ejbManager = ejbManager;
        this._introspector = introspector;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setType(String typeName) throws ConfigException, ClassNotFoundException {
        this._type = Class.forName(typeName, false, this._ejbManager.getRawLoader());
        if (this._type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Stateless")) == null && this._type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Stateful")) == null && this._type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Entity")) == null) {
            throw new ConfigException(L.l("only stateless beans are currently supported."));
        }
    }

    public void addInit(InitProgram init) {
        this._initList.add(init);
    }

    public void init() throws ConfigException {
        block8: {
            if (this._type == null) {
                throw new ConfigException(L.l("type is a require attribute of ejb-server"));
            }
            Stateless stateless = (Stateless)this._type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Stateless"));
            Stateful stateful = (Stateful)this._type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Stateful"));
            try {
                if (stateless != null) {
                    this.configureStateless(this._type);
                    break block8;
                }
                if (stateful != null) {
                    this.configureStateful(this._type);
                    break block8;
                }
                if (this._type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Entity")) != null) {
                    this._introspector.introspect(this._type);
                    break block8;
                }
                throw new ConfigException(L.l("only stateless beans are currently supported."));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigException(e);
            }
        }
    }

    private void configureStateless(Class type) throws ConfigException {
        String className = type.getName();
        Stateless stateless = (Stateless)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Stateless"));
        EjbSessionBean bean = new EjbSessionBean(this._ejbManager.getConfig());
        bean.setAllowPOJO(true);
        bean.setSessionType("Stateless");
        bean.setTransactionType("Container");
        this.configureBean(bean, type, stateless.name());
    }

    private void configureStateful(Class type) throws ConfigException {
        String className = type.getName();
        Stateful stateful = (Stateful)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Stateful"));
        EjbSessionBean bean = new EjbSessionBean(this._ejbManager.getConfig());
        bean.setAllowPOJO(true);
        bean.setSessionType("Stateful");
        bean.setTransactionType("Container");
        this.configureBean(bean, type, stateful.name());
    }

    private void configureBean(EjbBean bean, Class type, String defaultName) throws ConfigException {
        MethodPermissions perms;
        TransactionAttribute xa;
        bean.setEJBClass(type);
        String name = this._name;
        if (name == null || name.equals("")) {
            name = defaultName;
        }
        if (name == null || name.equals("")) {
            String className = type.getName();
            int p = className.lastIndexOf(46);
            name = p > 0 ? className.substring(p + 1) : className;
        }
        bean.setEJBName(name);
        Class<?>[] ifs = type.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            Local local = (Local)ifs[i].getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Local"));
            if (local != null) {
                bean.setLocal(ifs[i]);
                continue;
            }
            Remote remote = (Remote)ifs[i].getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Remote"));
            if (remote == null && !ClassLiteral.getClass((String)"java/rmi/Remote").isAssignableFrom(ifs[i])) continue;
            bean.setRemote(ifs[i]);
        }
        if (bean.getLocal() == null && bean.getRemote() == null) {
            if (ifs.length == 0) {
                throw new ConfigException(L.l("'{0}' has no interfaces.  Can't currently generate.", type.getName()));
            }
            if (ifs.length != 1) {
                throw new ConfigException(L.l("'{0}' has multiple interfaces, but none are marked as @Local or @Remote.", type.getName()));
            }
            bean.setLocal(ifs[0]);
        }
        if ((xa = (TransactionAttribute)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/TransactionAttribute"))) != null) {
            MethodSignature sig = new MethodSignature();
            sig.setMethodName("*");
            EjbMethodPattern pattern = bean.createMethod(sig);
            this.setPatternTransaction(pattern, xa);
        }
        if ((perms = (MethodPermissions)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/MethodPermissions"))) != null) {
            MethodSignature sig = new MethodSignature();
            sig.setMethodName("*");
            EjbMethodPattern pattern = bean.createMethod(sig);
            pattern.setRoles(perms.value());
        }
        this.configureMethods(bean, type);
        for (int i = 0; i < this._initList.size(); ++i) {
            bean.addInitProgram(this._initList.get(i).getBuilderProgram());
        }
        bean.init();
        this._ejbManager.getConfig().setBeanConfig(bean.getEJBName(), bean);
    }

    private void configureMethods(EjbBean bean, Class type) throws ConfigException {
        Method[] methods = type.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodPermissions perms;
            Method method = methods[i];
            TransactionAttribute xa = (TransactionAttribute)method.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/TransactionAttribute"));
            if (xa != null) {
                EjbMethodPattern pattern = bean.createMethod(this.getSignature(method));
                this.setPatternTransaction(pattern, xa);
            }
            if ((perms = (MethodPermissions)method.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/MethodPermissions"))) == null) continue;
            EjbMethodPattern pattern = bean.createMethod(this.getSignature(method));
            pattern.setRoles(perms.value());
        }
    }

    private void setPatternTransaction(EjbMethodPattern pattern, TransactionAttribute xa) throws ConfigException {
        block7: {
            block6: {
                block5: {
                    block4: {
                        block3: {
                            block2: {
                                block1: {
                                    block0: {
                                        TransactionAttributeType transactionAttributeType = xa.value();
                                        transactionAttributeType.getClass();
                                        TransactionAttributeType transactionAttributeType2 = transactionAttributeType;
                                        if (transactionAttributeType2 == TransactionAttributeType.REQUIRED) break block0;
                                        if (transactionAttributeType2 == TransactionAttributeType.REQUIRESNEW) break block1;
                                        if (transactionAttributeType2 == TransactionAttributeType.MANDATORY) break block2;
                                        if (transactionAttributeType2 == TransactionAttributeType.SUPPORTS) break block3;
                                        if (transactionAttributeType2 == TransactionAttributeType.NOTSUPPORTED) break block4;
                                        if (transactionAttributeType2 == TransactionAttributeType.NEVER) break block5;
                                        break block6;
                                    }
                                    pattern.setTransaction(3);
                                    break block7;
                                }
                                pattern.setTransaction(4);
                                break block7;
                            }
                            pattern.setTransaction(5);
                            break block7;
                        }
                        pattern.setTransaction(2);
                        break block7;
                    }
                    pattern.setTransaction(1);
                    break block7;
                }
                pattern.setTransaction(6);
                break block7;
            }
            throw new IllegalStateException();
        }
    }

    private MethodSignature getSignature(Method method) throws ConfigException {
        MethodSignature sig = new MethodSignature();
        sig.setMethodName(method.getName());
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            sig.addParam(paramTypes[i].getName());
        }
        return sig;
    }

    private void configureInject(EjbBean bean, Method method, Inject inject) throws ConfigException {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1) {
            throw new ConfigException(L.l("method '{0}' must have a single value for injection.", method.getName()));
        }
        Class<?> paramType = paramTypes[0];
        String jndiName = inject.jndiName();
        String prefix = "";
        if (ClassLiteral.getClass((String)"javax/sql/DataSource").isAssignableFrom(paramType)) {
            prefix = "jdbc/";
        }
        if (jndiName == null || jndiName.equals("")) {
            if (ClassLiteral.getClass((String)"javax/transaction/UserTransaction").equals(paramType)) {
                jndiName = "java:comp/UserTransaction";
            } else {
                char ch;
                jndiName = method.getName();
                if (jndiName.startsWith("set") && jndiName.length() > 3 && Character.isUpperCase(ch = (jndiName = jndiName.substring(3)).charAt(0)) && (jndiName.length() == 4 || Character.isLowerCase(jndiName.charAt(1)))) {
                    jndiName = Character.toLowerCase(ch) + jndiName.substring(1);
                }
            }
        }
        int colon = jndiName.indexOf(58);
        int slash = jndiName.indexOf(47);
        if (colon < 0 || slash > 0 && slash < colon) {
            jndiName = "java:comp/env/" + prefix + jndiName;
        }
        JndiInjectProgram program = new JndiInjectProgram(jndiName, method);
        bean.addInitProgram(program);
    }
}

