/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InExpr
extends Expr {
    private Expr _expr;
    private ArrayList<Expr> _args;
    private boolean _isNot;

    InExpr(Query query, Expr expr, ArrayList<Expr> args, boolean isNot) throws ConfigException {
        this._query = query;
        this._expr = expr;
        this._args = args;
        this._isNot = isNot;
        this.evalTypes();
    }

    @Override
    void evalTypes() throws ConfigException {
        if (this.getJavaType() != null) {
            return;
        }
        for (int i = 0; i < this._args.size(); ++i) {
            Expr expr = this._args.get(i);
            if (expr.isString()) continue;
            throw this.error(L.l("'IN' literal requires strings at `{0}'", expr));
        }
        this.setJavaType(Boolean.TYPE);
    }

    @Override
    void generateWhere(CharBuffer cb) {
        this._expr.generateWhereSubExpr(cb);
        if (this._isNot) {
            cb.append(" NOT ");
        }
        cb.append(" IN (");
        for (int i = 0; i < this._args.size(); ++i) {
            Expr arg = this._args.get(i);
            if (i != 0) {
                cb.append(", ");
            }
            arg.generateWhereSubExpr(cb);
        }
        cb.append(")");
    }

    public String toString() {
        String str = this._expr.toString();
        if (this._isNot) {
            str = new StringBuffer().append(str).append(" NOT ").toString();
        }
        str = new StringBuffer().append(str).append(" IN (").toString();
        for (int i = 0; i < this._args.size(); ++i) {
            if (i != 0) {
                str = new StringBuffer().append(str).append(", ").toString();
            }
            Expr arg = this._args.get(i);
            str = new StringBuffer().append(str).append(arg).toString();
        }
        str = new StringBuffer().append(str).append(")").toString();
        return str;
    }
}

