/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.config.types.Signature;
import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class StaticMethodExpr
extends Expr {
    private Method _method;

    public StaticMethodExpr(Method method) {
        this._method = method;
    }

    public StaticMethodExpr(String signature) {
        try {
            Signature sig = new Signature();
            sig.addText(signature);
            sig.init();
            this._method = sig.getMethod();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public Object evalObject(VariableResolver env) throws ELException {
        return this._method;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.StaticMethodExpr(\"");
        this.printType(os, this._method.getReturnType());
        os.print(" ");
        os.print(this._method.getDeclaringClass().getName());
        os.print(".");
        os.print(this._method.getName());
        os.print("(");
        Class<?>[] parameterTypes = this._method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i != 0) {
                os.print(", ");
            }
            this.printType(os, parameterTypes[i]);
        }
        os.print(")");
        os.print("\")");
    }

    private void printType(WriteStream os, Class cl) throws IOException {
        if (cl.isArray()) {
            this.printType(os, cl.getComponentType());
            os.print("[]");
        } else {
            os.print(cl.getName());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof StaticMethodExpr)) {
            return false;
        }
        StaticMethodExpr expr = (StaticMethodExpr)o;
        return this._method.equals(expr._method);
    }
}

