/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESObject;
import com.caucho.es.ESThunk;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;

class NativeBoolean
extends Native {
    static final int NEW = 1;
    static final int TO_STRING = 2;
    static final int VALUE_OF = 3;

    private NativeBoolean(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static ESObject create(Global resin) {
        NativeBoolean nativeBool = new NativeBoolean("Boolean", 1, 1);
        ESWrapper boolProto = new ESWrapper("Boolean", (ESBase)resin.objProto, ESBoolean.FALSE);
        NativeWrapper bool = new NativeWrapper(resin, nativeBool, boolProto, 9);
        resin.boolProto = boolProto;
        NativeBoolean.put(boolProto, "toString", 2, 0, 4);
        NativeBoolean.put(boolProto, "valueOf", 3, 0, 4);
        bool.setClean();
        boolProto.setClean();
        return bool;
    }

    private static void put(ESObject obj, String name, int n, int len, int flags) {
        obj.put(name, (ESBase)new NativeBoolean(name, n, len), flags);
    }

    public ESBase call(Call eval, int length) throws Throwable {
        switch (this.n) {
            case 1: {
                if (length == 0) {
                    return ESBoolean.FALSE;
                }
                return ESBoolean.create(eval.getArg(0).toBoolean());
            }
            case 2: {
                try {
                    return ((ESWrapper)eval.getArg((int)-1)).value.toStr();
                }
                catch (ClassCastException e) {
                    if (eval.getArg(-1) instanceof ESBoolean) {
                        return eval.getArg(-1);
                    }
                    if (eval.getArg(-1) instanceof ESThunk) {
                        return ((ESWrapper)((ESThunk)eval.getArg((int)-1)).getObject()).value.toStr();
                    }
                    throw new ESException("toString expected boolean object");
                }
            }
            case 3: {
                try {
                    return ((ESWrapper)eval.getArg((int)-1)).value;
                }
                catch (ClassCastException e) {
                    if (eval.getArg(-1) instanceof ESBoolean) {
                        return eval.getArg(-1);
                    }
                    if (eval.getArg(-1) instanceof ESThunk) {
                        return ((ESWrapper)((ESThunk)eval.getArg((int)-1)).getObject()).value;
                    }
                    throw new ESException("valueOf expected boolean object");
                }
            }
        }
        throw new RuntimeException("Unknown object function");
    }

    public ESBase construct(Call eval, int length) throws Throwable {
        if (this.n != 1) {
            return super.construct(eval, length);
        }
        ESBoolean value = length == 0 ? ESBoolean.FALSE : ESBoolean.create(eval.getArg(0).toBoolean());
        return ((ESBase)value).toObject();
    }
}

