/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.Global;
import com.caucho.es.Native;
import java.util.Random;

class NativeMath
extends Native {
    static final int ABS = 1;
    static final int ACOS = 2;
    static final int ASIN = 3;
    static final int ATAN = 4;
    static final int ATAN2 = 5;
    static final int CEIL = 6;
    static final int COS = 7;
    static final int EXP = 8;
    static final int FLOOR = 9;
    static final int LOG = 10;
    static final int MAX = 11;
    static final int MIN = 12;
    static final int POW = 13;
    static final int RANDOM = 14;
    static final int ROUND = 15;
    static final int SET_SEED = 16;
    static final int SIN = 17;
    static final int SQRT = 18;
    static final int TAN = 19;
    Random random;

    private NativeMath(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static ESObject create(Global resin) {
        ESObject math = new ESObject("Math", null);
        NativeMath.put(math, "abs", 1, 1);
        NativeMath.put(math, "asin", 3, 1);
        NativeMath.put(math, "acos", 2, 1);
        NativeMath.put(math, "atan", 4, 1);
        NativeMath.put(math, "atan2", 5, 2);
        NativeMath.put(math, "ceil", 6, 1);
        NativeMath.put(math, "cos", 7, 1);
        NativeMath.put(math, "exp", 8, 1);
        NativeMath.put(math, "floor", 9, 1);
        NativeMath.put(math, "log", 10, 1);
        NativeMath.put(math, "max", 11, 2);
        NativeMath.put(math, "min", 12, 2);
        NativeMath.put(math, "pow", 13, 2);
        NativeMath.put(math, "round", 15, 1);
        NativeMath.put(math, "sin", 17, 1);
        NativeMath.put(math, "sqrt", 18, 1);
        NativeMath.put(math, "tan", 19, 1);
        NativeMath.put(math, "random", 14, 0);
        NativeMath.put(math, "setSeed", 16, 1);
        int flags = 7;
        math.put("E", (ESBase)ESNumber.create(Math.E), flags);
        math.put("LN10", (ESBase)ESNumber.create(Math.log(10.0)), flags);
        math.put("LN2", (ESBase)ESNumber.create(Math.log(2.0)), flags);
        math.put("LOG2E", (ESBase)ESNumber.create(1.0 / Math.log(2.0)), flags);
        math.put("LOG10E", (ESBase)ESNumber.create(1.0 / Math.log(10.0)), flags);
        math.put("PI", (ESBase)ESNumber.create(Math.PI), flags);
        math.put("SQRT1_2", (ESBase)ESNumber.create(Math.sqrt(0.5)), flags);
        math.put("SQRT2", (ESBase)ESNumber.create(Math.sqrt(2.0)), flags);
        Random random = new Random();
        try {
            ((NativeMath)math.getProperty((String)"random")).random = random;
            ((NativeMath)math.getProperty((String)"setSeed")).random = random;
        }
        catch (Throwable e) {
            // empty catch block
        }
        math.setClean();
        return math;
    }

    private static void put(ESObject obj, String name, int n, int length) {
        obj.put(name, (ESBase)new NativeMath(name, n, length), 4);
    }

    public ESBase call(Call eval, int length) throws Throwable {
        switch (this.n) {
            case 1: {
                if (length == 0) {
                    return esUndefined;
                }
                double arg = eval.getArg(0).toNum();
                return ESNumber.create(arg == 0.0 ? 0.0 : (arg < 0.0 ? -arg : arg));
            }
            case 2: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.acos(eval.getArg(0).toNum()));
            }
            case 3: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.asin(eval.getArg(0).toNum()));
            }
            case 4: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.atan(eval.getArg(0).toNum()));
            }
            case 5: {
                if (length < 2) {
                    return esUndefined;
                }
                return ESNumber.create(Math.atan2(eval.getArg(0).toNum(), eval.getArg(1).toNum()));
            }
            case 6: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.ceil(eval.getArg(0).toNum()));
            }
            case 7: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.cos(eval.getArg(0).toNum()));
            }
            case 8: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.exp(eval.getArg(0).toNum()));
            }
            case 9: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.floor(eval.getArg(0).toNum()));
            }
            case 10: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.log(eval.getArg(0).toNum()));
            }
            case 11: {
                double arg = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < length; ++i) {
                    double v = eval.getArg(i).toNum();
                    arg = Math.max(v, arg);
                }
                return ESNumber.create(arg);
            }
            case 12: {
                double arg = Double.POSITIVE_INFINITY;
                for (int i = 0; i < length; ++i) {
                    double v = eval.getArg(i).toNum();
                    arg = Math.min(v, arg);
                }
                return ESNumber.create(arg);
            }
            case 13: {
                if (length < 2) {
                    return esUndefined;
                }
                return ESNumber.create(Math.pow(eval.getArg(0).toNum(), eval.getArg(1).toNum()));
            }
            case 14: {
                if (length > 1) {
                    int n = eval.getArg(0).toInt32();
                    if (n > 0) {
                        return ESNumber.create((int)(this.random.nextDouble() * (double)n));
                    }
                } else {
                    return ESNumber.create(this.random.nextDouble());
                }
            }
            case 15: {
                if (length == 0) {
                    return esUndefined;
                }
                double arg = eval.getArg(0).toNum();
                if (arg >= -0.5 && arg < 0.5) {
                    return ESNumber.create(Math.rint(arg));
                }
                return ESNumber.create(Math.floor(arg + 0.5));
            }
            case 16: {
                if (length != 0) {
                    this.random.setSeed((long)eval.getArg(0).toNum());
                }
                return esUndefined;
            }
            case 17: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.sin(eval.getArg(0).toNum()));
            }
            case 18: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.sqrt(eval.getArg(0).toNum()));
            }
            case 19: {
                if (length == 0) {
                    return esUndefined;
                }
                return ESNumber.create(Math.tan(eval.getArg(0).toNum()));
            }
        }
        throw new ESException("Undefined math function");
    }
}

