/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESObject;
import com.caucho.es.ESRegexp;
import com.caucho.es.ESRegexpWrapper;
import com.caucho.es.ESString;
import com.caucho.es.ESThunk;
import com.caucho.es.Global;
import com.caucho.es.Native;

class NativeRegexp
extends Native {
    static ESId INDEX = ESId.intern("index");
    static ESId INPUT = ESId.intern("input");
    static final int NEW = 1;
    static final int COMPILE = 2;
    static final int EXEC = 3;
    static final int TEST = 4;
    static final int TO_STRING = 5;

    private NativeRegexp(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static ESRegexpWrapper create(Global resin) {
        ESRegexp proto;
        NativeRegexp nativeRegexp = new NativeRegexp("Regexp", 1, 1);
        try {
            proto = new ESRegexp("", "");
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        proto.prototype = resin.objProto;
        resin.regexpProto = proto;
        ESRegexpWrapper regexp = new ESRegexpWrapper(resin, nativeRegexp, proto);
        NativeRegexp.put(proto, "exec", 3, 1);
        NativeRegexp.put(proto, "compile", 2, 2);
        NativeRegexp.put(proto, "test", 4, 1);
        NativeRegexp.put(proto, "toString", 5, 0);
        proto.setClean();
        regexp.setClean();
        return regexp;
    }

    private static void put(ESObject proto, String name, int n, int len) {
        ESId id = ESId.intern(name);
        NativeRegexp fun = new NativeRegexp(name, n, len);
        proto.put(id, (ESBase)fun, 4);
    }

    public ESBase call(Call eval, int length) throws Throwable {
        switch (this.n) {
            case 1: {
                return this.create(eval, length);
            }
            case 5: {
                try {
                    ESRegexp regexp = (ESRegexp)eval.getThis();
                    String s = regexp.pattern.toString();
                    String f = regexp.flags.toString();
                    return ESString.create("/" + s + "/" + f);
                }
                catch (ClassCastException e) {
                    throw new ESException("toString expected regexp object");
                }
            }
            case 3: {
                return NativeRegexp.exec(eval, length);
            }
            case 2: {
                return this.compile(eval, length);
            }
            case 4: {
                return this.test(eval, length);
            }
        }
        throw new ESException("Unknown object function");
    }

    private ESBase create(Call eval, int length) throws Throwable {
        ESString flags = null;
        ESString pattern = length == 0 ? ESString.NULL : eval.getArg(0).toStr();
        flags = length > 1 ? eval.getArg(1).toStr() : ESString.NULL;
        ESRegexp obj = new ESRegexp(pattern, flags);
        return obj;
    }

    private ESBase compile(Call eval, int length) throws Throwable {
        ESString flags = null;
        ESBase arg = eval.getArg(-1);
        if (arg instanceof ESThunk) {
            arg = ((ESThunk)arg).toObject();
        }
        if (!(arg instanceof ESRegexp)) {
            throw new ESException("compile must be bound to regexp");
        }
        ESRegexp regexp = (ESRegexp)arg;
        if (length == 0) {
            return esUndefined;
        }
        ESString pattern = eval.getArg(0).toStr();
        flags = length > 1 ? eval.getArg(1).toStr() : ESString.NULL;
        regexp.compile(pattern, flags);
        return regexp;
    }

    static ESBase exec(Call eval, int length) throws Throwable {
        ESString string;
        ESBase reg = eval.getArg(-1);
        if (reg instanceof ESThunk) {
            reg = ((ESThunk)reg).toObject();
        }
        ESRegexp regexp = reg instanceof ESRegexp ? (ESRegexp)reg : new ESRegexp(reg.toStr(), ESString.NULL);
        if (regexp.prototype == null) {
            throw new RuntimeException();
        }
        Global global = Global.getGlobalProto();
        if (length == 0) {
            ESRegexpWrapper eSRegexpWrapper = global.getRegexp();
            global.getRegexp();
            string = eSRegexpWrapper.getProperty(ESRegexpWrapper.INPUT).toStr();
        } else {
            string = eval.getArg(0).toStr();
        }
        global.getRegexp().setRegexp(regexp);
        if (!regexp.exec(string)) {
            return esNull;
        }
        return esNull;
    }

    private ESBase test(Call eval, int length) throws Throwable {
        ESBase reg = eval.getArg(-1);
        if (reg instanceof ESThunk) {
            reg = ((ESThunk)reg).toObject();
        }
        ESRegexp regexp = reg instanceof ESRegexp ? (ESRegexp)reg : new ESRegexp(reg.toStr(), ESString.NULL);
        if (regexp.prototype == null) {
            throw new RuntimeException();
        }
        ESRegexpWrapper globalRegexp = Global.getGlobalProto().getRegexp();
        ESString string = length == 0 ? globalRegexp.getProperty(ESRegexpWrapper.INPUT).toStr() : eval.getArg(0).toStr();
        globalRegexp.setRegexp(regexp);
        return ESBoolean.create(regexp.exec(string));
    }
}

