/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESException;
import com.caucho.es.ESString;
import com.caucho.util.CharBuffer;

class Printf {
    private static final int ALT = 1;
    private static final int ZERO_FILL = 2;
    private static final int POS_PLUS = 4;
    private static final int POS_SPACE = 8;
    private static final int LALIGN = 16;
    private static final int BIG = 32;
    private static final int NO_TRAIL_ZERO = 64;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static char[] bigDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Printf() {
    }

    public static String sprintf(Call eval, int length) throws Throwable {
        if (length == 0) {
            return "";
        }
        CharBuffer buf = new CharBuffer();
        Printf.printf(buf, eval.getArg(0).toStr(), eval, length);
        return buf.toString();
    }

    public static CharBuffer printf(CharBuffer result, ESString format, Call eval, int length) throws Throwable {
        int arg = 1;
        int len = format.length();
        block18: for (int i = 0; i < len; ++i) {
            int start = i;
            char ch = format.charAt(i);
            if (ch != '%') {
                result.append(ch);
                continue;
            }
            int flags = 0;
            block19: while (++i < len) {
                ch = format.charAt(i);
                switch (ch) {
                    case '0': {
                        flags |= 2;
                        continue block19;
                    }
                    case '+': {
                        flags |= 4;
                        continue block19;
                    }
                    case ' ': {
                        flags |= 8;
                        continue block19;
                    }
                    case '#': {
                        flags |= 1;
                        continue block19;
                    }
                    case '-': {
                        flags |= 0x10;
                        continue block19;
                    }
                }
            }
            int width = 0;
            while (i < len && (ch = format.charAt(i)) >= '0' && ch <= '9') {
                width = 10 * width + ch - 48;
                ++i;
            }
            if (i >= len) {
                Printf.fixBits(result, format, start, i);
                break;
            }
            int prec = 0;
            if (ch == '.') {
                while (++i < len && (ch = format.charAt(i)) >= '0' && ch <= '9') {
                    prec = 10 * prec + ch - 48;
                }
            } else {
                prec = -1;
            }
            if (i >= len) {
                Printf.fixBits(result, format, start, i);
                break;
            }
            switch (ch) {
                case '%': {
                    result.append('%');
                    continue block18;
                }
                case 'd': {
                    if (arg >= length) {
                        throw new ESException("missing printf argument");
                    }
                    Printf.formatInteger(result, eval.getArg(arg++).toNum(), width, prec, flags, 10);
                    continue block18;
                }
                case 'o': {
                    if (arg >= length) {
                        throw new ESException("missing printf argument");
                    }
                    Printf.formatInteger(result, eval.getArg(arg++).toNum(), width, prec, flags, 8);
                    continue block18;
                }
                case 'X': {
                    flags |= 0x20;
                }
                case 'x': {
                    if (arg >= length) {
                        throw new ESException("missing printf argument");
                    }
                    Printf.formatInteger(result, eval.getArg(arg++).toNum(), width, prec, flags, 16);
                    continue block18;
                }
                case 'E': 
                case 'G': {
                    flags |= 0x20;
                }
                case 'e': 
                case 'f': 
                case 'g': {
                    if (arg >= length) {
                        throw new ESException("missing printf argument");
                    }
                    Printf.formatDouble(result, eval.getArg(arg++).toNum(), width, prec, flags, ch);
                    continue block18;
                }
                case 'c': {
                    if (arg >= length) {
                        throw new ESException("missing printf argument");
                    }
                    Printf.formatChar(result, (int)eval.getArg(arg++).toNum(), width, flags);
                    continue block18;
                }
                case 's': {
                    if (arg >= length) {
                        throw new ESException("missing printf argument");
                    }
                    Printf.formatString(result, eval.getArg(arg++).toStr(), prec, width, flags);
                    continue block18;
                }
                default: {
                    Printf.fixBits(result, format, start, i + 1);
                }
            }
        }
        return result;
    }

    private static void formatDouble(CharBuffer cb, double value, int prec, int flags, int type) {
        int i;
        String raw = Double.toString(value);
        int expt = 0;
        CharBuffer digits = new CharBuffer();
        char ch = raw.charAt(i);
        boolean seenDigit = false;
        for (i = 0; i < raw.length() && (ch = raw.charAt(i)) != '.' && ch != 'e' && ch != 'E'; ++i) {
            if (!seenDigit && ch == '0') continue;
            seenDigit = true;
            digits.append(ch);
            ++expt;
        }
        if (ch == '.') {
            ++i;
        }
        while (i < raw.length()) {
            ch = raw.charAt(i);
            if (!seenDigit && ch == '0') {
                --expt;
            } else if (ch >= '0' && ch <= '9') {
                digits.append(ch);
                seenDigit = true;
            } else {
                int sign = 1;
                if ((ch = raw.charAt(++i)) == '+') {
                    ++i;
                } else if (ch == '-') {
                    ++i;
                    sign = -1;
                }
                int e = 0;
                while (i < raw.length() && (ch = raw.charAt(i)) >= '0' && ch <= '9') {
                    e = 10 * e + ch - 48;
                    ++i;
                }
                expt += sign * e;
                break;
            }
            ++i;
        }
        if (!seenDigit) {
            expt = 1;
        }
        while (digits.length() > 0 && digits.charAt(digits.length() - 1) == '0') {
            digits.setLength(digits.length() - 1);
        }
        if (type == 102) {
            if (Printf.roundDigits(digits, expt + prec)) {
                ++expt;
            }
            Printf.formatFixed(cb, digits, expt, prec, flags);
        } else if (type == 101 || type == 69) {
            if (Printf.roundDigits(digits, prec + 1)) {
                ++expt;
            }
            Printf.formatExpt(cb, digits, expt, prec, flags);
        } else {
            if (Printf.roundDigits(digits, prec)) {
                ++expt;
            }
            if (expt < -3 || expt > prec) {
                Printf.formatExpt(cb, digits, expt, prec - 1, flags | 0x40);
            } else {
                Printf.formatFixed(cb, digits, expt, prec - expt, flags | 0x40);
            }
        }
    }

    private static void formatDouble(CharBuffer cb, double value, int width, int prec, int flags, int type) {
        if (prec < 0) {
            prec = 6;
        }
        int offset = cb.length();
        if ((flags & 2) != 0 && (value < 0.0 || (flags & 0xC) != 0)) {
            ++offset;
            --width;
        }
        if (value < 0.0) {
            cb.append('-');
            value = -value;
        } else if ((flags & 4) != 0) {
            cb.append('+');
        } else if ((flags & 8) != 0) {
            cb.append(' ');
        }
        Printf.formatDouble(cb, value, prec, flags, type);
        width -= cb.length() - offset;
        for (int i = 0; i < width; ++i) {
            if ((flags & 0x10) != 0) {
                cb.append(' ');
                continue;
            }
            cb.insert(offset, (flags & 2) == 0 ? (char)' ' : '0');
        }
    }

    private static boolean roundDigits(CharBuffer digits, int len) {
        if (len < 0 || digits.length() <= len) {
            return false;
        }
        char value = digits.charAt(len);
        if (value < '5') {
            return false;
        }
        for (int i = len - 1; i >= 0; --i) {
            char ch = digits.charAt(i);
            if (ch != '9') {
                digits.setCharAt(i, (char)(ch + '\u0001'));
                return false;
            }
            digits.setCharAt(i, '0');
        }
        digits.insert(0, '1');
        return true;
    }

    private static void formatFixed(CharBuffer cb, CharBuffer digits, int expt, int prec, int flags) {
        int i = 0;
        int origExpt = expt;
        while (expt > 0) {
            if (i < digits.length()) {
                cb.append(digits.charAt(i++));
            } else {
                cb.append('0');
            }
            --expt;
        }
        if (origExpt <= 0) {
            cb.append('0');
        }
        if (prec > 0 || (flags & 1) != 0) {
            cb.append('.');
        }
        while (expt < 0 && prec > 0) {
            cb.append('0');
            --prec;
            ++expt;
        }
        while (prec > 0 && i < digits.length()) {
            cb.append(digits.charAt(i));
            --prec;
            ++i;
        }
        while (prec > 0 && (flags & 0x41) != 64) {
            cb.append('0');
            --prec;
        }
    }

    private static void formatExpt(CharBuffer cb, CharBuffer digits, int expt, int prec, int flags) {
        if (digits.length() == 0) {
            cb.append('0');
        } else {
            cb.append(digits.charAt(0));
        }
        if (prec > 0 || (flags & 1) != 0) {
            cb.append('.');
        }
        for (int i = 1; i < digits.length(); ++i) {
            if (prec > 0) {
                cb.append(digits.charAt(i));
            }
            --prec;
        }
        while (prec > 0 && (flags & 0x41) != 64) {
            cb.append('0');
            --prec;
        }
        if ((flags & 0x20) != 0) {
            cb.append('E');
        } else {
            cb.append('e');
        }
        Printf.formatInteger(cb, expt - 1, 0, 2, 4, 10);
    }

    private static void formatInteger(CharBuffer cb, double dvalue, int width, int prec, int flags, int radix) {
        boolean isBig = (flags & 0x20) != 0;
        int begin = cb.length();
        long value = dvalue > 0.0 ? (long)(dvalue + 0.5) : (long)(dvalue - 0.5);
        if (value < 0L && radix == 10) {
            cb.append('-');
            value = -value;
        } else if (value >= 0L && radix == 10 && (flags & 4) != 0) {
            cb.append('+');
        } else if (value >= 0L && radix == 10 && (flags & 8) != 0) {
            cb.append(' ');
        } else if (value < 0L) {
            value &= 0xFFFFFFFFL;
        } else if (radix == 8 && (flags & 1) != 0 && value != 0L) {
            cb.append('0');
        } else if (radix == 16 && (flags & 1) != 0) {
            cb.append((flags & 0x20) == 0 ? "0x" : "0X");
        }
        if ((flags & 2) != 0) {
            width -= cb.length() - begin;
            begin = cb.length();
        }
        int offset = cb.length();
        int len = 0;
        while (value != 0L) {
            ++len;
            cb.insert(offset, (isBig ? bigDigits : digits)[(int)(value % (long)radix)]);
            value /= (long)radix;
        }
        for (int i = 0; i < prec - len; ++i) {
            cb.insert(offset, '0');
        }
        if (len == 0 && prec == 0) {
            cb.insert(offset, '0');
        }
        width -= cb.length() - begin;
        while (width > 0) {
            if ((flags & 0x10) != 0) {
                cb.append(' ');
            } else if ((flags & 2) != 0 && prec < 0) {
                cb.insert(begin, '0');
            } else {
                cb.insert(begin, ' ');
            }
            --width;
        }
        if (cb.length() == begin) {
            cb.append('0');
        }
    }

    private static void formatChar(CharBuffer cb, int ch, int width, int flags) {
        int offset = cb.length();
        cb.append((char)ch);
        if ((flags & 0x10) == 0) {
            for (int i = 0; i < width - 1; ++i) {
                cb.insert(offset, ' ');
            }
        } else {
            for (int i = 0; i < width - 1; ++i) {
                cb.append(' ');
            }
        }
    }

    private static void formatString(CharBuffer cb, ESString string, int prec, int width, int flags) {
        int i;
        int offset = cb.length();
        if (prec < 0) {
            prec = Integer.MAX_VALUE;
        }
        for (i = 0; i < string.length() && i < prec; ++i) {
            --width;
            cb.append(string.charAt(i));
        }
        if ((flags & 0x10) == 0) {
            for (i = 0; i < width; ++i) {
                cb.insert(offset, ' ');
            }
        } else {
            for (i = 0; i < width; ++i) {
                cb.append(' ');
            }
        }
    }

    private static void fixBits(CharBuffer cb, ESString format, int s, int i) {
        while (s < i) {
            cb.append(format.charAt(s));
            ++s;
        }
    }
}

