/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.TypeExpr;
import com.caucho.util.CauchoSystem;

class JavaTypeExpr
extends TypeExpr {
    JavaTypeExpr(Block block, String className) {
        super(block, null);
        this.type = 6;
        this._typeName = className;
        try {
            this.javaType = CauchoSystem.loadClass(className, false, block.getClassLoader());
        }
        catch (Exception e) {
            this.type = 1;
        }
    }

    JavaTypeExpr(Block block, Class javaClass) {
        super(block, null);
        this.type = 6;
        this.javaType = javaClass;
        this._typeName = this.getTypeName(javaClass);
    }

    private String getTypeName(Class cl) {
        if (cl.isArray()) {
            return this.getTypeName(cl.getComponentType()) + "[]";
        }
        return cl.getName();
    }

    Expr fieldReference(ESId id) throws ESException {
        if (this._typeName.equals("")) {
            return new JavaTypeExpr(this.block, id.toString());
        }
        return new JavaTypeExpr(this.block, this._typeName + "." + id);
    }

    public String toString() {
        return "[JavaTypeExpr " + this.javaType + " " + this.type + "]";
    }
}

