/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.Version;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESId;
import com.caucho.es.ESNull;
import com.caucho.es.ESNumber;
import com.caucho.es.ESString;
import com.caucho.es.ESUndefined;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.JavaTypeExpr;
import com.caucho.es.parser.Parser;
import com.caucho.es.parser.TypeExpr;
import com.caucho.es.parser.Variable;
import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class ParseClass {
    private String srcFilename;
    private LineMap lineMap;
    private Parser parser;
    private String className;
    private String pkg;
    private String name;
    private ESId proto;
    private ParseClass root;
    private HashMap variables = new HashMap();
    private ArrayList classes = new ArrayList();
    private ArrayList functions = new ArrayList();
    private IntMap funMap = new IntMap();
    private HashMap names = new HashMap();
    private HashMap literals = new HashMap();
    private HashMap mangledSet = new HashMap();
    private Function global;
    private int unique;
    private int callDepth;
    private ArrayList imports = new ArrayList();
    private ArrayList javaImports = new ArrayList();
    private WriteStream os;
    private int printDepth;
    private boolean isFirst;
    private int destLine;
    private Path sourcePath;

    ParseClass(String srcFilename, String name) {
        this.srcFilename = srcFilename;
        this.root = this;
        this.className = name;
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            this.pkg = name.substring(0, p);
            this.name = name.substring(p + 1);
        } else {
            this.name = name;
        }
        this.lineMap = new LineMap(name, srcFilename);
        this.lineMap.add(1, 1);
        this.destLine = 1;
    }

    void setSourcePath(Path sourcePath) {
        this.sourcePath = sourcePath;
    }

    Path getScriptPath() {
        return this.root.parser.getScriptPath();
    }

    void setParser(Parser parser) {
        this.root.parser = parser;
    }

    void setWriteStream(WriteStream os) {
        this.os = os;
    }

    ParseClass newClass(ESId id) {
        ParseClass cl = new ParseClass(this.srcFilename, id.toString());
        this.classes.add(cl);
        cl.root = this.root;
        return cl;
    }

    Function newFunction(Function oldFun, ESId id, boolean isClass) {
        if (id == null) {
            id = ESId.intern("$lambda" + this.unique++);
        }
        String realId = "_f_" + id.toString();
        while (this.names.get(realId) != null) {
            realId = realId + this.unique++;
        }
        this.names.put(realId, realId);
        Function fun = new Function(this, oldFun, realId, id, isClass);
        this.setFunction(fun);
        return fun;
    }

    void setFunction(Function function) {
        int index = this.funMap.get(function.name);
        if (index >= 0) {
            function.num = index;
            this.functions.set(index, function);
        } else {
            function.num = this.functions.size();
            this.funMap.put(function.name, this.functions.size());
            this.functions.add(function);
        }
    }

    void addImport(String importName) {
        if (!this.imports.contains(importName)) {
            this.imports.add(importName);
        }
    }

    void addJavaImport(String importName) {
        if (!this.javaImports.contains(importName)) {
            this.javaImports.add(importName);
        }
    }

    Variable getVariable(ESId id) {
        return (Variable)this.variables.get(id);
    }

    void addVariable(ESId id, Variable var) {
        this.variables.put(id, var);
        var.setJavaGlobal(true);
    }

    void setGlobal(Function global) {
        this.global = global;
    }

    void setProto(ESId proto) {
        this.proto = proto;
    }

    void addFunction(Function function) {
        this.setFunction(function);
    }

    void writeCode(WriteStream os) throws IOException {
        this.os = os;
        this.println("/**");
        this.println(" * Generated by " + Version.FULL_VERSION);
        this.println(" */");
        this.println();
        this.println("package " + this.pkg + ";");
        this.println("import java.io.*;");
        this.println("import com.caucho.es.*;");
        this.println("import com.caucho.util.*;");
        for (int i = 0; i < this.javaImports.size(); ++i) {
            this.println("import " + this.javaImports.get(i) + ";");
        }
        this.println("public class " + this.name + " extends com.caucho.es.Script {");
        this.pushDepth();
        this.writeExecute();
        this.writeClassContents();
        this.writeLastModified();
        this.printLineMap();
        this.popDepth();
        this.println("}");
    }

    void writeClassContents() throws IOException {
        int i;
        if (this.os == null) {
            this.os = this.root.os;
        }
        String name = this == this.root ? "js_global" : this.name;
        this.println();
        this.println("public static class " + name + " {");
        this.pushDepth();
        this.println(name + "_es _js;");
        Iterator iter = this.variables.values().iterator();
        while (iter.hasNext()) {
            Variable var = (Variable)iter.next();
            this.writeVarDecl(var, true);
        }
        for (i = 0; i < this.functions.size(); ++i) {
            Function fun = (Function)this.functions.get(i);
            this.println();
            fun.writeCode(this);
        }
        this.popDepth();
        this.println("}");
        this.println();
        if (name.equals("js_global")) {
            this.println("public static class js_global_es extends ESGlobal {");
        } else {
            this.println("public static class " + name + "_es extends ESClass {");
        }
        this.pushDepth();
        this.println(name + " _js_object;");
        this.println();
        this.println();
        if (name.equals("js_global")) {
            this.println("js_global_es(Global resin)");
            this.println("{");
            this.println("  super(resin);");
            this.println("  resin.setGlobal(this);");
        } else {
            this.println(name + "_es()");
            this.println("{");
        }
        this.println("  _js_object = new " + name + "();");
        this.println("  _js_object._js = this;");
        this.println("}");
        this.writeMap();
        this.printGetProperty();
        this.printPropNames();
        this.writeInit();
        this.writeWrapperInit(name);
        this.writeStaticInit();
        this.writeExport();
        this.popDepth();
        this.println("}");
        for (i = 0; i < this.classes.size(); ++i) {
            ParseClass subClass = (ParseClass)this.classes.get(i);
            subClass.setWriteStream(this.os);
            subClass.writeClassContents();
        }
    }

    void writeExport() throws IOException {
        int i;
        this.println();
        this.println("public void export(ESObject dst) throws Throwable");
        this.println("{");
        this.println("  ESBase tmp;");
        for (i = 0; this.global.functions != null && i < this.global.functions.size(); ++i) {
            Function fun = (Function)this.global.functions.get(i);
            this.println("  tmp = getProperty(\"" + fun.id + "\");");
            this.println("  dst.put(\"" + fun.id + "\", tmp, ESBase.DONT_ENUM);");
        }
        for (i = 0; i < this.classes.size(); ++i) {
            ParseClass cl = (ParseClass)this.classes.get(i);
            Function fun = cl.getFunction(ESId.intern(cl.name));
            this.println("  tmp = getProperty(\"" + cl.name + "\");");
            this.println("  dst.put(\"" + cl.name + "\", tmp, ESBase.DONT_ENUM);");
        }
        this.println("}");
    }

    void writeExecute() throws IOException {
        this.println("public ESGlobal initClass(Global resin) throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("resin.addScript(\"" + this.className + "\", this);");
        this.println("js_global_es test = new js_global_es(resin);");
        this.println("test._init(resin, test);");
        this.println("return test;");
        this.popDepth();
        this.println("}");
    }

    void writeWrapperInit(String name) throws IOException {
    }

    void writeVarDecl(Variable var, boolean init) throws IOException {
        if (var.getType() == 5) {
            this.print("boolean " + var.getId());
            if (init) {
                this.println(" = false;");
            } else {
                this.println(";");
            }
        } else if (var.getType() == 4) {
            this.print("int " + var.getId());
            if (init) {
                this.println(" = 0;");
            } else {
                this.println(";");
            }
        } else if (var.getType() == 3) {
            this.print("double " + var.getId());
            if (init) {
                this.println(" = Double.NaN;");
            } else {
                this.println(";");
            }
        } else if (var.getType() == 2) {
            this.print("ESString " + var.getId());
            if (init) {
                this.println(" = ESString.create(\"\");");
            } else {
                this.println(";");
            }
        } else if (var.getType() == 6 && var.getTypeExpr() != null) {
            TypeExpr type = (TypeExpr)var.getTypeExpr();
            this.println(type.getTypeName() + " " + var.getId() + ";");
        } else if (init) {
            this.println("ESBase " + var.getId() + " = ESBase.esUndefined;");
        } else {
            this.println("ESBase " + var.getId() + ";");
        }
    }

    void printId(ESId id) throws IOException {
        this.print("js_global_es.");
        this.print(this.getMangledLiteral(id));
    }

    String getMangledLiteral(ESBase value) {
        String literal = (String)this.literals.get(value);
        if (literal == null) {
            literal = this.mangleLiteral(value);
            this.literals.put(value, literal);
        }
        return literal;
    }

    void pushCall() {
        ++this.callDepth;
    }

    void popCall(int n) {
        this.callDepth -= n;
    }

    int getCallDepth() {
        return this.callDepth;
    }

    void printLiteral(ESBase obj) throws IOException {
        if (obj == null) {
            this.print("ESBase.esNull");
        } else if (obj instanceof ESNull) {
            this.print("ESBase.esNull");
        } else if (obj instanceof ESUndefined) {
            this.print("ESBase.esUndefined");
        } else if (obj == ESBoolean.TRUE) {
            this.print("ESBoolean.TRUE");
        } else if (obj == ESBoolean.FALSE) {
            this.print("ESBoolean.FALSE");
        } else {
            String literal = (String)this.literals.get(obj);
            if (literal == null) {
                try {
                    if (obj instanceof ESNumber && Double.isNaN(obj.toNum())) {
                        this.print("ESNumber.NaN");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                literal = this.mangleLiteral(obj);
                this.literals.put(obj, literal);
            }
            this.print("js_global_es.");
            this.print(literal);
        }
    }

    private String mangleLiteral(Object obj) {
        String s = obj.toString();
        CharBuffer cb = new CharBuffer("_l_");
        for (int i = 0; i < s.length() && i < 32; ++i) {
            char ch = s.charAt(i);
            if (Character.isJavaIdentifierPart(ch) && ch >= ' ' && ch < '\u007f') {
                cb.append(ch);
                continue;
            }
            if (cb.getLastChar() == '_') continue;
            cb.append("_");
        }
        if (this.mangledSet.get(cb) != null) {
            cb.append("_" + this.unique++);
        }
        this.mangledSet.put(cb, cb);
        return cb.toString();
    }

    void writeMap() throws IOException {
        this.println("public ESBase call(int n, Call call, int length)");
        this.println("  throws Throwable");
        this.println("{");
        this.println("  switch(n) {");
        for (int i = 0; i < this.functions.size(); ++i) {
            Function fun = (Function)this.functions.get(i);
            this.println("  case " + i + ":");
            this.print("    return ");
            Expr expr = fun.getReturnType();
            boolean hasCoerce = false;
            if (expr != null) {
                if (expr.getType() == 4 || expr.getType() == 3) {
                    hasCoerce = true;
                    this.print("ESNumber.create(");
                } else if (expr instanceof JavaTypeExpr) {
                    this.print("call.global.wrap(");
                }
            }
            this.print("_js_object.");
            this.print(fun.name + "(call, length");
            for (int j = 0; j < fun.getFormalSize(); ++j) {
                Variable formal = fun.getFormal(j);
                if (formal.getTypeExpr() instanceof JavaTypeExpr) {
                    TypeExpr type = (TypeExpr)formal.getTypeExpr();
                    this.print(", (" + type.getTypeName() + ") call.getArgObject(" + j + ", length)");
                    continue;
                }
                if (formal.getType() != 4) continue;
                this.print(", call.getArgInt32(" + j + ", length)");
            }
            this.print(")");
            if (hasCoerce) {
                this.print(")");
            }
            this.println(";");
        }
        this.println("  default:");
        this.println("    throw new RuntimeException();");
        this.println("  }");
        this.println("}");
    }

    void printGetProperty() throws IOException {
        if (this.variables.size() == 0) {
            return;
        }
        this.println();
        this.println("public ESBase getProperty(ESString key) throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("switch (propNames.get(key)) {");
        Iterator iter = this.variables.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Variable var = (Variable)iter.next();
            this.println("case " + i + ":");
            Class javaClass = var.getTypeExpr().getJavaClass();
            if (ClassLiteral.getClass((String)"com/caucho/es/ESBase").isAssignableFrom(javaClass)) {
                this.println("  return _js_object." + var.getId() + ";");
            } else {
                this.println("  return wrap(_js_object." + var.getId() + ");");
            }
            ++i;
        }
        this.println("default:");
        this.println("  return super.getProperty(key);");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    void printSetProperty() throws IOException {
        if (this.variables.size() == 0) {
            return;
        }
        this.println();
        this.println("public void setProperty(ESString key, ESBase value) throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("switch (propNames.get(key)) {");
        Iterator iter = this.variables.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Variable var = (Variable)iter.next();
            this.println("case " + i + ":");
            Class javaClass = var.getTypeExpr().getJavaClass();
            if (ClassLiteral.getClass((String)"com/caucho/es/ESBase").isAssignableFrom(javaClass)) {
                this.println("  _js_object." + var.getId() + " = (" + javaClass.getName() + ") value.toJavaObject();");
            } else {
                this.println("  _js_object." + var.getId() + " = value;");
            }
            this.println("  break;");
            ++i;
        }
        this.println("default:");
        this.println("  return super.setProperty(key, value);");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    void printPropNames() throws IOException {
        if (this.variables.size() == 0) {
            return;
        }
        this.println();
        this.println("private static com.caucho.util.IntMap propNames;");
        this.println();
        this.println("static {");
        this.pushDepth();
        this.println("propNames = new com.caucho.util.IntMap();");
        Iterator iter = this.variables.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Variable var = (Variable)iter.next();
            this.println("propNames.put(ESId.intern(\"" + var.getId() + "\"), " + i + ");");
            ++i;
        }
        this.popDepth();
        this.println("}");
    }

    void writeInit() throws IOException {
        int i;
        this.println();
        this.println("public void _init(Global resin, ESObject global) throws Throwable");
        this.println("{");
        this.pushDepth();
        for (i = 0; i < this.imports.size(); ++i) {
            String importName = (String)this.imports.get(i);
            this.print("resin.importScript(this, \"");
            this.printString(importName);
            this.println("\");");
        }
        this.println("ESClosure fun;");
        for (i = 0; this.global.functions != null && i < this.global.functions.size(); ++i) {
            Function fun = (Function)this.global.functions.get(i);
            this.print("fun = new ESClosure(");
            this.print(this.getMangledLiteral(fun.id));
            this.print(", this, null, " + fun.num + ", ");
            if (fun.getFormalSize() == 0) {
                this.print("_a_null");
            } else {
                this.print("_a_" + fun.num);
            }
            this.println(", global);");
            this.println("global.put(\"" + fun.id + "\", fun, ESBase.DONT_ENUM);");
        }
        this.println("ESObject protoProto;");
        this.println("ESObject proto;");
        for (i = 0; i < this.classes.size(); ++i) {
            ParseClass cl = (ParseClass)this.classes.get(i);
            Function fun = cl.getFunction(ESId.intern(cl.name));
            this.println("{");
            this.pushDepth();
            this.println(cl.name + "_es jsClass;");
            this.println("jsClass = new " + cl.name + "_es();");
            if (cl.proto != null) {
                this.print("proto = new ESObject(\"Object\", getProperty(");
                this.print(this.getMangledLiteral(cl.proto));
                this.println(").getProperty(");
                this.printLiteral(ESId.intern("prototype"));
                this.println("));");
            } else {
                this.println("proto = resin.createObject();");
            }
            this.println("jsClass._init(resin, proto);");
            this.print("fun = new ESClosure(");
            this.print(this.getMangledLiteral(ESId.intern(cl.name)));
            this.print(", jsClass, proto, " + fun.num + ", ");
            if (fun.getFormalSize() == 0) {
                this.print("_a_null");
            } else {
                this.print("_a_" + (i + this.functions.size()));
            }
            this.println(", null);");
            this.println("setProperty(\"" + cl.name + "\", fun);");
            this.popDepth();
            this.println("}");
        }
        this.popDepth();
        this.println("}");
    }

    void writeLastModified() throws IOException {
        this.println();
        this.println("public boolean isModified()");
        this.println("{");
        if (this.sourcePath == null || this.sourcePath.getLastModified() <= 0L) {
            this.println("  return false;");
        } else if (this.getScriptPath().lookup(this.sourcePath.getUserPath()).exists()) {
            this.print("  return scriptPath.lookup(\"");
            this.printString(this.sourcePath.getUserPath());
            this.println("\").getLastModified() != " + this.sourcePath.getLastModified() + "L;");
        } else {
            this.print("  return com.caucho.vfs.Vfs.lookup(\"");
            this.printString(this.sourcePath.getFullPath());
            this.println("\").getLastModified() != " + this.sourcePath.getLastModified() + "L;");
        }
        this.println("}");
    }

    Function getFunction(ESId name) {
        for (int i = 0; i < this.functions.size(); ++i) {
            Function fun = (Function)this.functions.get(i);
            if (fun.id != name) continue;
            return fun;
        }
        return null;
    }

    boolean hasFunction(ArrayList functions, ESId var) {
        for (int i = 2; i < functions.size(); ++i) {
            Function fun = (Function)functions.get(i);
            if (fun.id != var) continue;
            return true;
        }
        return false;
    }

    void writeStaticInit() throws IOException {
        int i;
        Iterator iter = this.literals.keySet().iterator();
        if (iter.hasNext()) {
            this.println();
        }
        while (iter.hasNext()) {
            Object o = iter.next();
            String name = (String)this.literals.get(o);
            if (o instanceof ESId) {
                this.print("static ESId " + name);
                this.print(" = ESId.intern(\"");
                this.printString(String.valueOf(o));
                this.println("\");");
                continue;
            }
            if (o instanceof ESString) {
                this.print("static ESString " + name);
                this.print(" = ESString.create(\"");
                this.printString(String.valueOf(o));
                this.println("\");");
                continue;
            }
            if (o instanceof ESNumber) {
                this.print("static ESNumber " + name);
                double v = ((ESNumber)o).toNum();
                if (Double.isInfinite(v)) {
                    this.println(" = ESNumber.create(Double.POSITIVE_INFINITY);");
                    continue;
                }
                if (Double.isInfinite(-v)) {
                    this.println(" = ESNumber.create(Double.NEGATIVE_INFINITY);");
                    continue;
                }
                if (Double.isNaN(v)) {
                    throw new RuntimeException();
                }
                this.println(" = ESNumber.create(" + o + "D);");
                continue;
            }
            throw new RuntimeException();
        }
        this.println("static ESId[] _a_null = new ESId[0];");
        for (i = 0; i < this.functions.size(); ++i) {
            Function fun = (Function)this.functions.get(i);
            this.printFormals(fun, i);
        }
        for (i = 0; i < this.classes.size(); ++i) {
            ParseClass cl = (ParseClass)this.classes.get(i);
            Function fun = cl.getFunction(ESId.intern(cl.name));
            this.printFormals(fun, i + this.functions.size());
        }
    }

    void setLine(String filename, int line) {
        this.lineMap.add(filename, line, this.destLine);
    }

    void printLineMap() throws IOException {
        String dst = this.name + ".java";
        String src = this.srcFilename;
        String srcTail = this.srcFilename;
        int p = srcTail.lastIndexOf(47);
        if (p >= 0) {
            srcTail = srcTail.substring(p + 1);
        }
        if ((p = srcTail.lastIndexOf(92)) >= 0) {
            srcTail = srcTail.substring(p + 1);
        }
        this.println();
        this.println("public com.caucho.java.LineMap getLineMap()");
        this.println("{");
        this.pushDepth();
        this.print("com.caucho.java.LineMap lineMap = new com.caucho.java.LineMap(\"");
        this.printString(dst);
        this.print("\", \"");
        this.printString(srcTail);
        this.println("\");");
        this.println("lineMap.add(1, 1);");
        Iterator<LineMap.Line> iter = this.lineMap.iterator();
        while (iter.hasNext()) {
            LineMap.Line line = iter.next();
            if (line.getSourceFilename() == src) {
                this.println("lineMap.add(" + line.getSourceLine() + ", " + line.getDestLine() + ");");
                continue;
            }
            src = line.getSourceFilename();
            srcTail = src;
            p = srcTail.lastIndexOf(47);
            if (p >= 0) {
                srcTail = srcTail.substring(p + 1);
            }
            if ((p = srcTail.lastIndexOf(92)) >= 0) {
                srcTail = srcTail.substring(p + 1);
            }
            this.print("lineMap.add(\"");
            this.printString(srcTail);
            this.println("\", " + line.getSourceLine() + ", " + line.getDestLine() + ");");
        }
        this.println("return lineMap;");
        this.popDepth();
        this.println("}");
    }

    private void printFormals(Function fun, int i) throws IOException {
        if (fun.getFormalSize() > 0) {
            this.print("  private static ESId[] _a_" + i + " = new ESId[] {");
            for (int j = 0; fun.formals != null && j < fun.formals.size(); ++j) {
                if (j != 0) {
                    this.print(",");
                }
                Variable var = (Variable)fun.formals.get(j);
                this.print(" ESId.intern(\"" + var.getId() + "\")");
            }
            this.println("};");
        }
    }

    void printString(String s) throws IOException {
        block7: for (int i = 0; i < s.length(); ++i) {
            if (i > 0 && i % 16384 == 0) {
                this.os.print("\" + \"");
            }
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    this.os.print("\\\\");
                    continue block7;
                }
                case '\n': {
                    this.os.print("\\n");
                    continue block7;
                }
                case '\r': {
                    this.os.print("\\r");
                    continue block7;
                }
                case '\t': {
                    this.os.print("\\t");
                    continue block7;
                }
                case '\"': {
                    this.os.print("\\\"");
                    continue block7;
                }
                default: {
                    if (ch >= ' ' && ch < '\u007f') {
                        this.os.print(ch);
                        continue block7;
                    }
                    this.os.print("\\u");
                    this.printHex(ch >> 12);
                    this.printHex(ch >> 8);
                    this.printHex(ch >> 4);
                    this.printHex(ch >> 0);
                }
            }
        }
    }

    void printHex(int i) throws IOException {
        if ((i &= 0xF) < 10) {
            this.os.print(i);
        } else {
            this.os.print((char)(97 + i - 10));
        }
    }

    void pushDepth() {
        this.printDepth += 2;
    }

    void popDepth() {
        this.printDepth -= 2;
    }

    void print(boolean b) throws IOException {
        if (this.isFirst) {
            this.printSpaces();
        }
        this.root.os.print(b);
    }

    void print(int i) throws IOException {
        if (this.isFirst) {
            this.printSpaces();
        }
        this.root.os.print(i);
    }

    void print(char c) throws IOException {
        if (this.isFirst) {
            this.printSpaces();
        }
        this.root.os.print(c);
        if (c == '\n') {
            ++this.destLine;
        }
    }

    void print(String s) throws IOException {
        if (this.isFirst) {
            this.printSpaces();
        }
        if (s == null) {
            s = "null";
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                this.isFirst = true;
                ++this.destLine;
                continue;
            }
            this.isFirst = false;
        }
        this.root.os.print(s);
    }

    void print(Object o) throws IOException {
        if (this.isFirst) {
            this.printSpaces();
        }
        this.print(String.valueOf(o));
    }

    void println() throws IOException {
        if (this.isFirst) {
            this.printSpaces();
        }
        this.root.os.println();
        ++this.destLine;
        this.isFirst = true;
    }

    void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    void println(Object o) throws IOException {
        this.print(String.valueOf(o));
        this.println();
    }

    void printSpaces() throws IOException {
        for (int i = 0; i < this.printDepth; ++i) {
            this.root.os.print(' ');
        }
        this.isFirst = false;
    }

    static class Location {
        String filename;
        int line;

        Location(String filename, int line) {
            this.filename = filename;
            this.line = line;
        }
    }
}

