/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.filters.CauchoResponseWrapper;
import com.caucho.util.FreeList;
import com.caucho.util.RuntimeExceptionWrapper;
import com.caucho.vfs.GzipStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GzipFilter
implements Filter {
    private static final FreeList<GzipResponse> _freeList = new FreeList(16);
    private ServletContext _app;
    private boolean _embedError;
    private boolean _useVary = true;
    private boolean _noCache = false;

    public void setUseVary(boolean useVary) {
        this._useVary = useVary;
    }

    public void setNoCache(boolean noCache) {
        this._noCache = noCache;
    }

    public void setEmbedErrorInOutput(boolean embedError) {
        this._embedError = embedError;
    }

    public void init(FilterConfig config) throws ServletException {
        this._app = config.getServletContext();
        this._embedError = "true".equals(config.getInitParameter("embed-error-in-output"));
        String value = config.getInitParameter("use-vary");
        if (value != null) {
            if ("false".equals(value)) {
                this._useVary = false;
            } else if ("false".equals(value)) {
                this._useVary = true;
            }
        }
        if ((value = config.getInitParameter("no-cache")) != null) {
            if ("true".equals(value)) {
                this._noCache = true;
            } else if ("false".equals(value)) {
                this._noCache = true;
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this._noCache) {
            res.setHeader("Cache-Control", "no-cache");
        } else if (this._useVary) {
            res.addHeader("Vary", "Accept-Encoding");
        } else {
            res.setHeader("Cache-Control", "private");
        }
        if (this.allowGzip(req, res)) {
            GzipResponse gzipResponse = _freeList.allocate();
            if (gzipResponse == null) {
                gzipResponse = new GzipResponse();
            }
            gzipResponse.init(res);
            try {
                nextFilter.doFilter((ServletRequest)req, (ServletResponse)gzipResponse);
            }
            catch (Exception e) {
                this.handleError(e, gzipResponse);
            }
            gzipResponse.close();
            _freeList.free(gzipResponse);
        } else {
            nextFilter.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    protected boolean allowGzip(HttpServletRequest req, HttpServletResponse res) {
        String acceptEncoding = req.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.indexOf("gzip") >= 0;
    }

    public void destroy() {
    }

    private void handleError(Exception e, CauchoResponseWrapper res) throws ServletException, IOException {
        if (!this._embedError || !res.isCommitted()) {
            if (e instanceof ServletException) {
                throw (ServletException)((Object)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RuntimeExceptionWrapper.create(e);
        }
        this._app.log(e.getMessage(), (Throwable)e);
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.flush();
        res.getWriter().print(writer.toCharArray());
    }

    static class GzipResponse
    extends CauchoResponseWrapper {
        private boolean _allowGzip = true;
        private GzipStream _savedGzipStream = new GzipStream();
        private GzipStream _gzipStream;

        GzipResponse() {
        }

        public void setContentLength(int length) {
        }

        public void setStatus(int status, String message) {
            super.setStatus(status, message);
            if (this._gzipStream != null) {
                this._gzipStream.setEnable(false);
                this._response.setHeader("Content-Encoding", "plain");
            }
            this._allowGzip = false;
        }

        public void setStatus(int status) {
            super.setStatus(status);
            if (status == 206) {
                return;
            }
            if (this._gzipStream != null) {
                this._gzipStream.setEnable(false);
                this._response.setHeader("Content-Encoding", "plain");
            }
            this._allowGzip = false;
        }

        public OutputStream getStream() throws IOException {
            if (!this._allowGzip) {
                return this._response.getOutputStream();
            }
            ServletOutputStream os = this._response.getOutputStream();
            this._response.setHeader("Content-Encoding", "gzip");
            this._gzipStream = this._savedGzipStream;
            this._gzipStream.init((OutputStream)os);
            return this._gzipStream;
        }

        public void close() throws IOException {
            super.close();
            this._allowGzip = true;
            GzipStream gzipStream = this._gzipStream;
            this._gzipStream = null;
            if (gzipStream != null) {
                gzipStream.close();
            }
        }
    }
}

