/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.CosServer;
import com.caucho.iiop.IiopContext;
import com.caucho.iiop.IiopRemoteService;
import com.caucho.iiop.IiopRequest;
import com.caucho.iiop.IiopSkeleton;
import com.caucho.log.Log;
import com.caucho.server.connection.Connection;
import com.caucho.server.port.Protocol;
import com.caucho.server.port.ServerRequest;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;

public class IiopProtocol
extends Protocol {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/iiop/IiopProtocol"));
    static final String COPYRIGHT = "Copyright (c) 1998-2004 Caucho Technology.  All rights reserved.";
    private String _protocolName = "iiop";
    private CosServer _cos;
    private IiopContext _iiopContext = new IiopContext();

    public IiopProtocol() {
        this._cos = new CosServer(this);
        IiopContext.setLocalContext(this._iiopContext);
    }

    public String getProtocolName() {
        return this._protocolName;
    }

    public void setProtocolName(String name) {
        this._protocolName = name;
    }

    public CosServer getCos() {
        return this._cos;
    }

    public IiopSkeleton getService(String host, int port, String oid) {
        return this.lookupService(host, port, oid);
    }

    private IiopSkeleton lookupService(String host, int port, String oid) {
        String local;
        String url;
        int p = oid.indexOf(63);
        if (p < 0) {
            url = oid;
            local = null;
        } else {
            url = oid.substring(0, p);
            local = oid.substring(p + 1);
        }
        IiopRemoteService service = this._iiopContext.getService(url);
        if (service == null) {
            return null;
        }
        if (local == null) {
            return new IiopSkeleton(service.getHome(), service.getHomeAPI(), service.getClassLoader(), host, port, url);
        }
        Object obj = service.getObject(local);
        if (obj == null) {
            return null;
        }
        return new IiopSkeleton(obj, service.getObjectAPI(), service.getClassLoader(), host, port, url + '?' + local);
    }

    public ServerRequest createRequest(Connection conn) {
        return new IiopRequest(this, conn);
    }
}

