/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.deployclient;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.j2ee.deployclient.DeploymentManagerAPI;
import com.caucho.j2ee.deployclient.ProgressObjectImpl;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class DeploymentManagerImpl
implements DeploymentManager {
    private String _uri;
    private DeploymentManagerAPI _proxy;

    DeploymentManagerImpl(String uri) {
        int p = uri.indexOf("http");
        if (p < 0) {
            throw new IllegalArgumentException(uri);
        }
        this._uri = uri.substring(p);
    }

    void connect(String user, String password) throws DeploymentManagerCreationException {
        try {
            HessianProxyFactory factory = new HessianProxyFactory();
            factory.setUser(user);
            factory.setPassword(password);
            this._proxy = (DeploymentManagerAPI)factory.create(ClassLiteral.getClass((String)"com/caucho/j2ee/deployclient/DeploymentManagerAPI"), this._uri);
        }
        catch (Exception e) {
            DeploymentManagerCreationException exn = new DeploymentManagerCreationException(e.getMessage());
            exn.initCause((Throwable)e);
            throw exn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target[] getTargets() throws IllegalStateException {
        if (this._proxy == null) {
            throw new IllegalStateException("DeploymentManager is disconnected");
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            Target[] targetArray = this._proxy.getTargets();
            return targetArray;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        System.out.println("GET-RUN-MODULES");
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        System.out.println("GET-NON-RUN-MODULES");
        return new TargetModuleID[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        System.out.println("GET-MODULES:");
        if (this._proxy == null) {
            throw new IllegalStateException("DeploymentManager is disconnected");
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            TargetModuleID[] targetModuleIDArray = this._proxy.getAvailableModules(moduleType.toString());
            return targetModuleIDArray;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        System.out.println("CREATE-CONF");
        throw new UnsupportedOperationException();
    }

    public ProgressObject distribute(Target[] targetList, File archive, File deploymentPlan) throws IllegalStateException {
        FileInputStream archiveIn = null;
        InputStream ddIn = null;
        try {
            archiveIn = new FileInputStream(archive);
            ddIn = new FileInputStream(deploymentPlan);
            ProgressObject progressObject = this.distribute(targetList, archiveIn, ddIn);
            return progressObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ((InputStream)archiveIn).close();
            }
            catch (Throwable e) {}
            try {
                ddIn.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetList, InputStream archive, InputStream deploymentPlan) throws IllegalStateException {
        if (this._proxy == null) {
            throw new IllegalStateException("DeploymentManager is disconnected");
        }
        if (deploymentPlan == null) {
            return null;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            ProgressObject progressObject = this._proxy.distribute(targetList, deploymentPlan, archive);
            return progressObject;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public ProgressObject start(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return new ProgressObjectImpl(moduleIDList);
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList) throws IllegalStateException {
        return new ProgressObjectImpl(moduleIDList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject undeploy(TargetModuleID[] moduleIDList) throws IllegalStateException {
        if (this._proxy == null) {
            throw new IllegalStateException("DeploymentManager is disconnected");
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            ProgressObject progressObject = this._proxy.undeploy(moduleIDList);
            return progressObject;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetList, File archive, File deploymentPlan) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public ProgressObject redeploy(TargetModuleID[] targetList, InputStream archive, InputStream deploymentPlan) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void release() {
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException();
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException();
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException();
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException();
    }

    public boolean isLocaleSupported(Locale locale) {
        return false;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V1_4;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return true;
    }

    public void setDConfigBeanVersionSupported(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
    }

    public String toString() {
        return "DeploymentManagerImpl[" + this._uri + "]";
    }
}

