/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.deployserver;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentPlan {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/j2ee/deployserver/DeploymentPlan"));
    private String _archiveType;
    private String _name;
    private ArrayList<ExtFile> _extFileList = new ArrayList();

    public void setArchiveType(String type) throws ConfigException {
        if (!(type.equals("war") || type.equals("ear") || type.equals("rar"))) {
            throw new ConfigException(L.l("'{0}' is an unknown archive type.", type));
        }
        this._archiveType = type;
    }

    public String getArchiveType() {
        return this._archiveType;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getArchiveName() {
        return new StringBuffer().append(this.getName()).append(".").append(this.getArchiveType()).toString();
    }

    public String getExpandName() {
        if (this._archiveType.equals("war")) {
            return this.getName();
        }
        return new StringBuffer().append("_").append(this._archiveType).append("_").append(this.getName()).toString();
    }

    public String getMetaPathName() {
        if (this._archiveType.equals("war")) {
            return new StringBuffer().append(this.getExpandName()).append("/WEB-INF").toString();
        }
        return new StringBuffer().append(this.getExpandName()).append("/META-INF").toString();
    }

    public void addExtFile(ExtFile file) {
        this._extFileList.add(file);
    }

    public ArrayList<ExtFile> getExtFileList() {
        return this._extFileList;
    }

    public static class ExtFile {
        private String _name;
        private Node _data;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setData(Node data) {
            this._data = data;
        }

        public Node getData() {
            return this._data;
        }
    }
}

