/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.config.ConfigException;
import com.caucho.jca.ConnectionPool;
import com.caucho.jca.UserTransactionProxy;
import com.caucho.jca.WorkManagerImpl;
import com.caucho.loader.CloseListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;

public class ResourceManagerImpl
implements BootstrapContext {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jca/ResourceManagerImpl"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jca/ResourceManagerImpl"));
    private static EnvironmentLocal<ResourceManagerImpl> _localManager = new EnvironmentLocal();
    private UserTransactionProxy _tm;
    private ArrayList<ResourceAdapter> _resources = new ArrayList();
    private ArrayList<ConnectionPool> _connectionManagers = new ArrayList();
    private ArrayList<SoftReference<Timer>> _timers = new ArrayList();
    private WorkManagerImpl _workManager;
    private boolean _isInit;
    private boolean _isClosed;

    private ResourceManagerImpl() {
        Environment.addClassLoaderListener(new CloseListener(this));
        try {
            InitialContext ic = new InitialContext();
            this._tm = (UserTransactionProxy)ic.lookup("java:comp/UserTransaction");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceManagerImpl createLocalManager() {
        ResourceManagerImpl rm;
        EnvironmentLocal<ResourceManagerImpl> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            rm = _localManager.getLevel();
            if (rm == null) {
                rm = new ResourceManagerImpl();
                _localManager.set(rm);
            }
        }
        return rm;
    }

    public static ResourceManagerImpl getLocalManager() {
        return _localManager.getLevel();
    }

    public static void addResource(ResourceAdapter resource) throws ConfigException {
        ResourceManagerImpl rm = ResourceManagerImpl.createLocalManager();
        rm.addResourceImpl(resource);
    }

    private void addResourceImpl(ResourceAdapter resource) {
        try {
            resource.start((BootstrapContext)this);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        this._resources.add(resource);
    }

    public ConnectionPool createConnectionPool() {
        ConnectionPool cm = new ConnectionPool();
        cm.setTransactionManager(this._tm);
        this._connectionManagers.add(cm);
        return cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkManager getWorkManager() {
        ResourceManagerImpl resourceManagerImpl = this;
        synchronized (resourceManagerImpl) {
            if (this._workManager == null) {
                this._workManager = new WorkManagerImpl();
            }
        }
        return this._workManager;
    }

    public XATerminator getXATerminator() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer createTimer() {
        TimerImpl timer = new TimerImpl(this);
        ArrayList<SoftReference<Timer>> arrayList = this._timers;
        synchronized (arrayList) {
            SoftReference<TimerImpl> timerRef = new SoftReference<TimerImpl>(timer);
            this._timers.add(timerRef);
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimer(Timer timer) {
        if (this._timers == null) {
            return;
        }
        ArrayList<SoftReference<Timer>> arrayList = this._timers;
        synchronized (arrayList) {
            for (int i = this._timers.size(); i >= 0; --i) {
                SoftReference<Timer> timerRef = this._timers.get(i);
                Timer oldTimer = timerRef.get();
                if (oldTimer == null) {
                    this._timers.remove(i);
                    continue;
                }
                if (oldTimer != timer) continue;
                this._timers.remove(i);
            }
        }
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        int i;
        ArrayList<SoftReference<Timer>> timers;
        ArrayList<ResourceAdapter> resources;
        ArrayList<ConnectionPool> connectionManagers;
        ResourceManagerImpl resourceManagerImpl = this;
        synchronized (resourceManagerImpl) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            connectionManagers = this._connectionManagers;
            this._connectionManagers = null;
            resources = this._resources;
            this._resources = null;
            timers = this._timers;
            this._timers = null;
        }
        for (i = 0; i < timers.size(); ++i) {
            SoftReference<Timer> timerRef = timers.get(i);
            Timer timer = timerRef.get();
            try {
                if (timer == null) continue;
                timer.cancel();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (this._workManager != null) {
            this._workManager.destroy();
        }
        for (i = 0; i < connectionManagers.size(); ++i) {
            ConnectionPool connectionManager = connectionManagers.get(i);
            try {
                connectionManager.destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (i = 0; i < resources.size(); ++i) {
            ResourceAdapter resource = resources.get(i);
            try {
                resource.stop();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public class TimerImpl
    extends Timer {
        private ResourceManagerImpl _rm;

        TimerImpl(ResourceManagerImpl rm) {
            super(true);
            this._rm = rm;
        }

        public void cancel() {
            this._rm.removeTimer(this);
            super.cancel();
        }
    }
}

