/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.jca.ConnectionPool;
import com.caucho.jca.PoolItem;
import com.caucho.jca.UserTransactionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

class UserPoolItem {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jca/UserPoolItem"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jca/UserPoolItem"));
    private ConnectionPool _cm;
    private String _id;
    private PoolItem _poolItem;
    private ManagedConnectionFactory _mcf;
    private Subject _subject;
    private ConnectionRequestInfo _info;
    PoolItem _shareHead;
    private UserPoolItem _shareNext;
    private UserPoolItem _sharePrev;
    private Object _userConn;
    private boolean _hasConnectionError;
    private IllegalStateException _allocationStackTrace;

    public UserPoolItem(ConnectionPool cm) {
        this._cm = cm;
        this._id = this._cm.generateId();
    }

    public UserPoolItem(ConnectionPool cm, PoolItem poolItem) {
        this(cm);
        this._shareHead = this._poolItem = poolItem;
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory mcf) {
        this._mcf = mcf;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this._mcf;
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public void setInfo(ConnectionRequestInfo info) {
        this._info = info;
    }

    public ConnectionRequestInfo getInfo() {
        return this._info;
    }

    public boolean isActive() {
        return this._userConn != null;
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this._hasConnectionError = true;
    }

    public boolean isConnectionError() {
        return this._hasConnectionError;
    }

    public IllegalStateException getAllocationStackTrace() {
        return this._allocationStackTrace;
    }

    public void setSaveAllocationStackTrace(boolean enable) {
        this._cm.setSaveAllocationStackTrace(enable);
    }

    public PoolItem getPoolItem() {
        return this._poolItem;
    }

    public Object getUserConnection() {
        return this._userConn;
    }

    Object allocateUserConnection() throws ResourceException {
        if (this._userConn == null) {
            this._userConn = this._shareHead.allocateConnection();
        }
        return this._userConn;
    }

    public void setUserConnection(Object userConn) {
        this._userConn = userConn;
    }

    UserPoolItem getShareNext() {
        return this._shareNext;
    }

    void associatePoolItem(PoolItem poolItem) {
        this._poolItem = poolItem;
    }

    UserPoolItem associate(PoolItem poolItem, UserPoolItem shareNext, ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) {
        this._shareHead = poolItem;
        this._mcf = mcf;
        this._subject = subject;
        this._info = info;
        this._shareNext = shareNext;
        this._sharePrev = null;
        if (shareNext == this) {
            throw new IllegalStateException();
        }
        if (shareNext != null) {
            shareNext._sharePrev = this;
        }
        return this;
    }

    void reassociatePoolItem() throws ResourceException {
        if (this._poolItem == null) {
            UserPoolItem item = this._cm.allocatePool(this._mcf, this._subject, this._info, this);
            if (item != this) {
                throw new IllegalStateException();
            }
            this._poolItem = item.getPoolItem();
        }
        this._shareHead = this._poolItem;
        this._shareNext = null;
        this._sharePrev = null;
        this._poolItem._shareHead = this;
    }

    void abortConnection() throws ResourceException {
        PoolItem poolItem = this._poolItem;
        if (poolItem != null) {
            poolItem.abortConnection();
        }
    }

    void toClose() {
        UserTransactionImpl transaction;
        PoolItem poolItem = this._poolItem;
        PoolItem shareHead = this._shareHead;
        this._shareHead = null;
        this._userConn = null;
        if (shareHead != null) {
            UserPoolItem prev = this._sharePrev;
            UserPoolItem next = this._shareNext;
            this._sharePrev = null;
            this._shareNext = null;
            if (prev != null) {
                prev._shareNext = next;
            } else {
                shareHead._shareHead = next;
            }
            if (next != null) {
                next._sharePrev = prev;
            }
        }
        if ((transaction = this._cm.getTransaction()) != null) {
            transaction.delistResource(this);
        }
        if (poolItem == shareHead && poolItem != null) {
            poolItem.toIdle();
        }
    }

    public String toString() {
        return "UserPoolItem[" + this._cm.getName() + "," + this._id + "]";
    }
}

