/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.jms.AbstractDestination;
import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class JdbcDestination
extends AbstractDestination {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcDestination"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcDestination"));
    protected JdbcManager _jdbcManager = new JdbcManager();
    private DataSource _dataSource;
    private String _name;
    private long _lastPurgeTime;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public boolean isTopic() {
        return false;
    }

    public void setJdbcManager(JdbcManager jdbcManager) {
        this._jdbcManager = jdbcManager;
    }

    public JdbcManager getJdbcManager() {
        return this._jdbcManager;
    }

    public void setDataSource(DataSource dataSource) {
        this._jdbcManager.setDataSource(dataSource);
    }

    public void init() throws ConfigException, SQLException {
        this._jdbcManager.init();
        this._dataSource = this._jdbcManager.getDataSource();
    }

    protected int createDestination(String name, boolean isTopic) throws SQLException {
        Connection conn = this._jdbcManager.getDataSource().getConnection();
        String destinationTable = this._jdbcManager.getDestinationTable();
        try {
            String sql = "SELECT id FROM " + destinationTable + " WHERE name=? AND is_topic=?";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, name);
            pstmt.setInt(2, isTopic ? 1 : 0);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            rs.close();
            sql = "INSERT INTO " + destinationTable + " (name,is_topic) VALUES(?,?)";
            pstmt = conn.prepareStatement(sql, 1);
            pstmt.setString(1, name);
            pstmt.setInt(2, isTopic ? 1 : 0);
            pstmt.executeUpdate();
            rs = pstmt.getGeneratedKeys();
            if (rs.next()) {
                int id = rs.getInt(1);
                if (isTopic) {
                    log.fine("JMSTopic[" + name + "," + id + "] created");
                } else {
                    log.fine("JMSQueue[" + name + "," + id + "] created");
                }
                int n = id;
                return n;
            }
            throw new SQLException(L.l("can't generate destination for {0}", name));
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeExpiredMessages() {
        long purgeInterval = this._jdbcManager.getPurgeInterval();
        long now = Alarm.getCurrentTime();
        if (now < this._lastPurgeTime + purgeInterval) {
            return;
        }
        this._lastPurgeTime = now;
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            Connection conn = dataSource.getConnection();
            try {
                String sql = "DELETE FROM " + messageTable + " WHERE expire < ? AND consumer IS NULL";
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, Alarm.getCurrentTime());
                int count = pstmt.executeUpdate();
                if (count > 0) {
                    log.fine("JMSQueue[" + this.getName() + "] purged " + count + " expired mesages");
                }
                pstmt.close();
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }
}

