/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.jdbc.JdbcDestination;
import com.caucho.jms.jdbc.JdbcQueueBrowser;
import com.caucho.jms.jdbc.JdbcQueueConsumer;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.session.MessageConsumerImpl;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class JdbcQueue
extends JdbcDestination
implements Queue {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcQueue"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcQueue"));
    private int _id;

    public String getQueueName() {
        return this.getName();
    }

    public void setQueueName(String name) {
        this.setName(name);
    }

    public int getId() {
        return this._id;
    }

    public void init() throws ConfigException, SQLException {
        if (this._jdbcManager.getDataSource() == null) {
            throw new ConfigException(L.l("JdbcQueue requires a <data-source> element."));
        }
        if (this.getName() == null) {
            throw new ConfigException(L.l("JdbcQueue requires a <queue-name> element."));
        }
        this._jdbcManager.init();
        this._id = this.createDestination(this.getName(), false);
    }

    public MessageConsumerImpl createConsumer(SessionImpl session, String selector, boolean noWait) throws JMSException {
        return new JdbcQueueConsumer(session, selector, this._jdbcManager, this);
    }

    public QueueBrowser createBrowser(SessionImpl session, String selector) throws JMSException {
        return new JdbcQueueBrowser(session, selector, this);
    }

    public void send(Message message) throws JMSException {
        long expireTime = message.getJMSExpiration();
        if (expireTime <= 0L) {
            expireTime = 0x3FFFFFFFFFFFFFFFL;
        }
        this.purgeExpiredMessages();
        try {
            this._jdbcManager.getJdbcMessage().send(message, this._id, expireTime);
        }
        catch (Exception e) {
            throw new JMSExceptionWrapper(e);
        }
        this.messageAvailable();
    }

    public void commit(int session) throws JMSException {
    }

    public Enumeration getEnumeration(Selector selector) {
        return null;
    }

    public String toString() {
        return "JdbcQueue[" + this.getName() + "]";
    }
}

