/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.memory;

import com.caucho.jms.memory.MemoryQueue;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.session.MessageConsumerImpl;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;

public class MemoryQueueConsumer
extends MessageConsumerImpl
implements QueueReceiver {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/memory/MemoryQueueConsumer"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/memory/MemoryQueueConsumer"));
    private MemoryQueue _queue;
    private int _consumerId;
    private boolean _autoAck;

    public MemoryQueueConsumer(SessionImpl session, String messageSelector, MemoryQueue queue) throws JMSException {
        block5: {
            block4: {
                super(session, messageSelector, queue, false);
                if (queue == null) {
                    throw new NullPointerException();
                }
                this._queue = queue;
                this._consumerId = queue.generateConsumerId();
                if (session.getAcknowledgeMode() == 1) break block4;
                if (session.getAcknowledgeMode() != 3) break block5;
            }
            this._autoAck = true;
        }
    }

    public Queue getQueue() {
        return this._queue;
    }

    protected MessageImpl receiveImpl() throws JMSException {
        return this._queue.receive(this._selector, this._consumerId, this._autoAck);
    }

    public void acknowledge() throws JMSException {
        if (this._autoAck) {
            return;
        }
        this._queue.acknowledge(this._consumerId, Long.MAX_VALUE);
    }

    public void rollback() throws JMSException {
        if (this._autoAck) {
            return;
        }
        this._queue.rollback(this._consumerId);
    }

    public String toString() {
        return "MemoryQueueConsumer[" + this._queue + "," + this._consumerId + "]";
    }
}

