/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.memory;

import com.caucho.jms.AbstractDestination;
import com.caucho.jms.memory.MemoryQueue;
import com.caucho.jms.memory.MemoryTopicConsumer;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class MemoryTopic
extends AbstractDestination
implements Topic {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/memory/MemoryTopic"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/memory/MemoryTopic"));
    ArrayList<MemoryQueue> _subscribers = new ArrayList();
    private HashMap<String, MemoryQueue> _durableSubscribers = new HashMap();
    private String _topicName;

    public String getTopicName() {
        return this._topicName;
    }

    public void setTopicName(String name) {
        this._topicName = name;
    }

    public void send(Message message) throws JMSException {
        for (int i = 0; i < this._subscribers.size(); ++i) {
            MemoryQueue queue = this._subscribers.get(i);
            queue.send(message);
        }
    }

    public MessageConsumer createConsumer(SessionImpl session, String selector, boolean noLocal) throws JMSException {
        return new MemoryTopicConsumer(session, selector, this);
    }

    public TopicSubscriber createDurableSubscriber(SessionImpl session, String selector, boolean noLocal, String name) throws JMSException {
        return new MemoryTopicConsumer(session, selector, this, name);
    }

    public MemoryQueue createDurableSubscriber(String name) throws JMSException {
        MemoryQueue queue = this._durableSubscribers.get(name);
        if (queue == null) {
            queue = this.createSubscriberQueue();
            this._durableSubscribers.put(name, queue);
        }
        return queue;
    }

    MemoryQueue createSubscriberQueue() throws JMSException {
        MemoryQueue queue = new MemoryQueue();
        this._subscribers.add(queue);
        return queue;
    }

    public void removeSubscriber(MemoryQueue queue) {
        this._subscribers.remove(queue);
    }

    public String toString() {
        return "Topic[" + this._topicName + "]";
    }
}

