/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.Version;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MBeanServerDelegateImpl
extends MBeanServerDelegate {
    private static final ObjectName DELEGATE_NAME;
    private String _agentId;
    private long _seq;

    MBeanServerDelegateImpl(String agentId) {
        this._agentId = agentId;
    }

    public String getMBeanServerId() {
        return this._agentId;
    }

    public String getImplementationName() {
        return "Resin-JMX";
    }

    public String getImplementationVendor() {
        return "Caucho Technology";
    }

    public String getImplementationVersion() {
        return "Resin-" + Version.VERSION;
    }

    public void sendRegisterNotification(ObjectName name) {
        this.serverNotification(name, "JMX.mbean.registered");
    }

    public void sendUnregisterNotification(ObjectName name) {
        this.serverNotification(name, "JMX.mbean.unregistered");
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        super.addNotificationListener(listener, filter, handback);
    }

    private void serverNotification(ObjectName name, String type) {
        MBeanServerNotification notif = new MBeanServerNotification(type, (Object)DELEGATE_NAME, this._seq++, name);
        this.sendNotification(notif);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notifs = super.getNotificationInfo();
        return notifs;
    }

    static {
        ObjectName name = null;
        try {
            name = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        DELEGATE_NAME = name;
    }
}

