/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManager {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jsp/BundleManager"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jsp/BundleManager"));
    static LocalizationContext NULL_BUNDLE = new LocalizationContext();
    private static EnvironmentLocal<BundleManager> _envBundle = new EnvironmentLocal();
    private Hashtable<String, LocalizationContext> _bundleMap = new Hashtable();
    private long _lastUpdateTime;
    private long _updateInterval = Environment.getDependencyCheckInterval();

    private BundleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleManager create() {
        BundleManager manager;
        EnvironmentLocal<BundleManager> environmentLocal = _envBundle;
        synchronized (environmentLocal) {
            manager = _envBundle.get();
            if (manager == null) {
                manager = new BundleManager();
                _envBundle.set(manager);
            }
        }
        return manager;
    }

    public LocalizationContext getBundle(String name, String cacheKey, Enumeration<Locale> locales) {
        this.updateDependency();
        LocalizationContext cachedValue = this._bundleMap.get(cacheKey);
        if (cachedValue != null && cachedValue != NULL_BUNDLE) {
            return cachedValue;
        }
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            LocalizationContext bundle = this.getBundle(name, locale);
            if (bundle == null) continue;
            this._bundleMap.put(cacheKey, bundle);
            return bundle;
        }
        this._bundleMap.put(cacheKey, NULL_BUNDLE);
        return null;
    }

    public LocalizationContext getBundle(String name, Locale locale) {
        this.updateDependency();
        String cacheName = new StringBuffer().append(name).append('_').append(locale.getLanguage()).append('_').append(locale.getCountry()).append('_').append(locale.getVariant()).toString();
        LocalizationContext bundle = this._bundleMap.get(cacheName);
        if (bundle != null) {
            return bundle != NULL_BUNDLE ? bundle : null;
        }
        String fullName = cacheName;
        ResourceBundle resourceBundle = this.getBaseBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._bundleMap.put(cacheName, bundle);
            return bundle;
        }
        fullName = new StringBuffer().append(name).append('_').append(locale.getLanguage()).append('_').append(locale.getCountry()).toString();
        resourceBundle = this.getBaseBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._bundleMap.put(cacheName, bundle);
            return bundle;
        }
        fullName = new StringBuffer().append(name).append('_').append(locale.getLanguage()).toString();
        resourceBundle = this.getBaseBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._bundleMap.put(cacheName, bundle);
            return bundle;
        }
        this._bundleMap.put(cacheName, NULL_BUNDLE);
        return null;
    }

    public LocalizationContext getBundle(String name) {
        this.updateDependency();
        LocalizationContext bundle = this._bundleMap.get(name);
        if (bundle != null) {
            return bundle != NULL_BUNDLE ? bundle : null;
        }
        ResourceBundle resourceBundle = this.getBaseBundle(name);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle);
            this._bundleMap.put(name, bundle);
            return bundle;
        }
        this._bundleMap.put(name, NULL_BUNDLE);
        return null;
    }

    private ResourceBundle getBaseBundle(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            ResourceBundle rb;
            Class<?> cl = Class.forName(name, false, loader);
            if (cl != null && (rb = (ResourceBundle)cl.newInstance()) != null) {
                return rb;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            InputStream is = loader.getResourceAsStream(new StringBuffer().append(name.replace('.', '/')).append(".properties").toString());
            if (is instanceof ReadStream) {
                Path path = ((ReadStream)is).getPath();
                Environment.addDependency(new Depend(path));
            }
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            is.close();
            return bundle;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void updateDependency() {
        long now = Alarm.getCurrentTime();
        if (now < this._lastUpdateTime + this._updateInterval) {
            return;
        }
        this._lastUpdateTime = now;
        this._bundleMap.clear();
    }
}

