/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.NodeBuilder;
import com.caucho.java.JavaCompiler;
import com.caucho.java.LineMap;
import com.caucho.jsp.AppResourceManager;
import com.caucho.jsp.JspCompilerInstance;
import com.caucho.jsp.JspResourceManager;
import com.caucho.jsp.Page;
import com.caucho.jsp.SingleThreadWrapperPage;
import com.caucho.jsp.StaticPage;
import com.caucho.jsp.TagFileManager;
import com.caucho.jsp.TaglibManager;
import com.caucho.jsp.WrapperPage;
import com.caucho.jsp.cfg.JspConfig;
import com.caucho.loader.CompilingLoader;
import com.caucho.loader.DirectoryLoader;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.log.Log;
import com.caucho.server.webapp.Application;
import com.caucho.util.CauchoSystem;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.SingleThreadModel;
import javax.servlet.jsp.HttpJspPage;
import javax.servlet.jsp.JspPage;

public class JspCompiler {
    private static Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jsp/JspCompiler"));
    private Application _app;
    private Path _classDir;
    private Path _appDir;
    private JspResourceManager _resourceManager;
    private TaglibManager _taglibManager;
    private TagFileManager _tagFileManager;
    private JspConfig _jspConfig;
    private boolean _isXml;
    private ArrayList<String> _preludeList = new ArrayList();
    private ArrayList<String> _codaList = new ArrayList();
    private HashSet<String> _compilingTags = new HashSet();
    private boolean _hasRecursiveCompile;
    private ArrayList<JspCompilerInstance> _pending = new ArrayList();

    public void setClassDir(Path path) {
        this._classDir = path;
    }

    public void setClassDirectory(Path path) {
        this.setClassDir(path);
    }

    public Path getClassDir() {
        if (this._classDir != null) {
            return this._classDir;
        }
        return CauchoSystem.getWorkPath();
    }

    public void setAppDir(Path path) {
        this._appDir = path;
    }

    public Path getAppDir() {
        if (this._appDir != null) {
            return this._appDir;
        }
        if (this._app != null) {
            return this._app.getAppDir();
        }
        return null;
    }

    public void addPrelude(String prelude) {
        this._preludeList.add(prelude);
    }

    public void addCoda(String coda) {
        this._codaList.add(coda);
    }

    public void setXml(boolean isXml) {
        this._isXml = isXml;
    }

    public boolean isXml() {
        return this._isXml;
    }

    public JspConfig getJspConfig() {
        return this._jspConfig;
    }

    public void setResourceManager(JspResourceManager manager) {
        this._resourceManager = manager;
    }

    public JspResourceManager getResourceManager() {
        return this._resourceManager;
    }

    public void setTaglibManager(TaglibManager manager) {
        this._taglibManager = manager;
    }

    public TaglibManager getTaglibManager() {
        return this._taglibManager;
    }

    public void setTagFile(TagFileManager manager) {
        this._tagFileManager = manager;
    }

    public TagFileManager getTagFileManager() {
        return this._tagFileManager;
    }

    public Application createApplication() {
        if (this._app == null) {
            this._app = new Application();
            this._app.setDocumentDirectory(this.getAppDir());
        }
        return this._app;
    }

    public void setApplication(Application app) {
        this._app = app;
        if (this._resourceManager == null) {
            this._resourceManager = new AppResourceManager(this._app);
        }
    }

    public Application getApplication() {
        return this._app;
    }

    public boolean addTag(String className) {
        if (this._compilingTags.contains(className)) {
            this._hasRecursiveCompile = true;
            return true;
        }
        this._compilingTags.add(className);
        return false;
    }

    public boolean hasRecursiveCompile() {
        return this._hasRecursiveCompile;
    }

    public static String urlToClassName(String name) {
        return JavaCompiler.mangleName("jsp/" + name);
    }

    void addPending(JspCompilerInstance pending) {
        this._pending.add(pending);
    }

    void compilePending() throws Exception {
        if (this._pending.size() == 0) {
            return;
        }
        ArrayList<JspCompilerInstance> pendingList = new ArrayList<JspCompilerInstance>(this._pending);
        for (int i = 0; i < pendingList.size(); ++i) {
            JspCompilerInstance pending = pendingList.get(i);
            pending.completeTag();
        }
        this._pending.clear();
    }

    public Page compile(Path jspPath, String uri) throws Exception {
        return this.getCompilerInstance(jspPath, uri).compile();
    }

    public JspCompilerInstance getCompilerInstance(Path jspPath, String uri) throws Exception {
        return this.getCompilerInstance(jspPath, uri, null);
    }

    public JspCompilerInstance getCompilerInstance(Path jspPath, String uri, String className) throws Exception {
        JspCompilerInstance instance = new JspCompilerInstance(this);
        instance.setJspPath(jspPath);
        instance.setURI(uri);
        instance.setClassName(className);
        instance.init();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileJava(Path path, String className, LineMap lineMap, String charEncoding) throws Exception {
        Path classPath = path.getParent().lookup(className + ".class");
        JavaCompiler compiler = JavaCompiler.create(null);
        compiler.setClassDir(this.getClassDir());
        compiler.setEncoding(charEncoding);
        String fileName = className.replace('.', '/') + ".java";
        boolean remove = true;
        try {
            compiler.compile(fileName, lineMap);
        }
        finally {
            if (remove) {
                Vfs.lookup(fileName).remove();
            }
        }
    }

    public Page loadPage(String className, boolean isAutoCompile) throws Throwable {
        JspPage jspPage = (JspPage)this.loadClass(className, isAutoCompile);
        Page page = jspPage instanceof Page ? (Page)jspPage : (jspPage instanceof SingleThreadModel ? new SingleThreadWrapperPage((HttpJspPage)jspPage) : new WrapperPage((HttpJspPage)jspPage));
        return page;
    }

    public Object loadClass(String className, boolean autoCompile) throws Throwable {
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        DynamicClassLoader jspLoader = SimpleLoader.create(parentLoader, this.getClassDir(), null);
        try {
            Class cl = CauchoSystem.loadClass(className, false, jspLoader);
            this.readSmap(parentLoader, className);
            return cl.newInstance();
        }
        catch (Throwable e) {
            if (autoCompile) {
                try {
                    String pathName = className.replace('.', '/') + ".class";
                    Path classPath = this.getClassDir().lookup(pathName);
                    classPath.remove();
                }
                catch (IOException e1) {
                    log.log(Level.FINE, e1.toString(), e1);
                }
            }
            throw e;
        }
    }

    public Page loadStatic(String className, boolean isSession) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String staticName = className.replace('.', '/') + ".static";
        Path path = this.getClassDir().lookup(staticName);
        return new StaticPage(path, isSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSmap(ClassLoader loader, String className) {
        if (loader == null) {
            return;
        }
        String smapName = className.replace('.', '/') + ".java.smap";
        InputStream is = null;
        try {
            is = loader.getResourceAsStream(smapName);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ClassLoader loader;
        Path appDir;
        Application app;
        if (args.length == 0) {
            System.out.println("usage: com.caucho.jsp.JspCompiler [flags] jsp1 jsp2 ...");
            System.out.println(" -app-dir  : The directory root of the web-app.");
            System.out.println(" -class-dir: The working directory to use as output.");
            System.out.println(" -conf: A configuration file for the compiler.");
            System.exit(1);
        }
        JspCompiler compiler = new JspCompiler();
        int i = 0;
        boolean hasConf = false;
        while (i < args.length) {
            if (args[i].equals("-app-dir")) {
                Path appDir2 = Vfs.lookup(args[i + 1]);
                Application app2 = compiler.createApplication();
                app2.setDocumentDirectory(appDir2);
                compiler.setApplication(app2);
                i += 2;
                continue;
            }
            if (args[i].equals("-class-dir") || args[i].equals("-d")) {
                compiler.setClassDirectory(Vfs.lookup(args[i + 1]));
                i += 2;
                continue;
            }
            if (!args[i].equals("-conf")) break;
            Path path = Vfs.lookup(args[i + 1]);
            new NodeBuilder().configureNoInit((Object)compiler, path);
            hasConf = true;
            i += 2;
        }
        if ((app = compiler.getApplication()) != null && !hasConf) {
            appDir = app.getAppDir();
            loader = app.getClassLoader();
            ((DynamicClassLoader)loader).addLoader(new CompilingLoader(appDir.lookup("WEB-INF/classes")));
            ((DynamicClassLoader)loader).addLoader(new DirectoryLoader(appDir.lookup("WEB-INF/lib")));
            Path webXml = appDir.lookup("WEB-INF/web.xml");
            if (webXml.canRead()) {
                new NodeBuilder().configureNoInit((Object)app, webXml);
            }
        }
        appDir = null;
        loader = Thread.currentThread().getContextClassLoader();
        if (app != null) {
            app.init();
            appDir = compiler.getApplication().getAppDir();
            loader = compiler.getApplication().getClassLoader();
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            while (i < args.length) {
                String uri = args[i];
                Path jspPath = Vfs.lookup(uri);
                if (appDir != null) {
                    uri = jspPath.getPath().substring(appDir.getPath().length());
                }
                compiler.compile(jspPath, uri);
                ++i;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }
}

