/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.LineMap;
import com.caucho.jsp.AppResourceManager;
import com.caucho.jsp.CauchoPage;
import com.caucho.jsp.JspCompiler;
import com.caucho.jsp.JspCompilerInstance;
import com.caucho.jsp.Page;
import com.caucho.jsp.PageManager;
import com.caucho.jsp.QJspFactory;
import com.caucho.jsp.SingleThreadWrapperPage;
import com.caucho.jsp.StaticPage;
import com.caucho.jsp.TldManager;
import com.caucho.jsp.WrapperPage;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.log.Log;
import com.caucho.make.PersistentDependency;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.webapp.Application;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.SingleThreadModel;
import javax.servlet.jsp.HttpJspPage;
import javax.servlet.jsp.JspFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspManager
extends PageManager {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jsp/JspManager"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jsp/JspManager"));
    private static int _count;
    private boolean _isXml;
    private boolean _precompile = true;

    public JspManager(Application app) {
        super(app);
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new QJspFactory());
        }
        try {
            TldManager.create(new AppResourceManager(app), app);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public boolean getPrecompile() {
        return this._precompile;
    }

    public void setXml(boolean isXml) {
        this._isXml = isXml;
    }

    @Override
    Page createPage(Path path, String uri, String className, ArrayList<PersistentDependency> dependList) throws Exception {
        Object jspClass = null;
        Page page = this.compile(path, uri, className, dependList);
        if (page == null) {
            return null;
        }
        page = this.loadPage(page, null);
        boolean alwaysModified = false;
        if (alwaysModified) {
            page._caucho_setAlwaysModified();
        }
        return page;
    }

    Page compile(Path path, String uri, String className, ArrayList<PersistentDependency> dependList) throws Exception {
        Application app = this.getApplication();
        JspCompiler compiler = new JspCompiler();
        compiler.setApplication(this._application);
        compiler.setXml(this._isXml);
        Page page = null;
        try {
            if (this._precompile || this._autoCompile) {
                page = this.preload(className, app.getClassLoader(), app.getAppDir());
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (page != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(new StringBuffer().append("loading pre-compiled page for ").append(uri).toString());
            }
            return page;
        }
        if (path == null || !path.canRead() || path.isDirectory() || !this._autoCompile) {
            return null;
        }
        JspCompilerInstance compilerInst = compiler.getCompilerInstance(path, uri, className);
        compilerInst.addDependList(dependList);
        page = compilerInst.compile();
        Path classPath = this.getClassDir().lookup(new StringBuffer().append(className.replace('.', '/')).append(".class").toString());
        page._caucho_addDepend(new Depend(classPath));
        return page;
    }

    void killPage(CauchoRequest request, CauchoResponse response, Page page) {
    }

    Page preload(String className, ClassLoader parentLoader, Path appDir) throws Exception {
        String fullClassName = className;
        String mangledName = fullClassName.replace('.', '/');
        Path classPath = this.getClassDir().lookup(new StringBuffer().append(mangledName).append(".class").toString());
        if (!classPath.exists()) {
            return this.preloadStatic(mangledName);
        }
        DynamicClassLoader loader = SimpleLoader.create(parentLoader, this.getClassDir(), null);
        Class cl = null;
        try {
            cl = CauchoSystem.loadClass(fullClassName, false, loader);
        }
        catch (ClassNotFoundException e) {
            log.finest(e.toString());
            return null;
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
            if (this._autoCompile) {
                try {
                    classPath.remove();
                }
                catch (IOException e1) {
                    log.log(Level.FINE, e1.toString(), e1);
                }
            }
            return null;
        }
        HttpJspPage jspPage = (HttpJspPage)cl.newInstance();
        Page page = null;
        if (jspPage instanceof CauchoPage) {
            CauchoPage cPage = (CauchoPage)jspPage;
            LineMap lineMap = new LineMap();
            cPage.init(lineMap, appDir);
            if (cPage instanceof Page) {
                ((Page)cPage)._caucho_setJspManager(this);
            }
            if (this._autoCompile && cPage._caucho_isModified()) {
                return null;
            }
            page = cPage instanceof Page ? (Page)cPage : new WrapperPage(jspPage);
        } else {
            page = jspPage instanceof SingleThreadModel ? new SingleThreadWrapperPage(jspPage) : new WrapperPage(jspPage);
        }
        page._caucho_addDepend(new Depend(classPath));
        return page;
    }

    private Page preloadStatic(String mangledName) {
        String staticName = new StringBuffer().append(mangledName).append(".static").toString();
        String dependName = new StringBuffer().append(mangledName).append(".depend").toString();
        Path staticPath = this.getClassDir().lookup(staticName);
        if (!staticPath.canRead()) {
            return null;
        }
        Path dependPath = this.getClassDir().lookup(dependName);
        if (!dependPath.canRead()) {
            return null;
        }
        try {
            ArrayList<Depend> dependList = StaticPage.parseDepend(dependPath);
            if (dependList == null) {
                return null;
            }
            StaticPage page = new StaticPage(staticPath, true);
            for (int i = 0; i < dependList.size(); ++i) {
                Depend depend = dependList.get(i);
                if (depend.isModified()) {
                    return null;
                }
                page._caucho_addDepend(depend);
            }
            return page;
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    private Page loadPage(Page page, LineMap lineMap) throws Exception {
        page.init(lineMap, this._application.getAppDir());
        page._caucho_setJspManager(this);
        return page;
    }

    void unload(Page page) {
    }
}

