/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public class BundleTag
extends TagSupport
implements TryCatchFinally {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/el/BundleTag"));
    private Expr basenameExpr;
    private Expr prefixExpr;
    private Object oldBundle;
    private Object oldPrefix;

    public void setBasename(Expr basename) {
        this.basenameExpr = basename;
    }

    public void setPrefix(Expr prefix) {
        this.prefixExpr = prefix;
    }

    public int doStartTag() throws JspException {
        try {
            PageContextImpl pc = (PageContextImpl)this.pageContext;
            String basename = this.basenameExpr.evalString(pc);
            this.oldBundle = pc.getAttribute("caucho.bundle");
            this.oldPrefix = pc.getAttribute("caucho.bundle.prefix");
            LocalizationContext bundle = pc.getBundle(basename);
            pc.setAttribute("caucho.bundle", bundle);
            if (this.prefixExpr != null) {
                String prefix = this.prefixExpr.evalString(pc);
                pc.setAttribute("caucho.bundle.prefix", prefix);
            } else if (this.oldPrefix != null) {
                pc.removeAttribute("caucho.bundle.prefix");
            }
            return 1;
        }
        catch (ELException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        if (this.oldBundle == null) {
            this.pageContext.removeAttribute("caucho.bundle");
        } else {
            this.pageContext.setAttribute("caucho.bundle", this.oldBundle);
        }
        if (this.oldPrefix == null) {
            this.pageContext.removeAttribute("caucho.bundle.prefix");
        } else {
            this.pageContext.setAttribute("caucho.bundle.prefix", this.oldPrefix);
        }
    }

    public static Object setBundle(String baseName, PageContextImpl pc) {
        Object oldBundle = pc.getAttribute("caucho.bundle");
        LocalizationContext bundle = pc.getBundle(baseName);
        pc.setAttribute("caucho.bundle", bundle);
        return oldBundle;
    }
}

