/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.jstl.el.SqlQueryTag;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.sql.SQLExecutionTag;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.sql.DataSource;

public class SqlUpdateTag
extends BodyTagSupport
implements SQLExecutionTag {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jstl/el/SqlUpdateTag"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/el/SqlUpdateTag"));
    private Expr _sql;
    private String _var;
    private String _scope;
    private Expr _dataSource;
    private ArrayList<Object> _params;

    public void setSql(Expr sql) {
        this._sql = sql;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setDataSource(Expr dataSource) {
        this._dataSource = dataSource;
    }

    public void addSQLParameter(Object value) {
        if (this._params == null) {
            this._params = new ArrayList();
        }
        this._params.add(value);
    }

    public int doEndTag() throws JspException {
        Connection conn = null;
        boolean isTransaction = false;
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        try {
            Statement stmt;
            String sql = this._sql != null ? this._sql.evalString(pageContext) : this.bodyContent.getString();
            conn = (Connection)pageContext.getAttribute("caucho.jstl.sql.conn");
            if (conn != null) {
                isTransaction = true;
            }
            if (!isTransaction) {
                DataSource ds = this._dataSource != null ? SqlQueryTag.getDataSource(pageContext, this._dataSource.evalObject(pageContext)) : SqlQueryTag.getDataSource(pageContext, null);
                conn = ds.getConnection();
            }
            Object value = null;
            ArrayList<Object> params = this._params;
            this._params = null;
            int rows = 0;
            if (params == null) {
                stmt = conn.createStatement();
                rows = stmt.executeUpdate(sql);
            } else {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                stmt = pstmt;
                for (int i = 0; i < params.size(); ++i) {
                    Object paramValue = params.get(i);
                    if (paramValue == null) {
                        pstmt.setNull(i + 1, 12);
                        continue;
                    }
                    pstmt.setObject(i + 1, paramValue);
                }
                rows = pstmt.executeUpdate();
            }
            stmt.close();
            CoreSetTag.setValue(pageContext, this._var, this._scope, new Integer(rows));
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (!isTransaction && conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        return 6;
    }
}

