/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.DynamicClassLoaderMBean;
import com.caucho.loader.JarLoader;
import com.caucho.loader.Loader;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.WeakCloseListener;
import com.caucho.log.Log;
import com.caucho.make.AlwaysModified;
import com.caucho.make.Dependency;
import com.caucho.make.DependencyContainer;
import com.caucho.make.Make;
import com.caucho.make.MakeContainer;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClassLoader
extends URLClassLoader
implements Dependency,
Make,
DynamicClassLoaderMBean {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/loader/DynamicClassLoader"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/loader/DynamicClassLoader"));
    private static final URL[] NULL_URL_ARRAY = new URL[0];
    private static long _globalDependencyCheckInterval = 2000L;
    private String _id;
    private ArrayList<Loader> _loaders = new ArrayList();
    private JarLoader _jarLoader;
    private Hashtable<String, ClassEntry> _entryCache;
    private DependencyContainer _dependencies = new DependencyContainer();
    private boolean _isEnableDependencyCheck = false;
    private MakeContainer _makeList;
    private boolean _useServletHack;
    private String[] _parentPriorityPackages;
    private ArrayList<ClassLoaderListener> _listeners;
    private SecurityManager _securityManager;
    private ArrayList<Permission> _permissions;
    private CodeSource _codeSource;
    private URL[] _urls = NULL_URL_ARRAY;
    private WeakCloseListener _closeListener;
    private final Lifecycle _lifecycle = new Lifecycle();

    public DynamicClassLoader(ClassLoader parent) {
        this(parent, true);
    }

    public DynamicClassLoader(ClassLoader parent, boolean enableDependencyCheck) {
        super(NULL_URL_ARRAY, DynamicClassLoader.getInitParent(parent));
        this._securityManager = System.getSecurityManager();
        this._isEnableDependencyCheck = enableDependencyCheck;
        this._dependencies.setCheckInterval(_globalDependencyCheckInterval);
        for (parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof DynamicClassLoader)) continue;
            DynamicClassLoader loader = (DynamicClassLoader)parent;
            loader.init();
            this.addPermissions(loader.getPermissions());
            this._dependencies.add(loader);
            this._dependencies.setCheckInterval(loader.getDependencyCheckInterval());
            this._useServletHack = loader._useServletHack;
            break;
        }
    }

    private static ClassLoader getInitParent(ClassLoader parent) {
        if (parent != null) {
            return parent;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static long getGlobalDependencyCheckInterval() {
        return _globalDependencyCheckInterval;
    }

    public static void setGlobalDependencyCheckInterval(long interval) {
        _globalDependencyCheckInterval = interval;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public void addLoader(Loader loader) {
        this.addLoader(loader, this._loaders.size());
    }

    public void addLoader(Loader loader, int offset) {
        if (this._lifecycle.isDestroyed()) {
            throw new IllegalStateException(L.l("can't add loaders after initialization"));
        }
        this._loaders.add(offset, loader);
        if (loader.getLoader() == null) {
            loader.setLoader(this);
        }
        if (loader instanceof Dependency) {
            this._dependencies.add((Dependency)((Object)loader));
        }
        if (loader instanceof Make) {
            if (this._makeList == null) {
                this._makeList = new MakeContainer();
            }
            this._makeList.add((Make)((Object)loader));
        }
        if (loader instanceof ClassLoaderListener) {
            this.addListener((ClassLoaderListener)((Object)loader));
        }
    }

    public ArrayList<Loader> getLoaders() {
        return this._loaders;
    }

    public void addJar(Path jar) {
        if (this._lifecycle.isDestroyed()) {
            throw new IllegalStateException(L.l("can't add jars after closing"));
        }
        if (jar.isDirectory()) {
            SimpleLoader loader = new SimpleLoader();
            loader.setPath(jar);
            this.addLoader(loader);
            return;
        }
        if (this._jarLoader == null) {
            this._jarLoader = new JarLoader();
            this.addLoader(this._jarLoader);
        }
        this._jarLoader.addJar(jar);
    }

    public void addURL(Path path) {
        try {
            if (path.getScheme().equals("memory")) {
                return;
            }
            if (!path.getScheme().equals("jar") && !path.getURL().endsWith("/")) {
                path = path.lookup("./");
            }
            this.addURL(new URL(path.getURL()));
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void addURL(URL url) {
        this.addURL(this._urls.length, url);
    }

    public void addURL(int index, URL url) {
        int i;
        super.addURL(url);
        URL[] newURLs = new URL[this._urls.length + 1];
        for (i = 0; i < index; ++i) {
            newURLs[i] = this._urls[i];
        }
        newURLs[index] = url;
        for (i = index + 1; i < newURLs.length; ++i) {
            newURLs[i] = this._urls[i - 1];
        }
        this._urls = newURLs;
    }

    @Override
    public URL[] getURLs() {
        return this._urls;
    }

    public void setDependencyCheckInterval(long interval) {
        this._dependencies.setCheckInterval(interval);
    }

    public long getDependencyCheckInterval() {
        if (this._dependencies != null) {
            return this._dependencies.getCheckInterval();
        }
        return 0L;
    }

    public void setEnableDependencyCheck(boolean enable) {
        this._isEnableDependencyCheck = enable;
    }

    public void addDependency(Dependency dependency) {
        this._dependencies.add(dependency);
    }

    public void addPermission(String path, String actions) {
        this.addPermission(new FilePermission(path, actions));
    }

    public void addPermission(Permission permission) {
        if (this._permissions == null) {
            this._permissions = new ArrayList();
        }
        this._permissions.add(permission);
    }

    public ArrayList<Permission> getPermissions() {
        return this._permissions;
    }

    public void addPermissions(ArrayList<Permission> perms) {
        if (perms == null) {
            return;
        }
        if (this._permissions == null) {
            this._permissions = new ArrayList();
        }
        this._permissions.addAll(perms);
    }

    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    public void setServletHack(boolean servletHack) {
        this._useServletHack = servletHack;
        if (this._parentPriorityPackages == null) {
            this._parentPriorityPackages = new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(ClassLoaderListener listener) {
        ArrayList<ClassLoaderListener> listeners;
        if (this._lifecycle.isDestroyed()) {
            IllegalStateException e = new IllegalStateException(L.l("attempted to add listener to a closed classloader {0}", this));
            log.log(Level.WARNING, e.toString(), e);
            return;
        }
        WeakCloseListener closeListener = null;
        Object object = this;
        synchronized (object) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
                this._closeListener = closeListener = new WeakCloseListener(this);
            }
            listeners = this._listeners;
        }
        if (closeListener != null) {
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof DynamicClassLoader)) continue;
                ((DynamicClassLoader)parent).addListener(closeListener);
                break;
            }
        }
        object = listeners;
        synchronized (object) {
            for (int i = listeners.size() - 1; i >= 0; --i) {
                ClassLoaderListener oldListener = listeners.get(i);
                if (listener == oldListener) {
                    return;
                }
                if (oldListener != null) continue;
                listeners.remove(i);
            }
            listeners.add(listener);
        }
        if (this._lifecycle.isActive()) {
            listener.classLoaderInit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(ClassLoaderListener listener) {
        ArrayList<ClassLoaderListener> listeners = this._listeners;
        if (listeners == null) {
            return;
        }
        ArrayList<ClassLoaderListener> arrayList = listeners;
        synchronized (arrayList) {
            for (int i = listeners.size() - 1; i >= 0; --i) {
                ClassLoaderListener oldListener = listeners.get(i);
                if (listener == oldListener) {
                    listeners.remove(i);
                    return;
                }
                if (oldListener != null) continue;
                listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<ClassLoaderListener> getListeners() {
        ArrayList<ClassLoaderListener> listeners = new ArrayList<ClassLoaderListener>();
        ArrayList<ClassLoaderListener> listenerList = this._listeners;
        if (listenerList != null) {
            ArrayList<ClassLoaderListener> arrayList = listenerList;
            synchronized (arrayList) {
                for (int i = 0; i < listenerList.size(); ++i) {
                    ClassLoaderListener listener = listenerList.get(i);
                    if (listener != null) {
                        listeners.add(listener);
                        continue;
                    }
                    listenerList.remove(i);
                    --i;
                }
            }
        }
        return listeners;
    }

    public void addParentPriorityPackages(String[] pkg) {
        for (int i = 0; pkg != null && i < pkg.length; ++i) {
            this.addParentPriorityPackage(pkg[i]);
        }
    }

    public void addParentPriorityPackage(String pkg) {
        if (this._parentPriorityPackages == null) {
            this._parentPriorityPackages = new String[0];
        }
        int oldLength = this._parentPriorityPackages.length;
        String[] newPkgs = new String[oldLength + 1];
        System.arraycopy(this._parentPriorityPackages, 0, newPkgs, 0, oldLength);
        if (!pkg.endsWith(".")) {
            pkg = new StringBuffer().append(pkg).append('.').toString();
        }
        newPkgs[oldLength] = pkg;
        this._parentPriorityPackages = newPkgs;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection perms = super.getPermissions(codeSource);
        ArrayList<Permission> permissions = this._permissions;
        for (int i = 0; permissions != null && i < permissions.size(); ++i) {
            Permission permission = permissions.get(i);
            perms.add(permission);
        }
        return perms;
    }

    protected void addCodeBasePath(String path) {
    }

    public final String getClassPath() {
        ClassLoader parent = this.getParent();
        String head = parent instanceof DynamicClassLoader ? ((DynamicClassLoader)parent).getClassPath() : CauchoSystem.getClassPath();
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = this._loaders.get(i);
            head = loader.getClassPath(head);
        }
        return head;
    }

    public final String getSourcePath() {
        ClassLoader parent = this.getParent();
        String head = parent instanceof DynamicClassLoader ? ((DynamicClassLoader)parent).getSourcePath() : CauchoSystem.getClassPath();
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = this._loaders.get(i);
            head = loader.getSourcePath(head);
        }
        return head;
    }

    public final String getResourcePathSpecificFirst() {
        ClassLoader parent = this.getParent();
        String head = "";
        int size = this._loaders != null ? this._loaders.size() : 0;
        for (int i = 0; i < size; ++i) {
            Loader loader = this._loaders.get(i);
            head = loader.getSourcePath(head);
        }
        String tail = parent instanceof DynamicClassLoader ? ((DynamicClassLoader)parent).getResourcePathSpecificFirst() : CauchoSystem.getClassPath();
        if (head == null || head.equals("")) {
            return tail;
        }
        if (tail == null || tail.equals("")) {
            return head;
        }
        return new StringBuffer().append(head).append(CauchoSystem.getPathSeparatorChar()).append(tail).toString();
    }

    @Override
    public final boolean isModified() {
        return this.isModified(this._isEnableDependencyCheck);
    }

    public final boolean isModified(boolean enable) {
        if (this._lifecycle.isDestroyed()) {
            return true;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return true;
        }
        if (enable) {
            return dependencies.isModified();
        }
        return DynamicClassLoader.isModified(this.getParent());
    }

    public final void resetDependencyCheckInterval() {
        if (this._lifecycle.isDestroyed()) {
            return;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return;
        }
        dependencies.resetDependencyCheckInterval();
    }

    public static boolean isModified(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof DynamicClassLoader) {
                return ((DynamicClassLoader)loader).isModified();
            }
            loader = loader.getParent();
        }
        return false;
    }

    @Override
    public final void make() throws Exception {
        for (ClassLoader loader = this.getParent(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof Make)) continue;
            ((Make)((Object)loader)).make();
            break;
        }
        if (this._makeList != null) {
            this._makeList.make();
        }
    }

    @Override
    protected Package definePackage(String name, String a1, String a2, String a3, String b1, String b2, String b3, URL url) {
        if ((name = name.replace('/', '.')).endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        return super.definePackage(name, a1, a2, a3, b1, b2, b3, url);
    }

    public void init() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        try {
            ArrayList<ClassLoaderListener> listeners = this.getListeners();
            if (listeners != null) {
                for (int i = 0; i < listeners.size(); ++i) {
                    ClassLoaderListener listener = listeners.get(i);
                    listener.classLoaderInit(this);
                }
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void validate() throws ConfigException {
        for (int i = 0; i < this._loaders.size(); ++i) {
            this._loaders.get(i).validate();
        }
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl;
        block12: {
            cl = this.findLoadedClass(name);
            if (cl != null) {
                if (resolve) {
                    this.resolveClass(cl);
                }
                return cl;
            }
            if (this._lifecycle.isDestroyed()) {
                log.fine(L.l("Loading class {0} when class loader {1} has been closed.", (Object)name, this));
                return super.loadClass(name, resolve);
            }
            boolean normalJdkOrder = this.isNormalJdkOrder(name);
            if (this._lifecycle.isBeforeInit()) {
                this.init();
            }
            if (normalJdkOrder) {
                try {
                    ClassLoader parent = this.getParent();
                    if (parent != null) {
                        cl = Class.forName(name, false, parent);
                        break block12;
                    }
                    cl = this.findSystemClass(name);
                }
                catch (ClassNotFoundException e) {
                    cl = this.findClass(name);
                }
            } else {
                try {
                    cl = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    ClassLoader parent = this.getParent();
                    cl = parent != null ? Class.forName(name, false, parent) : this.findSystemClass(name);
                }
            }
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        if (this._lifecycle.isDestroyed()) {
            throw new IllegalStateException("Class loader has been closed.");
        }
        if (this._lifecycle.isBeforeInit()) {
            this.init();
        }
        name = name.replace('/', '.');
        ClassEntry entry = null;
        DynamicClassLoader dynamicClassLoader = this;
        synchronized (dynamicClassLoader) {
            ClassEntry classEntry = entry = this._entryCache == null ? null : this._entryCache.get(name);
            if (entry == null) {
                entry = this.getClassEntry(name);
            }
            if (this._isEnableDependencyCheck && entry != null && entry.addDependencies(this._dependencies)) {
                if (this._entryCache == null) {
                    this._entryCache = new Hashtable(8);
                }
                this._entryCache.put(name, entry);
            }
        }
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            return this.loadClass(entry);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            throw new ClassNotFoundException(new StringBuffer().append(name).append(" [").append(e).append("]").toString(), e);
        }
    }

    protected ClassEntry getClassEntry(String name) throws ClassNotFoundException {
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = this._loaders.get(i);
            ClassEntry entry = loader.getClassEntry(name);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(ClassEntry entry) throws IOException, ClassNotFoundException {
        Class<?> cl = entry.getEntryClass();
        if (cl != null) {
            return cl;
        }
        ClassEntry classEntry = entry;
        synchronized (classEntry) {
            cl = entry.getEntryClass();
            if (cl != null) {
                return cl;
            }
            entry.preLoad();
            String name = entry.getName();
            int p = name.lastIndexOf(46);
            if (p > 0) {
                String packageName = name.substring(0, p);
                Package pkg = this.getPackage(packageName);
                ClassPackage classPackage = entry.getClassPackage();
                if (pkg == null) {
                    if (classPackage != null) {
                        this.definePackage(packageName, classPackage.getSpecificationTitle(), classPackage.getSpecificationVersion(), classPackage.getSpecificationVendor(), classPackage.getImplementationTitle(), classPackage.getImplementationVersion(), classPackage.getImplementationVendor(), null);
                    } else {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                }
            }
            ByteBuffer buffer = new ByteBuffer();
            entry.load(buffer);
            try {
                cl = this.defineClass(entry.getName(), buffer.getBuffer(), 0, buffer.length(), entry.getCodeSource());
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                ClassNotFoundException exn = new ClassNotFoundException(new StringBuffer().append(entry.getName()).append(" [").append(e).append("]").toString(), e);
                throw exn;
            }
            entry.setEntryClass(cl);
            if (entry.postLoad()) {
                this._dependencies.add(AlwaysModified.create());
                this._dependencies.setModified(true);
            }
            return cl;
        }
    }

    @Override
    public URL getResource(String name) {
        boolean isNormalJdkOrder = this.isNormalJdkOrder(name);
        ClassLoader parent = this.getParent();
        if (isNormalJdkOrder) {
            URL url = DynamicClassLoader.getSystemResource(name);
            if (url != null) {
                return url;
            }
            if (parent != null) {
                url = parent.getResource(name);
            }
            if (url != null) {
                return url;
            }
        }
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = this._loaders.get(i);
            URL url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        if (!isNormalJdkOrder) {
            URL url = DynamicClassLoader.getSystemResource(name);
            if (url != null) {
                return url;
            }
            if (parent != null) {
                url = parent.getResource(name);
            }
            if (url != null) {
                return url;
            }
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        boolean isNormalJdkOrder = this.isNormalJdkOrder(name);
        ClassLoader parent = this.getParent();
        if (isNormalJdkOrder) {
            InputStream is = DynamicClassLoader.getSystemResourceAsStream(name);
            if (is != null) {
                return is;
            }
            if (parent != null) {
                is = parent.getResourceAsStream(name);
            }
            if (is != null) {
                return is;
            }
        }
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = this._loaders.get(i);
            InputStream is = loader.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        if (!isNormalJdkOrder) {
            InputStream is = DynamicClassLoader.getSystemResourceAsStream(name);
            if (is != null) {
                return is;
            }
            if (parent != null) {
                is = parent.getResourceAsStream(name);
            }
            if (is != null) {
                return is;
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        Vector<URL> resources = new Vector<URL>();
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = this._loaders.get(i);
            loader.getResources(resources, name);
        }
        return resources.elements();
    }

    @Override
    public String findLibrary(String name) {
        String systemName = System.mapLibraryName(name);
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = this._loaders.get(i);
            Path path = loader.getPath(systemName);
            if (path == null || !path.canRead()) continue;
            return path.getNativePath();
        }
        return super.findLibrary(name);
    }

    public Path findPath(String name) {
        for (int i = 0; i < this._loaders.size(); ++i) {
            Loader loader = this._loaders.get(i);
            Path path = loader.getPath(name);
            if (path == null || !path.canRead()) continue;
            return path;
        }
        return null;
    }

    private boolean isNormalJdkOrder(String className) {
        if (!this._useServletHack) {
            return true;
        }
        String[] pkgs = this._parentPriorityPackages;
        String canonName = className.replace('/', '.');
        for (int i = 0; pkgs != null && i < pkgs.length; ++i) {
            if (!canonName.startsWith(pkgs[i])) continue;
            return true;
        }
        return false;
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroying()) {
            return;
        }
        try {
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof DynamicClassLoader)) continue;
                DynamicClassLoader loader = (DynamicClassLoader)parent;
                loader.removeListener(this._closeListener);
            }
            ArrayList<ClassLoaderListener> listeners = this.getListeners();
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                for (int i = listeners.size() - 1; i >= 0; --i) {
                    ClassLoaderListener listener = listeners.get(i);
                    try {
                        thread.setContextClassLoader(this);
                        listener.classLoaderDestroy(this);
                        continue;
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
        finally {
            this._listeners = null;
            this._entryCache = null;
            this._makeList = null;
            this._loaders = null;
            this._jarLoader = null;
            this._dependencies = null;
            this._permissions = null;
            this._securityManager = null;
            this._codeSource = null;
            this._lifecycle.toDestroy();
        }
    }

    public static void setOldLoader(Thread thread, ClassLoader oldLoader) {
        if (!(oldLoader instanceof DynamicClassLoader)) {
            thread.setContextClassLoader(oldLoader);
            return;
        }
        DynamicClassLoader dynLoader = (DynamicClassLoader)oldLoader;
        if (!dynLoader.isDestroyed()) {
            thread.setContextClassLoader(oldLoader);
        } else {
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
    }

    protected void replace(DynamicClassLoader source) {
        this._id = source._id;
        this._loaders.addAll(source._loaders);
        this._jarLoader = source._jarLoader;
        this._dependencies = source._dependencies;
        this._makeList = source._makeList;
        this._useServletHack = source._useServletHack;
        this._parentPriorityPackages = source._parentPriorityPackages;
        if (source._listeners != null) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            this._listeners.addAll(source._listeners);
            source._listeners.clear();
        }
        this._securityManager = source._securityManager;
        if (source._permissions != null) {
            if (this._permissions == null) {
                this._permissions = new ArrayList();
            }
            this._permissions.addAll(source._permissions);
        }
        this._codeSource = source._codeSource;
        this._lifecycle.copyState(source._lifecycle);
    }

    public String toString() {
        if (this._id != null) {
            return new StringBuffer().append("DynamicClassLoader[").append(this._id).append("]").toString();
        }
        return new StringBuffer().append("DynamicClassLoader").append(this._loaders).toString();
    }

    protected void finalize() {
        this.destroy();
    }
}

