/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.CodeEnhancer;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.bytecode.Utf8Constant;
import com.caucho.java.CompileClassNotFound;
import com.caucho.java.WorkDir;
import com.caucho.java.gen.JavaClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.Loader;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.enhancer.Enhancer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;

public class EnhancingClassLoader
extends EnvironmentClassLoader {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/loader/enhancer/EnhancingClassLoader"));
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private EnvironmentClassLoader _rawLoader;
    private JavaClassGenerator _javaGen = new JavaClassGenerator();
    private ArrayList<Enhancer> _enhancers = new ArrayList();
    private Path _workPath;
    private String _baseSuffix = "";
    private String _extSuffix = "__ResinExt";
    private boolean _isParentStarted;

    public EnhancingClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public EnhancingClassLoader(ClassLoader parent) {
        super(parent);
        this._rawLoader = new EnvironmentClassLoader(parent);
        this.addDependency(this._rawLoader);
    }

    public static void enhance(Enhancer enhancer) {
        EnhancingClassLoader enhancingLoader = EnhancingClassLoader.enhanceClassLoader();
        enhancingLoader.addEnhancer(enhancer);
    }

    public static EnhancingClassLoader enhanceClassLoader() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader instanceof EnhancingClassLoader) {
            EnhancingClassLoader enhancingLoader = (EnhancingClassLoader)classLoader;
            return enhancingLoader;
        }
        throw new IllegalStateException(L.l("Enhancement needs an EnhancingClassLoader at '{0}'.", classLoader));
    }

    public void setId(String id) {
        if (id != null) {
            super.setId("Enhancer[" + id + "]");
        } else {
            super.setId(null);
        }
        this.getRawLoader().setId(id);
    }

    public EnvironmentClassLoader getRawLoader() {
        return this._rawLoader;
    }

    public void addEnhancer(Enhancer enhancer) {
        this._enhancers.add(enhancer);
        enhancer.setEnhancingClassLoader(this);
    }

    public void addLoader(Loader loader, int offset) {
        super.addLoader(loader, offset);
        this.getRawLoader().addLoader(loader, offset);
    }

    public Object setAttribute(String name, Object obj) {
        Object value = super.setAttribute(name, obj);
        this.getRawLoader().setAttribute(name, obj);
        return value;
    }

    public Object removeAttribute(String name) {
        Object value = super.removeAttribute(name);
        this.getRawLoader().removeAttribute(name);
        return value;
    }

    public void addJar(Path jar) {
        super.addJar(jar);
        this.getRawLoader().addJar(jar);
    }

    public Path getWorkPath() {
        if (this._workPath != null) {
            return this._workPath;
        }
        return WorkDir.getLocalWorkDir(this);
    }

    public void setWorkPath(Path workPath) {
        this._workPath = workPath;
    }

    public final Path getPreWorkPath() {
        return this.getWorkPath().lookup("pre-enhance");
    }

    public final Path getPostWorkPath() {
        return this.getWorkPath().lookup("post-enhance");
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl != null) {
            if (resolve) {
                this.resolveClass(cl);
            }
            return cl;
        }
        if (this.isDestroyed()) {
            throw new IllegalStateException("Class loader has been closed: " + this);
        }
        try {
            ClassEntry entry;
            boolean shouldEnhance = false;
            for (int i = 0; i < this._enhancers.size(); ++i) {
                Enhancer enhancer = this._enhancers.get(i);
                if (!enhancer.shouldEnhance(name)) continue;
                shouldEnhance = true;
                break;
            }
            if (shouldEnhance && (entry = this.enhance(name)) != null) {
                return this.loadClass(entry);
            }
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileClassNotFound(e);
        }
    }

    private ClassEntry enhance(String className) throws ClassNotFoundException {
        ClassEntry entry = this.preload(className);
        if (entry != null) {
            return entry;
        }
        String extSuffix = "__ResinExt";
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getRawLoader());
            String extClassName = className + extSuffix;
            if (this.extIsModified(extClassName)) {
                log.info("Enhancing class " + className);
                this.enhanceClass(className);
                this._javaGen.compilePendingJava();
            }
            this.fixup(className, extClassName);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileClassNotFound(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        Path source = this.getSource(className);
        Path target = this.getPostWorkPath().lookup(className.replace('.', '/') + ".class");
        return new ClassEntry(this, className, source, target, null);
    }

    protected final void enhanceClass(String className) throws Exception {
        if (this.renameClass(className, className) == null) {
            return;
        }
        String extClassName = className + "__ResinExt";
        Class<?> baseClass = Class.forName(className, false, this.getRawLoader());
        JavaClass javaClass = new JavaClass(extClassName);
        javaClass.setSuperClassName(className);
        for (int i = 0; i < this._enhancers.size(); ++i) {
            Enhancer enhancer = this._enhancers.get(i);
            enhancer.enhance(javaClass, baseClass, extClassName);
        }
        this._javaGen.setWorkDir(this.getPreWorkPath());
        this._javaGen.generate(javaClass);
    }

    private ClassEntry preload(String className) {
        Path path = this.getWorkPath();
        Path target = path.lookup(className.replace('.', '/') + ".class");
        if (!target.canRead()) {
            return null;
        }
        String sourceName = className;
        if (sourceName.indexOf(36) > 0) {
            sourceName = className.substring(0, sourceName.indexOf(36));
        } else if (sourceName.indexOf(45) > 0) {
            sourceName = className.substring(0, sourceName.indexOf(45));
        }
        Path source = this.getSource(sourceName);
        if (source == null) {
            return null;
        }
        if (target.getLastModified() < source.getLastModified()) {
            return null;
        }
        DynamicClassLoader loader = SimpleLoader.create(this, path);
        loader.setServletHack(true);
        Class<?> cl = null;
        try {
            cl = Class.forName(className, false, loader);
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        if (className.indexOf(36) >= 0 || !this.isModified(cl)) {
            return new ClassEntry(this, className, source, target, null);
        }
        if (className.indexOf(45) >= 0 || !this.isModified(cl)) {
            return new ClassEntry(this, className, source, target, null);
        }
        return null;
    }

    private boolean extIsModified(String extClassName) {
        Path path = this.getPreWorkPath();
        Path target = path.lookup(extClassName.replace('.', '/') + ".class");
        if (!target.canRead()) {
            return true;
        }
        DynamicClassLoader loader = SimpleLoader.create(this.getRawLoader(), path);
        loader.setServletHack(true);
        try {
            Class<?> cl = Class.forName(extClassName, false, loader);
            return this.isModified(cl);
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
            return true;
        }
    }

    protected boolean isModified(Class preloadedClass) {
        for (int i = 0; i < this._enhancers.size(); ++i) {
            Enhancer enhancer = this._enhancers.get(i);
            if (!enhancer.isModified(preloadedClass)) continue;
            return true;
        }
        return false;
    }

    private Path getSource(String className) {
        URL url = super.getResource(className.replace('.', '/') + ".class");
        if (url == null) {
            return null;
        }
        return Vfs.lookup(url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassEntry renameClass(String sourceClass, String targetClass) {
        Path source = this.getSource(sourceClass);
        if (source == null || source.getLastModified() <= 0L) {
            return null;
        }
        Path path = this.getPreWorkPath();
        Path target = path.lookup(targetClass.replace('.', '/') + ".class");
        if (target.getLastModified() <= 0L || target.getLastModified() < source.getLastModified()) {
            try {
                target.remove();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                ByteCodeParser parser = new ByteCodeParser();
                ReadStream is = source.openRead();
                WriteStream os = null;
                try {
                    int i;
                    com.caucho.bytecode.JavaClass cl = parser.parse(is);
                    String cpOldName = sourceClass.replace('.', '/');
                    String cpClassName = targetClass.replace('.', '/');
                    int utf8Index = cl.getConstantPool().addUTF8(cpClassName).getIndex();
                    cl.getConstantPool().getClass(cpOldName).setNameIndex(utf8Index);
                    cl.setThisClass(cpClassName);
                    ArrayList<JavaField> fields = cl.getFieldList();
                    for (int i2 = 0; i2 < fields.size(); ++i2) {
                        JavaField field = fields.get(i2);
                        int accessFlags = field.getAccessFlags();
                        if ((accessFlags & 2) == 0) continue;
                        accessFlags = accessFlags & 0xFFFFFFFD | 4;
                        field.setAccessFlags(accessFlags);
                    }
                    ArrayList<JavaMethod> methods = cl.getMethodList();
                    for (i = 0; i < methods.size(); ++i) {
                        JavaMethod method = methods.get(i);
                        int accessFlags = method.getAccessFlags();
                        if ((accessFlags & 2) == 0) continue;
                        accessFlags = accessFlags & 0xFFFFFFFD | 4;
                        method.setAccessFlags(accessFlags);
                    }
                    for (i = 0; i < this._enhancers.size(); ++i) {
                        this._enhancers.get(i).preEnhance(cl);
                    }
                    target.getParent().mkdirs();
                    os = target.openWrite();
                    cl.write(os);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return new ClassEntry(this, targetClass, source, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameSubClass(String className, Path targetPath, Path extPath) throws Exception {
        com.caucho.bytecode.JavaClass extClass = null;
        ByteCodeParser parser = new ByteCodeParser();
        parser = new ByteCodeParser();
        ReadStream is = extPath.openRead();
        try {
            extClass = parser.parse(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.cleanExtConstantPool(className, extClass);
        WriteStream os = targetPath.openWrite();
        try {
            extClass.write(os);
        }
        finally {
            os.close();
        }
    }

    protected void cleanExtConstantPool(String className, com.caucho.bytecode.JavaClass extClass) throws Exception {
        extClass.setThisClass(this.replaceString(className, extClass.getThisClass()));
        extClass.setSuperClass(this.replaceString(className, extClass.getSuperClass()));
        ArrayList<ConstantPoolEntry> entries = extClass.getConstantPool().getEntries();
        int t = className.lastIndexOf(46);
        if (t > 0) {
            className = className.substring(t + 1);
        }
        String baseName = className + this._baseSuffix;
        String extName = className + "__ResinExt";
        for (int i = 0; i < entries.size(); ++i) {
            ConstantPoolEntry entry = entries.get(i);
            if (!(entry instanceof Utf8Constant)) continue;
            Utf8Constant utf8 = (Utf8Constant)entry;
            String string = utf8.getValue();
            string = this.replaceString(className, string);
            utf8.setValue(string);
        }
        ArrayList<JavaField> fields = extClass.getFieldList();
        for (int i = 0; i < fields.size(); ++i) {
            JavaField field = fields.get(i);
            field.setName(this.replaceString(className, field.getName()));
            field.setDescriptor(this.replaceString(className, field.getDescriptor()));
        }
        ArrayList<JavaMethod> methods = extClass.getMethodList();
        for (int i = 0; i < methods.size(); ++i) {
            JavaMethod method = methods.get(i);
            method.setName(this.replaceString(className, method.getName()));
            method.setDescriptor(this.replaceString(className, method.getDescriptor()));
        }
    }

    private String replaceString(String className, String string) {
        string = this.replaceStringInt(className.replace('.', '/'), string);
        string = this.replaceStringInt(className.replace('.', '$'), string);
        string = this.replaceStringInt(className.replace('.', '-'), string);
        return string;
    }

    private String replaceStringInt(String className, String string) {
        String suffix;
        String prefix;
        int p;
        int t = className.lastIndexOf(46);
        if (t > 0) {
            className = className.substring(t + 1);
        }
        String baseName = className + this._baseSuffix;
        String extName = "__ResinExt";
        if (!baseName.equals(className)) {
            while ((p = string.indexOf(baseName)) >= 0) {
                prefix = string.substring(0, p);
                suffix = string.substring(p + baseName.length());
                string = prefix + className + suffix;
            }
        }
        while ((p = string.indexOf(extName)) >= 0) {
            prefix = string.substring(0, p);
            suffix = string.substring(p + extName.length());
            string = prefix + suffix;
        }
        return string;
    }

    protected void renameExtSuperMethods(String className, com.caucho.bytecode.JavaClass baseClass, com.caucho.bytecode.JavaClass extClass) throws Exception {
        ArrayList<ConstantPoolEntry> entries = extClass.getConstantPool().getEntries();
        className = className.replace('.', '/');
        String baseName = className + this._baseSuffix;
        String extName = className + "__ResinExt";
        for (int i = 0; i < entries.size(); ++i) {
            String type;
            String methodName;
            MethodRefConstant methodRef;
            ConstantPoolEntry entry = entries.get(i);
            if (!(entry instanceof MethodRefConstant) || !(methodRef = (MethodRefConstant)entry).getClassName().equals(baseName) || this.findMethod(baseClass, methodName = methodRef.getName(), type = methodRef.getType()) == null || this.findMethod(extClass, methodName, type) == null) continue;
            if (methodName.equals("<init>")) {
                methodName = "__init__super";
                continue;
            }
            methodName = methodName + "__super";
            methodRef.setNameAndType(methodName, type);
        }
    }

    private void moveSuperMethods(String className, com.caucho.bytecode.JavaClass baseClass, com.caucho.bytecode.JavaClass extClass) {
        className = className.replace('.', '/');
        ArrayList<JavaMethod> methods = baseClass.getMethodList();
        ArrayList<JavaMethod> extMethods = extClass.getMethodList();
        block0: for (int i = 0; i < extMethods.size(); ++i) {
            JavaMethod extMethod = extMethods.get(i);
            String baseName = extMethod.getName();
            if (baseName.endsWith("__super")) continue;
            String superName = baseName + "__super";
            for (int j = 0; j < methods.size(); ++j) {
                JavaMethod method = methods.get(j);
                String type = method.getDescriptor();
                if (!method.getName().equals(baseName) || !method.getDescriptor().equals(extMethod.getDescriptor())) continue;
                if (baseName.equals("<init>")) {
                    baseClass.getConstantPool().addUTF8("__init__super");
                    this.mergeInitMethods(baseClass, method, extClass, extMethod);
                    continue block0;
                }
                if (baseName.equals("<clinit>")) {
                    this.concatenateMethods(baseClass, method, extClass, extMethod);
                    continue block0;
                }
                baseClass.getConstantPool().addUTF8(superName);
                method.setName(superName);
                baseClass.getConstantPool().addUTF8(type);
                method.setDescriptor(type);
                int flags = method.getAccessFlags();
                flags = flags & 0xFFFFFFFE & 0xFFFFFFFB | 2;
                method.setAccessFlags(flags);
                continue block0;
            }
        }
    }

    private void concatenateMethods(com.caucho.bytecode.JavaClass baseClass, JavaMethod baseMethod, com.caucho.bytecode.JavaClass extClass, JavaMethod extMethod) {
        extMethod = extMethod.export(extClass, baseClass);
        baseMethod.concatenate(extMethod);
    }

    private void mergeInitMethods(com.caucho.bytecode.JavaClass baseClass, JavaMethod baseMethod, com.caucho.bytecode.JavaClass extClass, JavaMethod extMethod) {
        extMethod = extMethod.export(extClass, baseClass);
        baseMethod.setName("__init__super");
        baseClass.getMethodList().add(extMethod);
        try {
            InitAnalyzer initAnalyzer = new InitAnalyzer();
            CodeEnhancer baseEnhancer = new CodeEnhancer(baseClass, baseMethod.getCode());
            baseEnhancer.analyze(initAnalyzer);
            int offset = initAnalyzer.getOffset();
            byte[] code = new byte[offset];
            byte[] oldCode = baseEnhancer.getCode();
            System.arraycopy(oldCode, 0, code, 0, offset);
            baseEnhancer.remove(0, offset);
            baseEnhancer.update();
            CodeEnhancer extEnhancer = new CodeEnhancer(baseClass, extMethod.getCode());
            extEnhancer.add(0, code, 0, code.length);
            ExtInitAnalyzer extInitAnalyzer = new ExtInitAnalyzer(offset);
            extEnhancer.analyze(extInitAnalyzer);
            extEnhancer.update();
            CodeAttribute baseCode = baseMethod.getCode();
            CodeAttribute extCode = extMethod.getCode();
            if (extCode.getMaxStack() < baseCode.getMaxStack()) {
                extCode.setMaxStack(baseCode.getMaxStack());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addExtFields(com.caucho.bytecode.JavaClass baseClass, com.caucho.bytecode.JavaClass extClass) {
        ArrayList<JavaField> fields = baseClass.getFieldList();
        ArrayList<JavaField> extFields = extClass.getFieldList();
        for (int i = 0; i < extFields.size(); ++i) {
            JavaField extField = extFields.get(i);
            JavaField field = extField.export(extClass, baseClass);
            if (fields.contains(field)) continue;
            fields.add(field);
        }
    }

    private void addExtInterfaces(com.caucho.bytecode.JavaClass baseClass, com.caucho.bytecode.JavaClass extClass) {
        ArrayList<String> interfaces = extClass.getInterfaces();
        for (int i = 0; i < interfaces.size(); ++i) {
            String cl = interfaces.get(i);
            baseClass.getConstantPool().addClass(cl);
            baseClass.addInterface(cl);
        }
    }

    private void addExtMethods(com.caucho.bytecode.JavaClass baseClass, com.caucho.bytecode.JavaClass extClass) {
        ArrayList<JavaMethod> methods = baseClass.getMethodList();
        ArrayList<JavaMethod> extMethods = extClass.getMethodList();
        for (int i = 0; i < extMethods.size(); ++i) {
            JavaMethod extMethod = extMethods.get(i);
            if (extMethod.getName().equals("<clinit>") && this.findMethod(baseClass, "<clinit>", extMethod.getDescriptor()) != null || extMethod.getName().equals("<init>") || extMethod.getName().endsWith("__super")) continue;
            log.finest("adding extension method: " + extClass.getThisClass() + ":" + extMethod.getName());
            JavaMethod method = extMethod.export(extClass, baseClass);
            methods.add(method);
        }
    }

    private void addExtClasses(com.caucho.bytecode.JavaClass baseClass, com.caucho.bytecode.JavaClass extClass) {
    }

    private JavaMethod findMethod(com.caucho.bytecode.JavaClass cl, String name, String descriptor) {
        ArrayList<JavaMethod> methods = cl.getMethodList();
        for (int j = 0; j < methods.size(); ++j) {
            JavaMethod method = methods.get(j);
            if (!method.getName().equals(name) || !method.getDescriptor().equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    private void moveSuperFields(com.caucho.bytecode.JavaClass baseClass, com.caucho.bytecode.JavaClass extClass) {
        ArrayList<JavaField> fields = baseClass.getFieldList();
        ArrayList<JavaField> extFields = extClass.getFieldList();
        for (int i = 0; i < extFields.size(); ++i) {
        }
    }

    protected void fixup(String className, String extClassName) throws CompileClassNotFound {
        String classSuffix;
        Path targetDir;
        Path preTargetDir;
        Path prePath = this.getPreWorkPath();
        Path postPath = this.getPostWorkPath();
        Path source = this.getSource(className);
        if (source == null || !source.canRead()) {
            return;
        }
        Path ext = prePath.lookup(extClassName.replace('.', '/') + ".class");
        Path target = postPath.lookup(className.replace('.', '/') + ".class");
        try {
            target.getParent().mkdirs();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (source != null) {
                this.mergeClasses(className, target, source, ext);
            } else {
                this.mergeClasses(className, target, ext);
            }
        }
        catch (Exception e) {
            throw new CompileClassNotFound(e);
        }
        int p = className.lastIndexOf(46);
        if (p > 0) {
            String prefix = className.substring(0, p).replace('.', '/');
            preTargetDir = prePath.lookup(prefix);
            targetDir = postPath.lookup(prefix);
            classSuffix = className.substring(p + 1);
        } else {
            preTargetDir = prePath;
            targetDir = postPath;
            classSuffix = className;
        }
        p = extClassName.lastIndexOf(46);
        String extSuffix = p > 0 ? extClassName.substring(p + 1) : extClassName;
        try {
            String[] list = preTargetDir.list();
            for (int i = 0; i < list.length; ++i) {
                Path extPath;
                Path subTarget;
                String targetClass;
                String name = list[i];
                if (name.startsWith(extSuffix + '$') && name.endsWith(".class")) {
                    p = name.indexOf(36);
                    targetClass = classSuffix + '$' + name.substring(p + 1, name.length() - 6);
                    subTarget = targetDir.lookup(targetClass + ".class");
                    extPath = preTargetDir.lookup(name);
                    this.renameSubClass(classSuffix, subTarget, extPath);
                    continue;
                }
                if (!name.startsWith(extSuffix + '-') || !name.endsWith(".class")) continue;
                p = name.indexOf(45);
                targetClass = classSuffix + '-' + name.substring(p + 1, name.length() - 6);
                subTarget = targetDir.lookup(targetClass + ".class");
                extPath = preTargetDir.lookup(name);
                this.renameSubClass(classSuffix, subTarget, extPath);
            }
        }
        catch (Exception e) {
            throw new CompileClassNotFound(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeClasses(String className, Path targetPath, Path sourcePath, Path extPath) throws Exception {
        com.caucho.bytecode.JavaClass baseClass = null;
        com.caucho.bytecode.JavaClass extClass = null;
        ByteCodeParser parser = new ByteCodeParser();
        ReadStream is = sourcePath.openRead();
        try {
            baseClass = parser.parse(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        parser = new ByteCodeParser();
        is = extPath.openRead();
        try {
            extClass = parser.parse(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.mergeClasses(className, baseClass, extClass);
        this.postEnhance(baseClass);
        WriteStream os = targetPath.openWrite();
        try {
            baseClass.write(os);
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeClasses(String className, Path targetPath, Path extPath) throws Exception {
        com.caucho.bytecode.JavaClass baseClass = null;
        com.caucho.bytecode.JavaClass extClass = null;
        ByteCodeParser parser = new ByteCodeParser();
        ReadStream is = extPath.openRead();
        try {
            extClass = parser.parse(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.cleanExtConstantPool(className, extClass);
        this.postEnhance(baseClass);
        WriteStream os = targetPath.openWrite();
        try {
            extClass.write(os);
        }
        finally {
            os.close();
        }
    }

    protected void postEnhance(com.caucho.bytecode.JavaClass baseClass) throws Exception {
        for (int i = 0; i < this._enhancers.size(); ++i) {
            this._enhancers.get(i).postEnhance(baseClass);
        }
    }

    protected void mergeClasses(String className, com.caucho.bytecode.JavaClass baseClass, com.caucho.bytecode.JavaClass extClass) throws Exception {
        if (baseClass.getMajor() < extClass.getMajor()) {
            baseClass.setMajor(extClass.getMajor());
            baseClass.setMinor(extClass.getMinor());
        }
        this.cleanExtConstantPool(className, extClass);
        this.renameExtSuperMethods(className, baseClass, extClass);
        this.cleanExtConstantPool(className, baseClass);
        this.addExtInterfaces(baseClass, extClass);
        this.addExtFields(baseClass, extClass);
        this.moveSuperMethods(className, baseClass, extClass);
        this.addExtMethods(baseClass, extClass);
        this.addExtClasses(baseClass, extClass);
    }

    public void destroy() {
        super.destroy();
        this.getRawLoader().destroy();
    }

    public String toString() {
        if (this.getId() != null) {
            return "EnhancingClassLoader[" + this.getId() + "]";
        }
        return "EnhancingClassLoader" + this.getLoaders();
    }

    private static class ExtInitAnalyzer
    extends Analyzer {
        int _startOffset;
        boolean _isEnhanced;

        ExtInitAnalyzer(int length) {
            this._startOffset = length;
        }

        public void analyze(CodeVisitor visitor) throws Exception {
            if (this._isEnhanced) {
                return;
            }
            if (visitor.getOffset() < this._startOffset) {
                return;
            }
            switch (visitor.getOpcode()) {
                case 183: {
                    int index = visitor.getShortArg();
                    ConstantPool cp = visitor.getJavaClass().getConstantPool();
                    MethodRefConstant ref = cp.getMethodRef(index);
                    if (!ref.getName().equals("<init>")) {
                        return;
                    }
                    MethodRefConstant newRef = cp.addMethodRef(ref.getClassName(), "__init__super", ref.getType());
                    visitor.setShortArg(1, newRef.getIndex());
                    this._isEnhanced = true;
                }
            }
        }
    }

    private static class InitAnalyzer
    extends Analyzer {
        int _offset = -1;

        private InitAnalyzer() {
        }

        public int getOffset() {
            return this._offset;
        }

        public void analyze(CodeVisitor visitor) throws Exception {
            if (this._offset >= 0) {
                return;
            }
            switch (visitor.getOpcode()) {
                case 183: {
                    com.caucho.bytecode.JavaClass javaClass = visitor.getJavaClass();
                    ConstantPool cp = javaClass.getConstantPool();
                    MethodRefConstant ref = cp.getMethodRef(visitor.getShortArg());
                    if (!ref.getName().equals("<init>") || !ref.getClassName().equals(javaClass.getThisClass()) && !ref.getClassName().equals(javaClass.getSuperClass())) break;
                    this._offset = visitor.getOffset() + 3;
                }
            }
        }
    }
}

