/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Logger;

public class FastPrintWriter
extends PrintWriter {
    public static final Logger log = Logger.getLogger(ClassLiteral.getClass((String)"com/caucho/portal/generic/FastPrintWriter").getName());
    static final Writer _dummy = new PipedWriter();
    private static final char[] _newline = "\n".toCharArray();
    protected Writer _out;
    private boolean _error;
    private Exception _errorCause;

    public FastPrintWriter() {
        super(_dummy);
    }

    public FastPrintWriter(Writer out) throws IOException {
        super(_dummy);
        this.open(out);
    }

    public void open(Writer out) throws IOException {
        if (this._out != null) {
            throw new IOException("already open");
        }
        if (out == null) {
            throw new NullPointerException();
        }
        this._out = out;
    }

    protected void setError() {
        if (!this._error) {
            this._error = true;
            this._errorCause = new IOException("stream failed (no exception)");
        }
    }

    protected void setError(Exception errorCause) {
        if (!this._error) {
            this._error = true;
            this._errorCause = errorCause;
        }
    }

    public boolean checkError() {
        return this._error;
    }

    public Exception getErrorCause() {
        return this._errorCause;
    }

    public void clearError() {
        this._error = false;
        this._errorCause = null;
    }

    public void flush() {
        if (this.checkError()) {
            return;
        }
        try {
            this._out.flush();
        }
        catch (Exception ex) {
            this.setError(ex);
        }
    }

    public void writeOut(char[] buf, int off, int len) throws IOException {
        this._out.write(buf, off, len);
    }

    public void writeOut(String str, int off, int len) throws IOException {
        this._out.write(str, off, len);
    }

    public void writeOut(char c) throws IOException {
        this._out.write(c);
    }

    public void close() {
        Writer out = this._out;
        boolean error = this._error;
        this.flush();
        this._out = null;
        this._error = false;
        this._errorCause = null;
        if (!this._error) {
            try {
                out.close();
            }
            catch (IOException ex) {
                this.setError(ex);
            }
        }
    }

    public void write(char[] buf, int off, int len) {
        if (this.checkError()) {
            return;
        }
        try {
            this.writeOut(buf, off, len);
        }
        catch (Exception ex) {
            this.setError(ex);
        }
    }

    public void write(String str, int off, int len) {
        if (this.checkError()) {
            return;
        }
        try {
            this.writeOut(str, off, len);
        }
        catch (Exception ex) {
            this.setError(ex);
        }
    }

    public void write(int c) {
        if (this.checkError()) {
            return;
        }
        try {
            this.writeOut((char)c);
        }
        catch (Exception ex) {
            this.setError(ex);
        }
    }

    public void write(char[] cbuf) {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(String str) {
        this.write(str, 0, str.length());
    }

    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(s);
    }

    public void print(String s) {
        this.write(s == null ? "null" : s);
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println() {
        this.write(_newline, 0, _newline.length);
    }

    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(char[] c) {
        this.print(c);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void println(Object o) {
        this.print(o);
        this.println();
    }
}

