/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.PortletPreference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPortletPreferences
implements PortletPreferences {
    Map<String, PortletPreference> _preferenceMap;
    ArrayList<PreferencesValidator> _preferencesValidators;

    public void addPreference(PortletPreference preference) {
        if (this._preferenceMap == null) {
            this._preferenceMap = new LinkedHashMap<String, PortletPreference>();
        }
        this._preferenceMap.put(preference.getName(), preference);
    }

    public void addPreferencesValidator(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(className, false, loader);
            PreferencesValidator validator = (PreferencesValidator)cl.newInstance();
            if (this._preferencesValidators == null) {
                this._preferencesValidators = new ArrayList();
            }
            this._preferencesValidators.add(validator);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public ArrayList<PreferencesValidator> getPreferencesValidators() {
        return this._preferencesValidators;
    }

    public boolean isReadOnly(String key) {
        if (this._preferenceMap == null) {
            return false;
        }
        PortletPreference preference = this._preferenceMap.get(key);
        if (preference == null) {
            return false;
        }
        return preference.isReadOnly();
    }

    public String getValue(String key, String def) {
        if (this._preferenceMap == null) {
            return def;
        }
        PortletPreference preference = this._preferenceMap.get(key);
        if (preference == null) {
            return def;
        }
        return preference.getValue();
    }

    public String[] getValues(String key, String[] def) {
        if (this._preferenceMap == null) {
            return def;
        }
        PortletPreference preference = this._preferenceMap.get(key);
        if (preference == null) {
            return def;
        }
        return preference.getValues();
    }

    public Enumeration getNames() {
        if (this._preferenceMap == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._preferenceMap.keySet());
    }

    public Map getMap() {
        return this._preferenceMap;
    }

    public void reset(String key) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public void store() throws IOException, ValidatorException {
        throw new UnsupportedOperationException();
    }
}

