/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic.context;

import com.caucho.portal.generic.Action;
import com.caucho.portal.generic.BufferFactory;
import com.caucho.portal.generic.Cache;
import com.caucho.portal.generic.CacheKey;
import com.caucho.portal.generic.Constraint;
import com.caucho.portal.generic.ConstraintFailureEvent;
import com.caucho.portal.generic.ExceptionEvent;
import com.caucho.portal.generic.Invocation;
import com.caucho.portal.generic.InvocationFactory;
import com.caucho.portal.generic.InvocationURL;
import com.caucho.portal.generic.Portal;
import com.caucho.portal.generic.PortalRequest;
import com.caucho.portal.generic.PortalResponse;
import com.caucho.portal.generic.PortalURL;
import com.caucho.portal.generic.PortletConnection;
import com.caucho.portal.generic.PreferencesStore;
import com.caucho.portal.generic.Render;
import com.caucho.portal.generic.Renderer;
import com.caucho.portal.generic.UserAttributeStore;
import com.caucho.portal.generic.Window;
import com.caucho.portal.generic.context.ActionImpl;
import com.caucho.portal.generic.context.ActionRequestImpl;
import com.caucho.portal.generic.context.ActionResponseImpl;
import com.caucho.portal.generic.context.BufferedResponseHandler;
import com.caucho.portal.generic.context.CachingResponseHandler;
import com.caucho.portal.generic.context.LinkingPortletPreferences;
import com.caucho.portal.generic.context.PortalRequestImpl;
import com.caucho.portal.generic.context.PortalResponseImpl;
import com.caucho.portal.generic.context.PortletRequestImpl;
import com.caucho.portal.generic.context.PortletResponseImpl;
import com.caucho.portal.generic.context.RenderImpl;
import com.caucho.portal.generic.context.RenderRequestImpl;
import com.caucho.portal.generic.context.RenderResponseImpl;
import com.caucho.portal.generic.context.RendererResponseHandler;
import com.caucho.portal.generic.context.ResponseHandler;
import com.caucho.portal.generic.context.TopLevelResponseHandler;
import com.caucho.portal.generic.context.WindowContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletSession;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionContext {
    private static final Logger log = PortletConnection.log;
    private static final String EXPIRATION_CACHE = "javax.portlet.expirationCache";
    private static final String RENDER_REQUEST = "javax.portlet.renderRequest";
    private static final String RENDER_RESPONSE = "javax.portlet.renderResponse";
    private static final String PORTLET_CONFIG = "javax.portlet.portletConfig";
    private static final Locale LOCALE_ANY = new Locale("", "", "");
    ActionImpl _action = new ActionImpl(this);
    RenderImpl _render = new RenderImpl(this);
    PortalRequestImpl _portalRequest = new PortalRequestImpl(this);
    PortalResponseImpl _portalResponse = new PortalResponseImpl(this);
    PortletRequestImpl _portletRequest = new PortletRequestImpl(this);
    PortletResponseImpl _portletResponse = new PortletResponseImpl(this);
    ActionRequestImpl _actionRequest = new ActionRequestImpl(this);
    ActionResponseImpl _actionResponse = new ActionResponseImpl(this);
    RenderRequestImpl _renderRequest = new RenderRequestImpl(this);
    RenderResponseImpl _renderResponse = new RenderResponseImpl(this);
    static final int STAGE_START = 1;
    static final int STAGE_ACTION = 2;
    static final int STAGE_DONEACTION = 3;
    static final int STAGE_RENDER = 4;
    static final int STAGE_DONE = 5;
    private PortletConnection _connection;
    private InvocationFactory _invocationFactory;
    private TopLevelResponseHandler _topLevelResponseHandler;
    int _connectionExpirationCache = -1;
    boolean _connectionIsPrivate = false;
    private boolean _forbidRedirect;
    private PreferencesStore _preferencesStore;
    private UserAttributeStore _userAttributeStore;
    private int _stage = 1;
    private Map<String, WindowContext> _windowContextMap = new HashMap<String, WindowContext>();
    private ArrayList<WindowContext> _windowContextStack = new ArrayList();
    private WindowContext _windowContext;

    public ConnectionContext(PortletConnection connection) {
        this._connection = connection;
        this._topLevelResponseHandler = new TopLevelResponseHandler(connection, this);
    }

    public void start(InvocationFactory invocationFactory) {
        this.log(Level.FINER, "starting connection");
        if (this._stage != 1 || this._invocationFactory != null) {
            throw new IllegalStateException(new StringBuffer().append("missing finish()? ").append(this._stage).toString());
        }
        this._invocationFactory = invocationFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.log(Level.FINEST, "finishing connection");
        try {
            for (int i = this._windowContextStack.size() - 1; i >= 0; --i) {
                try {
                    WindowContext windowContext = this._windowContextStack.get(i);
                    if (windowContext == null) continue;
                    this.finishWindowContext(windowContext);
                    continue;
                }
                catch (IOException ex) {
                    this.log(Level.WARNING, ex.toString(), ex);
                }
            }
        }
        finally {
            this._windowContextStack.clear();
        }
        this._windowContextMap.clear();
        this._windowContext = null;
        this._stage = 1;
        this._forbidRedirect = false;
        this._preferencesStore = null;
        this._userAttributeStore = null;
        this._connection = null;
        this._invocationFactory = null;
    }

    private void finishWindowContext(WindowContext windowContext) throws IOException {
        Map<String, String> userAttributeMap = windowContext.getUserAttributeMap();
        LinkingPortletPreferences pref = windowContext.getPreferences();
        windowContext.finish();
        if (pref != null) {
            Map<String, String[]> store = pref.getStore();
            pref.finish();
            this.getPreferencesStore().finish(store);
        }
        if (userAttributeMap != null) {
            this.getUserAttributeStore().finish(userAttributeMap);
        }
    }

    protected void log(Level level, String message) {
        if (!log.isLoggable(level)) {
            return;
        }
        String namespace = this._windowContext == null ? null : this._windowContext.getNamespace();
        this.log(namespace, level, message, null);
    }

    protected void log(Level level, String message, Exception ex) {
        if (!log.isLoggable(level)) {
            return;
        }
        String namespace = this._windowContext == null ? null : this._windowContext.getNamespace();
        this.log(namespace, level, message, ex);
    }

    protected void log(String namespace, Level level, String message) {
        if (!log.isLoggable(level)) {
            return;
        }
        this.log(namespace, level, message, null);
    }

    protected void log(String namespace, Level level, String message, Exception ex) {
        if (log.isLoggable(level)) {
            StringBuffer sb = new StringBuffer(256);
            sb.append('[');
            sb.append(this._connection.getId());
            if (namespace != null) {
                sb.append(' ');
                sb.append(namespace);
            }
            sb.append(']');
            if (this._stage == 2) {
                sb.append('a');
            } else if (this._stage == 4) {
                sb.append('r');
            } else {
                sb.append(' ');
            }
            sb.append(' ');
            sb.append(message);
            if (ex == null) {
                log.log(level, sb.toString());
            } else {
                log.log(level, sb.toString(), ex);
            }
        }
    }

    protected PortletConnection getConnection() {
        return this._connection;
    }

    protected InvocationFactory getInvocationFactory() {
        return this._invocationFactory;
    }

    protected void setConnectionFailed(Exception ex) {
        this._connection.setConnectionFailed(ex);
    }

    protected void setConnectionFailed() {
        this._connection.setConnectionFailed();
    }

    protected boolean isConnectionFailed() {
        return this._connection.isConnectionFailed();
    }

    public int getConnectionExpirationCache() {
        return this._connectionExpirationCache;
    }

    protected void updateConnectionExpirationCache(int expirationCache) {
        if (this._connectionExpirationCache != 0 && expirationCache >= 0 && this._connectionExpirationCache < expirationCache) {
            this._connectionExpirationCache = expirationCache;
        }
    }

    public boolean isConnectionPrivate() {
        return this._connectionIsPrivate;
    }

    protected void setConnectionPrivate() {
        this._connectionIsPrivate = true;
    }

    protected void setForbidRedirect() {
        this._forbidRedirect = true;
    }

    protected boolean isForbidRedirect() {
        return this._forbidRedirect;
    }

    public PortalRequest getPortalRequest() {
        return this._portalRequest;
    }

    public PortalResponse getPortalResponse() {
        return this._portalResponse;
    }

    public Portal getPortal() {
        return this._connection.getPortal();
    }

    public PortalContext getPortalContext() {
        return this._connection.getPortal().getPortalContext();
    }

    protected PreferencesStore getPreferencesStore() {
        if (this._preferencesStore == null) {
            this._preferencesStore = this.getPortal().getPreferencesStore();
        }
        return this._preferencesStore;
    }

    protected UserAttributeStore getUserAttributeStore() {
        if (this._userAttributeStore == null) {
            this._userAttributeStore = this.getPortal().getUserAttributeStore();
        }
        return this._userAttributeStore;
    }

    private void pushStack(WindowContext windowContext) {
        this._windowContextStack.add(this._windowContext);
        this._windowContext = windowContext;
    }

    private void popStack() {
        try {
            if (this._windowContextStack.size() == 0) {
                throw new IllegalStateException("top of window stack reached, extra finish()?");
            }
            WindowContext windowContext = this._windowContext;
            this._windowContext = null;
            if (this._stage == 4) {
                this.finishWindowContext(windowContext);
            }
            this._windowContext = this._windowContextStack.remove(this._windowContextStack.size() - 1);
        }
        catch (Exception ex) {
            this.setConnectionFailed(ex);
        }
    }

    protected void handleException() throws PortletException, IOException {
        final Exception exception = this._windowContext.getException();
        if (exception == null) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            this.log(Level.FINER, new StringBuffer().append("handling exception: ").append(exception.getClass().getName()).toString());
        }
        final WindowContext windowContext = this._windowContext;
        ExceptionEvent event = new ExceptionEvent(){

            public Exception getException() {
                return exception;
            }

            public void setHandled(boolean hideWindow) {
                windowContext.setException(null);
                if (hideWindow) {
                    windowContext.setExcluded();
                }
            }

            public boolean isHandled() {
                return !windowContext.isException();
            }

            public boolean isHideWindow() {
                return windowContext.isExcluded();
            }
        };
        Window window = this.getWindow();
        window.handleException(this.getRenderRequest(), this.getRenderResponse(), event);
    }

    protected void checkConstraints() {
        int startIndex;
        ArrayList<Constraint> constraints = this.getWindow().getConstraints();
        if (constraints == null) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "checking constraints");
        }
        for (int i = startIndex = this._windowContext.getConstraintIndex(); i < constraints.size(); ++i) {
            this._windowContext.setConstraintIndex(i + 1);
            Constraint constraint = constraints.get(i);
            int result = constraint.check(this.getPortletRequest(), this.getPortletResponse());
            if (result == 0) continue;
            if (result == 61440) {
                this._windowContext.setExcluded();
                if (log.isLoggable(Level.FINER)) {
                    this.log(Level.FINE, "constraint excludes window");
                }
                return;
            }
            this._windowContext.setConstraintFailure(constraint, result);
            if (log.isLoggable(Level.FINER)) {
                this.log(Level.FINE, new StringBuffer().append("constraint failed: ").append(constraint.getClass().getName()).toString());
            }
            return;
        }
    }

    protected boolean handleConstraintFailure() throws PortletException, IOException {
        final Constraint constraint = this._windowContext.getConstraintFailureConstraint();
        if (constraint == null) {
            return true;
        }
        if (log.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, new StringBuffer().append("handling constraint failure: ").append(constraint.getClass().getName()).toString());
        }
        final WindowContext windowContext = this._windowContext;
        final int code = this._windowContext.getConstraintFailureCode();
        ConstraintFailureEvent event = new ConstraintFailureEvent(){

            public Constraint getConstraint() {
                return constraint;
            }

            public int getStatusCode() {
                return code;
            }

            public void setHandled(boolean hideWindow) {
                windowContext.setConstraintFailure(null, 0);
                if (hideWindow) {
                    windowContext.setExcluded();
                }
            }

            public boolean isHandled() {
                return !windowContext.isConstraintFailure();
            }

            public boolean isHideWindow() {
                return windowContext.isExcluded();
            }
        };
        Window window = this.getWindow();
        window.handleConstraintFailure(this.getRenderRequest(), this.getRenderResponse(), event);
        return !windowContext.isConstraintFailure();
    }

    private boolean startActionOrRender(Window window, String namespace, boolean isActionStage) throws PortletException, IOException {
        if (log.isLoggable(Level.FINEST)) {
            this.log(Level.FINER, new StringBuffer().append("portlet `").append(window.getPortletConfig().getPortletName()).append("' for namespace `").append(namespace).append("'").toString());
        }
        if (this._windowContext != null && (this._windowContext.isExcluded() || this._windowContext.getException() != null || this._windowContext.isConstraintFailure())) {
            if (log.isLoggable(Level.FINER)) {
                if (this._windowContext.isExcluded()) {
                    this.log(Level.FINER, new StringBuffer().append("child `").append(namespace).append("' excluded because parent is excluded").toString());
                } else if (this._windowContext.isException()) {
                    this.log(Level.FINER, new StringBuffer().append("child `").append(namespace).append("' excluded because parent has exception").toString());
                } else if (this._windowContext.isConstraintFailure()) {
                    this.log(Level.FINER, new StringBuffer().append("child `").append(namespace).append("' excluded because parent has constraint failure").toString());
                }
            }
            return false;
        }
        boolean fail = true;
        try {
            WindowContext windowContext;
            boolean isTopLevel = this._windowContextStack.size() == 0;
            WindowContext windowContext2 = windowContext = namespace == null ? null : this._windowContextMap.get(namespace);
            if (windowContext != null) {
                if (isActionStage) {
                    throw new PortletException(new StringBuffer().append("duplicate namespace `").append(namespace).append("'").toString());
                }
                if (windowContext.getWindow() != window) {
                    throw new PortletException(new StringBuffer().append("cannot have different Window  in render stage for namespace `").append(namespace).append("'").toString());
                }
                if (windowContext.isExcluded()) {
                    if (log.isLoggable(Level.FINER) && this._windowContext.isExcluded()) {
                        this.log(Level.FINER, new StringBuffer().append("child `").append(namespace).append("' excluded in previous stage").toString());
                    }
                    fail = false;
                    boolean bl = false;
                    return bl;
                }
            } else {
                windowContext = new WindowContext();
                windowContext.start(window, namespace);
                if (windowContext.getNamespace() != null) {
                    this._windowContextMap.put(windowContext.getNamespace(), windowContext);
                    Invocation invocation = this.getInvocationFactory().getInvocation(namespace);
                    windowContext.setInvocation(invocation);
                    if (invocation.isActionTarget()) {
                        this.log(Level.FINER, "action target");
                        Map<String, String[]> actionMap = invocation.releaseParameterMap();
                        windowContext.setActionMap(actionMap);
                    }
                }
            }
            this.pushStack(windowContext);
            if (this._windowContext.getNamespace() == null && log.isLoggable(Level.FINER)) {
                this.log(Level.FINER, "no invocation for null namespace");
            }
            if (isActionStage) {
                this.checkConstraints();
                if (this._windowContext.isConstraintFailure() || this._windowContext.isExcluded()) {
                    this.popStack();
                    fail = false;
                    boolean bl = false;
                    return bl;
                }
            }
            fail = false;
        }
        catch (PortletException ex) {
            this.setConnectionFailed((Exception)((Object)ex));
            throw ex;
        }
        catch (RuntimeException ex) {
            this.setConnectionFailed(ex);
            throw new PortletException((Throwable)ex);
        }
        finally {
            if (fail) {
                this.setConnectionFailed();
                return false;
            }
        }
        return true;
    }

    public PortletRequest getPortletRequest() {
        return this._portletRequest;
    }

    public PortletResponse getPortletResponse() {
        return this._portletResponse;
    }

    public Action getAction(Window window, String namespace) throws PortletException, IOException {
        if (this.isConnectionFailed()) {
            return null;
        }
        if (this._stage == 1) {
            if (log.isLoggable(Level.FINER)) {
                this.log(Level.FINER, "starting action stage");
            }
            this._stage = 2;
        } else if (this._stage != 2) {
            IllegalStateException ex = new IllegalStateException(new StringBuffer().append("missing finish()? ").append(this._stage).toString());
            this.setConnectionFailed(ex);
            throw ex;
        }
        if (!this.startActionOrRender(window, namespace, true)) {
            return null;
        }
        return this.getCurrentAction();
    }

    public Action getCurrentAction() {
        return this._stage == 2 ? this._action : null;
    }

    public boolean isTarget() {
        return this._stage == 2 && this._windowContext.getActionMap() != null && !this._windowContext.isExcluded();
    }

    public ActionRequest getActionRequest() {
        if (this._stage != 2 || this._windowContext.isExcluded()) {
            return null;
        }
        return this._actionRequest;
    }

    public ActionResponse getActionResponse() {
        if (this._stage != 2 || this._windowContext.isExcluded()) {
            return null;
        }
        return this._actionResponse;
    }

    public void processAction(Portlet portlet) {
        if (this._stage != 2) {
            throw new IllegalStateException("not in action stage");
        }
        if (log.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "processAction()");
        }
        try {
            portlet.processAction((ActionRequest)this._actionRequest, (ActionResponse)this._actionResponse);
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINE)) {
                this.log(Level.FINE, ex.toString(), ex);
            }
            this._windowContext.setException(ex);
        }
    }

    void finishAction() throws IOException, PortletException {
        boolean fail = true;
        try {
            if (this._windowContext == null) {
                throw new IllegalStateException("cannot finish action, at top of stack");
            }
            if (this._stage != 2 && this._stage != 3) {
                throw new IllegalStateException(new StringBuffer().append("cannot finish action for ").append(this._windowContext.getNamespace()).append(", stage is ").append(this._stage).toString());
            }
            this.popStack();
            if (this._windowContext == null) {
                this._stage = 3;
                if (log.isLoggable(Level.FINER)) {
                    this.log(Level.FINER, "finishing action stage");
                }
            }
            fail = false;
        }
        catch (RuntimeException ex) {
            this.setConnectionFailed(ex);
            throw ex;
        }
        finally {
            if (fail) {
                this.setConnectionFailed();
            }
        }
    }

    private CacheKey getCacheKey() {
        CacheKey cacheKey = null;
        if (cacheKey == null) {
            cacheKey = new CacheKey();
        } else {
            cacheKey.reset();
        }
        WindowContext windowContext = this._windowContext;
        if (windowContext.getNamespace() == null) {
            return null;
        }
        cacheKey.setNamespace(windowContext.getNamespace());
        cacheKey.setPortletMode(this.getPortletMode());
        cacheKey.setWindowState(this.getWindowState());
        cacheKey.setContentType(this.getResponseContentType());
        cacheKey.setLocale(this.getResponseLocale());
        cacheKey.setPrivate(windowContext.isPrivate());
        cacheKey.setRequestedSessionId(this._connection.getRequestedSessionId());
        return null;
    }

    private Map<String, String> resetWindowRequestAttributes() {
        Map<String, String> attr = null;
        attr = this.getAttribute(attr, "javax.portlet.title", true);
        attr = this.getAttribute(attr, "javax.portlet.short-title", true);
        attr = this.getAttribute(attr, "javax.portlet.keywords", true);
        attr = this.getAttribute(attr, "javax.portlet.description", true);
        return attr;
    }

    private Map<String, String> getWindowRequestAttributes() {
        Map<String, String> attr = null;
        attr = this.getAttribute(attr, "javax.portlet.title", false);
        this.getAttribute(attr, "javax.portlet.short-title", false);
        this.getAttribute(attr, "javax.portlet.keywords", false);
        this.getAttribute(attr, "javax.portlet.description", false);
        return attr;
    }

    private Map<String, String> getAttribute(Map<String, String> map, String name, boolean isReset) {
        String value = (String)this._connection.getAttribute(name);
        if (isReset || value != null) {
            if (map == null) {
                map = new LinkedHashMap<String, String>();
            }
            map.put(name, value);
            if (isReset) {
                this._connection.removeAttribute(name);
            }
        }
        return map;
    }

    private void restoreWindowRequestAttributes(Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            Iterator<Map.Entry<String, String>> iter = map.entrySet().iterator();
            do {
                Map.Entry<String, String> entry = iter.next();
                this._connection.setAttribute(entry.getKey(), entry.getValue());
            } while (iter.hasNext());
        }
    }

    public Render getRender(Window window, String namespace) throws PortletException, IOException {
        BufferFactory bufferFactory;
        int bufferSize;
        ResponseHandler parentResponseHandler;
        if (this.isConnectionFailed()) {
            return null;
        }
        if (this._stage == 1 || this._stage == 3) {
            if (log.isLoggable(Level.FINER)) {
                this.log(Level.FINER, "starting render stage");
            }
            this._stage = 4;
            this._connection.setAttribute(RENDER_REQUEST, this._renderRequest);
            this._connection.setAttribute(RENDER_RESPONSE, this._renderResponse);
        } else if (this._stage != 4) {
            IllegalStateException ex = new IllegalStateException(new StringBuffer().append("missing finish()? ").append(this._stage).toString());
            this.setConnectionFailed(ex);
            throw ex;
        }
        this.checkAlwaysWriteOrStream();
        ResponseHandler responseHandler = parentResponseHandler = this._windowContext == null ? this._topLevelResponseHandler : this._windowContext.getResponseHandler();
        if (!this.startActionOrRender(window, namespace, false)) {
            return null;
        }
        LinkingPortletPreferences pref = this._windowContext.getPreferences();
        if (pref != null) {
            pref.discard();
        }
        this._windowContext.setParentResponseHandler(parentResponseHandler);
        ResponseHandler responseHandler2 = parentResponseHandler;
        Renderer renderer = this._windowContext.getWindow().getRenderer();
        if (renderer != null) {
            BufferFactory bufferFactory2 = this.getPortal().getBufferFactory();
            int rendererBufferSize = renderer.getBufferSize();
            if (bufferFactory2 != null && rendererBufferSize != 0) {
                responseHandler2 = new BufferedResponseHandler(responseHandler2, bufferFactory2, rendererBufferSize);
            }
            responseHandler2 = new RendererResponseHandler(this, responseHandler2, renderer, this.getRenderRequest(), this.getRenderResponse(), namespace);
        }
        if ((bufferSize = this._windowContext.getWindow().getBufferSize()) != 0 && (bufferFactory = this.getPortal().getBufferFactory()) != null) {
            responseHandler2 = new BufferedResponseHandler(responseHandler2, bufferFactory, bufferSize);
        }
        this._windowContext.setResponseHandler(responseHandler2);
        boolean isPrivate = this._windowContext.getWindow().isPrivate();
        if (isPrivate) {
            this._windowContext.setPrivate();
            this.setConnectionPrivate();
        }
        this._connection.setAttribute(PORTLET_CONFIG, this.getWindow().getPortletConfig());
        Map<String, String> requestAttributes = this.resetWindowRequestAttributes();
        this._windowContext.setWindowRequestAttributes(requestAttributes);
        if (this._windowContext.isException()) {
            if (log.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "previous exception");
            }
            this.finishRender();
            return null;
        }
        if (!this._windowContext.isConstraintFailure()) {
            this.checkConstraints();
        }
        if (this._windowContext.isConstraintFailure()) {
            if (!this.handleConstraintFailure()) {
                if (log.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, "constraint failure unhandled, propagating to parent");
                }
            } else if (log.isLoggable(Level.FINER)) {
                if (this._windowContext.isExcluded()) {
                    this.log(Level.FINER, "constraint failure handled, excluding");
                } else {
                    this.log(Level.FINER, "constraint failure handled by window");
                }
            }
            this.finishRender();
            return null;
        }
        int expirationCache = this._windowContext.getExpirationCache();
        if (!(expirationCache == 0 || isPrivate && this.getRequestedSessionId() == null)) {
            this._windowContext.setExpirationCache(expirationCache);
        }
        Cache cache = this.getPortal().getCache();
        CacheKey cacheKey = null;
        if (cache != null) {
            cacheKey = this.getCacheKey();
        }
        if (cacheKey != null) {
            int result = cache.respondFromCache(cacheKey, this.getRenderRequest(), this.getRenderResponse());
            if (result != 0) {
                this.updateConnectionExpirationCache(result);
                return null;
            }
            CachingResponseHandler cacheResponseHandler = new CachingResponseHandler(this._windowContext.getResponseHandler(), cache, this._windowContext.getNamespace(), this._windowContext.getExpirationCache(), this._windowContext.isPrivate());
            this._windowContext.setResponseHandler(cacheResponseHandler);
        }
        return this.getCurrentRender();
    }

    public RenderRequest getRenderRequest() {
        if (this._stage != 4 || this._windowContext.isExcluded()) {
            return null;
        }
        return this._renderRequest;
    }

    public RenderResponse getRenderResponse() {
        if (this._stage != 4 || this._windowContext.isExcluded()) {
            return null;
        }
        return this._renderResponse;
    }

    public void render(Portlet portlet) throws PortletException, IOException {
        if (this._stage != 4) {
            throw new IllegalStateException("not in render stage");
        }
        if (log.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "render()");
        }
        if (this._windowContext.getException() == null && !this._windowContext.isExcluded() && !this._windowContext.isConstraintFailure()) {
            try {
                portlet.render(this.getRenderRequest(), this.getRenderResponse());
            }
            catch (Exception ex) {
                if (log.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, ex.toString(), ex);
                }
                this._windowContext.setException(ex);
            }
        }
    }

    public Render getCurrentRender() {
        return this._stage == 4 ? this._render : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishRender() throws IOException, PortletException {
        boolean fail = true;
        try {
            boolean handled;
            int constraintFailureCode;
            Constraint constraintFailureConstraint;
            boolean isConstraintFailure;
            boolean isException;
            Throwable exception;
            Map<String, String> requestAttributes;
            block55: {
                boolean killResponse;
                if (this._windowContext == null) {
                    throw new IllegalStateException("cannot finish render, at top of stack");
                }
                requestAttributes = this._windowContext.getWindowRequestAttributes();
                if (this._stage != 4 && this._stage != 5) {
                    throw new IllegalStateException(new StringBuffer().append("cannot finish render for ").append(this._windowContext.getNamespace()).append(", stage is ").append(this._stage).toString());
                }
                if (this._windowContext.isException()) {
                    try {
                        this.reset(false);
                        this.handleException();
                        if (log.isLoggable(Level.FINE)) {
                            if (this._windowContext.isException()) {
                                this.log(Level.FINE, "exception unhandled, propagating to parent");
                            } else if (this._windowContext.isExcluded()) {
                                this.log(Level.FINER, "exception handled, excluding");
                            } else {
                                this.log(Level.FINER, "exception handled by window");
                            }
                        }
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, ex.toString(), ex);
                    }
                }
                isException = (exception = this._windowContext.getException()) != null;
                isConstraintFailure = this._windowContext.isConstraintFailure();
                constraintFailureConstraint = this._windowContext.getConstraintFailureConstraint();
                constraintFailureCode = this._windowContext.getConstraintFailureCode();
                boolean bl = killResponse = this._windowContext.isExcluded() || isConstraintFailure || isException;
                if (killResponse) {
                    if (log.isLoggable(Level.FINEST)) {
                        if (isException) {
                            this.log(Level.FINEST, "killResponse due to exception");
                        } else if (this._windowContext.isConstraintFailure()) {
                            this.log(Level.FINEST, "killResponse due to constraintFailure");
                        } else {
                            this.log(Level.FINEST, "killResponse");
                        }
                    }
                    this.reset(true);
                }
                ResponseHandler parentResponseHandler = this._windowContext.getParentResponseHandler();
                CachingResponseHandler cacheResponseHandler = null;
                ResponseHandler next = this._windowContext.getResponseHandler();
                while (next != null && next != parentResponseHandler) {
                    ResponseHandler responseHandler = next;
                    next = next.getSuccessor();
                    try {
                        if (!killResponse && !isException) {
                            responseHandler.flushBuffer();
                        }
                        if (responseHandler instanceof CachingResponseHandler) {
                            cacheResponseHandler = (CachingResponseHandler)responseHandler;
                            continue;
                        }
                        responseHandler.finish();
                    }
                    catch (Exception ex) {
                        if (!isException) {
                            isException = true;
                            exception = ex;
                            continue;
                        }
                        if (!log.isLoggable(Level.FINEST)) continue;
                        this.log(Level.FINEST, new StringBuffer().append("exception while finishing response handlers: ").append(ex.toString()).toString(), ex);
                    }
                }
                String expirationCacheAttribute = (String)this._connection.getAttribute(EXPIRATION_CACHE);
                this._connection.removeAttribute(EXPIRATION_CACHE);
                if (cacheResponseHandler != null) {
                    if (killResponse) {
                        cacheResponseHandler.finish(0, null, null);
                    } else {
                        try {
                            int expirationCache = this._windowContext.getExpirationCache();
                            CacheKey cacheKey = null;
                            if (expirationCache != 0 && expirationCacheAttribute != null) {
                                expirationCache = Integer.parseInt(expirationCacheAttribute);
                            }
                            if (expirationCache != 0) {
                                cacheKey = this.getCacheKey();
                            }
                            cacheResponseHandler.finish(expirationCache, cacheKey, this.getWindowRequestAttributes());
                        }
                        catch (Exception ex) {
                            if (isException) break block55;
                            isException = true;
                            exception = ex;
                        }
                    }
                }
            }
            WindowContext windowContext = this._windowContext;
            String namespace = this._windowContext.getNamespace();
            try {
                this.popStack();
            }
            finally {
                windowContext.finish();
            }
            if (isConstraintFailure) {
                if (this._windowContext != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        this.log(namespace, Level.FINEST, new StringBuffer().append("propagating constraint failure ").append(constraintFailureConstraint.getClass().getName()).append(" to parent").toString());
                    }
                    this._windowContext.setConstraintFailure(constraintFailureConstraint, constraintFailureCode);
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        this.log(namespace, Level.FINEST, new StringBuffer().append("propagating constraint failure  ").append(constraintFailureConstraint.getClass().getName()).append(" to connection").toString());
                    }
                    if (!(handled = this._connection.handleConstraintFailure(constraintFailureConstraint, constraintFailureCode)) && !isException) {
                        isException = true;
                        exception = new PortletException(new StringBuffer().append("Constraint failure ").append(constraintFailureConstraint.getClass().getName()).append("(").append(constraintFailureCode).append(")").toString());
                    }
                }
            }
            if (isException) {
                if (this._windowContext != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        this.log(namespace, Level.FINEST, new StringBuffer().append("propagating exception ").append(exception.getClass().getName()).append(" to parent").toString());
                    }
                    this._windowContext.setException((Exception)exception);
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        this.log(namespace, Level.FINEST, new StringBuffer().append("propagating exception ").append(exception.getClass().getName()).append(" to connection").toString());
                    }
                    try {
                        handled = this._connection.handleException((Exception)exception);
                        if (!handled) {
                            this.setConnectionFailed((Exception)exception);
                        }
                    }
                    catch (Exception ex) {
                        this.setConnectionFailed((Exception)exception);
                        log.log(Level.WARNING, ex.toString(), ex);
                    }
                }
            }
            if (this._windowContext == null) {
                if (log.isLoggable(Level.FINER)) {
                    this.log(Level.FINER, "finishing render stage");
                }
                this._stage = 5;
                this._connection.setAttribute(PORTLET_CONFIG, null);
            } else {
                this._connection.setAttribute(PORTLET_CONFIG, this.getWindow().getPortletConfig());
            }
            this.restoreWindowRequestAttributes(requestAttributes);
            fail = false;
        }
        catch (RuntimeException ex) {
            this.setConnectionFailed(ex);
            throw ex;
        }
        finally {
            if (fail) {
                this.setConnectionFailed();
            }
        }
    }

    protected void checkWindowMutable(String namespace) throws IllegalStateException, IllegalArgumentException {
        WindowContext windowContext = this._windowContextMap.get(namespace);
        if (windowContext == null) {
            throw new IllegalArgumentException(new StringBuffer().append("namespace `").append(namespace).append("' not known").toString());
        }
        if (windowContext.getActionMap() != null && !namespace.equals(this.getNamespace())) {
            throw new IllegalStateException(new StringBuffer().append("already did processAction() for namespace `").append(namespace).append("'").toString());
        }
        if (windowContext.getNamespace() == null) {
            throw new IllegalStateException(new StringBuffer().append("already did render() for namespace `").append(namespace).append("'").toString());
        }
    }

    protected Window getWindow() {
        return this._windowContext.getWindow();
    }

    protected Window getWindow(String namespace) {
        WindowContext windowContext = this._windowContextMap.get(namespace);
        return windowContext == null ? null : windowContext.getWindow();
    }

    protected String getNamespace() {
        return this._windowContext.getNamespace();
    }

    protected Renderer getRenderer() {
        return this._windowContext.getWindow().getRenderer();
    }

    protected Renderer getRenderer(String namespace) {
        WindowContext windowContext = this._windowContextMap.get(namespace);
        return windowContext == null ? null : windowContext.getWindow().getRenderer();
    }

    protected Invocation getInvocation() {
        Invocation invocation = this._windowContext.getInvocation();
        if (invocation == null) {
            throw new UnsupportedOperationException("operation requires a namespace");
        }
        return invocation;
    }

    protected Invocation getInvocation(String namespace) {
        return this._invocationFactory.getInvocation(namespace);
    }

    protected void forbidRedirectIfInActionStage() {
        if (this._stage == 2) {
            this.setForbidRedirect();
        }
    }

    public Set<WindowState> getWindowStatesUsed() {
        return this.getInvocationFactory().getWindowStatesUsed();
    }

    public Set<PortletMode> getPortletModesUsed() {
        return this.getInvocationFactory().getPortletModesUsed();
    }

    protected boolean isPortletModeAllowed(Window window, PortletMode portletMode) {
        PortletRequest portletRequest = this.getPortletRequest();
        boolean allowed = true;
        Renderer renderer = window.getRenderer();
        if (renderer != null) {
            allowed = renderer.isPortletModeAllowed(portletRequest, portletMode);
        }
        if (allowed && window != null) {
            allowed = window.isPortletModeAllowed(portletRequest, portletMode);
        }
        if (allowed) {
            allowed = this.getPortal().isPortletModeAllowed(portletRequest, portletMode);
        }
        return allowed;
    }

    protected void setPortletMode(Window window, String namespace, Invocation invocation, PortletMode portletMode) throws PortletModeException {
        if (!this.isPortletModeAllowed(window, portletMode)) {
            throw new PortletModeException(new StringBuffer().append("PortletMode `").append(portletMode).append("' not allowed for namespace `").append(namespace).append("'").toString(), portletMode);
        }
        this.forbidRedirectIfInActionStage();
        invocation.setPortletMode(portletMode);
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        return this.isPortletModeAllowed(this.getWindow(), this.getPortletMode());
    }

    public boolean isPortletModeAllowed(String namespace, PortletMode portletMode) {
        return this.isPortletModeAllowed(this.getWindow(namespace), this.getPortletMode(namespace));
    }

    public PortletMode getPortletMode() {
        return this.getInvocation().getPortletMode();
    }

    public PortletMode getPortletMode(String namespace) {
        return this.getInvocation(namespace).getPortletMode();
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        this.setPortletMode(this.getWindow(), this.getNamespace(), this.getInvocation(), portletMode);
    }

    public void setPortletMode(String namespace, PortletMode portletMode) throws PortletModeException {
        this.checkWindowMutable(namespace);
        this.setPortletMode(this.getWindow(namespace), namespace, this.getInvocation(namespace), portletMode);
    }

    protected boolean isWindowStateAllowed(Window window, WindowState windowState) {
        PortletRequest portletRequest = this.getPortletRequest();
        boolean allowed = true;
        Renderer renderer = window.getRenderer();
        if (renderer != null) {
            allowed = renderer.isWindowStateAllowed(portletRequest, windowState);
        }
        if (allowed && window != null) {
            allowed = window.isWindowStateAllowed(portletRequest, windowState);
        }
        if (allowed) {
            allowed = this.getPortal().isWindowStateAllowed(portletRequest, windowState);
        }
        return allowed;
    }

    protected void setWindowState(Window window, String namespace, Invocation invocation, WindowState windowState) throws WindowStateException {
        if (!this.isWindowStateAllowed(window, windowState)) {
            throw new WindowStateException(new StringBuffer().append("WindowState `").append(windowState).append("' not allowed for namespace `").append(namespace).append("'").toString(), windowState);
        }
        this.forbidRedirectIfInActionStage();
        invocation.setWindowState(windowState);
    }

    public boolean isWindowStateAllowed(WindowState windowState) {
        return this.isWindowStateAllowed(this.getWindow(), windowState);
    }

    public boolean isWindowStateAllowed(String namespace, WindowState windowState) {
        return this.isWindowStateAllowed(this.getWindow(namespace), windowState);
    }

    public WindowState getWindowState() {
        return this.getInvocation().getWindowState();
    }

    public WindowState getWindowState(String namespace) {
        return this.getInvocation(namespace).getWindowState();
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        this.setWindowState(this.getWindow(), this.getNamespace(), this.getInvocation(), windowState);
    }

    public void setWindowState(String namespace, WindowState windowState) throws WindowStateException {
        this.checkWindowMutable(namespace);
        this.setWindowState(this.getWindow(namespace), namespace, this.getInvocation(namespace), windowState);
    }

    public Map<String, String[]> getActionParameterMap() {
        Map<String, String[]> actionMap = this._windowContext.getActionMap();
        if (actionMap == null) {
            throw new IllegalStateException(new StringBuffer().append("namespace `").append(this.getNamespace()).append("' is not target of action").toString());
        }
        return actionMap;
    }

    public Map<String, String[]> getRenderParameterMap() {
        return this.getInvocation().getParameterMap();
    }

    public Map<String, String[]> getRenderParameterMap(String namespace) {
        return this.getInvocation(namespace).getParameterMap();
    }

    private void checkNullName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("parameter name cannot be null");
        }
    }

    private void checkNullValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("parameter value cannot be null");
        }
    }

    protected String getParameter(Map<String, String[]> map, String name) {
        this.checkNullName(name);
        String[] values = map.get(name);
        return values == null || values.length == 0 ? null : values[0];
    }

    protected String[] getParameterValues(Map<String, String[]> map, String name) {
        this.checkNullName(name);
        return map.get(name);
    }

    protected Enumeration getParameterNames(Map<String, String[]> map) {
        return Collections.enumeration(map.keySet());
    }

    protected void setParameter(Map<String, String[]> map, String name, String value) {
        this.checkNullName(name);
        this.checkNullValue(value);
        map.put(name, new String[]{value});
    }

    protected void setParameters(Map<String, String[]> destMap, Map<String, String[]> srcMap) {
        this.checkNullValue(srcMap);
        destMap.clear();
        for (Map.Entry<String, String[]> entry : srcMap.entrySet()) {
            this.setParameter(destMap, entry.getKey(), entry.getValue());
        }
    }

    protected void setParameter(Map<String, String[]> map, String name, String[] values) {
        this.checkNullName(name);
        this.checkNullValue(values);
        if (values.length == 0) {
            map.remove(name);
        } else {
            map.put(name, values);
        }
    }

    public String getActionParameter(String name) {
        return this.getParameter(this.getActionParameterMap(), name);
    }

    public String[] getActionParameterValues(String name) {
        return this.getParameterValues(this.getActionParameterMap(), name);
    }

    public Enumeration getActionParameterNames() {
        return this.getParameterNames(this.getActionParameterMap());
    }

    public String getRenderParameter(String name) {
        return this.getParameter(this.getRenderParameterMap(), name);
    }

    public String[] getRenderParameterValues(String name) {
        return this.getParameterValues(this.getRenderParameterMap(), name);
    }

    public Enumeration getRenderParameterNames() {
        return this.getParameterNames(this.getRenderParameterMap());
    }

    public void setRenderParameters(Map<String, String[]> srcMap) {
        this.forbidRedirectIfInActionStage();
        this.setParameters(this.getRenderParameterMap(), srcMap);
    }

    public void setRenderParameter(String name, String value) {
        this.forbidRedirectIfInActionStage();
        this.setParameter(this.getRenderParameterMap(), name, value);
    }

    public void setRenderParameter(String name, String[] values) {
        this.forbidRedirectIfInActionStage();
        this.setParameter(this.getRenderParameterMap(), name, values);
    }

    public String getRenderParameter(String namespace, String name) {
        return this.getParameter(this.getRenderParameterMap(namespace), name);
    }

    public String[] getRenderParameterValues(String namespace, String name) {
        return this.getParameterValues(this.getRenderParameterMap(namespace), name);
    }

    public Enumeration getRenderParameterNames(String namespace) {
        return this.getParameterNames(this.getRenderParameterMap(namespace));
    }

    public void setRenderParameters(String namespace, Map<String, String[]> srcMap) {
        this.checkWindowMutable(namespace);
        this.forbidRedirectIfInActionStage();
        this.setParameters(this.getRenderParameterMap(namespace), srcMap);
    }

    public void setRenderParameter(String namespace, String name, String value) {
        this.checkWindowMutable(namespace);
        this.forbidRedirectIfInActionStage();
        this.setParameter(this.getRenderParameterMap(namespace), name, value);
    }

    public void setRenderParameter(String namespace, String name, String[] values) {
        this.checkWindowMutable(namespace);
        this.forbidRedirectIfInActionStage();
        this.setParameter(this.getRenderParameterMap(namespace), name, values);
    }

    protected PortalURL createURL(InvocationURL url) {
        return new PortalURL(this, url);
    }

    protected PortalURL createRenderURL(Invocation invocation, boolean keepParameters) {
        PortalURL url = this.createURL(invocation.createRenderURL());
        if (keepParameters) {
            url.setParameters(invocation.getParameterMap());
        }
        return url;
    }

    protected PortalURL createActionURL(Invocation invocation, boolean keepParameters) {
        PortalURL url = this.createURL(invocation.createActionURL());
        if (keepParameters) {
            url.setParameters(invocation.getParameterMap());
        }
        return url;
    }

    public PortalURL createRenderURL() {
        return this.createRenderURL(this.getInvocation(), false);
    }

    public PortalURL createActionURL() {
        return this.createActionURL(this.getInvocation(), false);
    }

    public PortalURL createRenderURL(String namespace, boolean keepParameters) {
        return this.createRenderURL(this.getInvocation(namespace), keepParameters);
    }

    public PortalURL createActionURL(String namespace, boolean keepParameters) {
        return this.createActionURL(this.getInvocation(namespace), keepParameters);
    }

    public PortletPreferences getPreferences() {
        if (this._windowContext.getPreferences() == null) {
            PreferencesStore store = this.getPreferencesStore();
            Window window = this.getWindow();
            PortletPreferences defaultPreferences = window == null ? null : window.getDefaultPreferences();
            ArrayList<PreferencesValidator> validators = window == null ? null : window.getPreferencesValidators();
            try {
                Map<String, String[]> storeMap = store.getPreferencesMap(this.getPortletRequest(), this.getNamespace());
                LinkingPortletPreferences pref = new LinkingPortletPreferences();
                pref.start(defaultPreferences, validators, storeMap);
                this._windowContext.setPreferences(pref);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this._windowContext.getPreferences();
    }

    public Map<String, String> getUserAttributeMap() throws IOException {
        if (this._windowContext.getUserAttributeMap() == null) {
            UserAttributeStore store = this.getUserAttributeStore();
            Set<String> names = this.getPortal().getUserAttributeNames();
            Map<String, String> userAttributeMap = store.getUserAttributeMap(this.getPortletRequest(), names);
            this._windowContext.setUserAttributeMap(userAttributeMap);
        }
        return this._windowContext.getUserAttributeMap();
    }

    public void setTitle(String title) {
        this._connection.setAttribute("javax.portlet.title", title);
    }

    public Locale getResponseLocale() {
        this.getResponseLocalesSet();
        return this._windowContext.getResponseLocale();
    }

    private boolean containsLocale(Set<Locale> set, Locale locale) {
        Locale loc;
        if (set == null || set.contains(locale)) {
            return true;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (variant.length() > 0 && set.contains(loc = new Locale(language, country, variant = ""))) {
            return true;
        }
        if (country.length() > 0 && set.contains(loc = new Locale(language, country = "", variant))) {
            return true;
        }
        return language.length() > 0 && set.contains(loc = LOCALE_ANY);
    }

    public Set<Locale> getResponseLocalesSet() {
        boolean clientSupportsAll;
        Set<Locale> responseLocales = this._windowContext.getResponseLocales();
        Locale established = this._windowContext.getResponseHandler().getLocale();
        if (established != null && responseLocales != null && responseLocales.size() > 0 && !responseLocales.contains(established)) {
            responseLocales = null;
        }
        if (responseLocales != null) {
            return responseLocales;
        }
        responseLocales = new LinkedHashSet<Locale>();
        Locale responseLocale = null;
        Window window = this.getWindow();
        Set<Locale> configLocales = window == null ? null : window.getSupportedLocales();
        Set<Locale> clientLocales = this._connection.getClientLocales();
        boolean configSupportsAll = configLocales == null || configLocales.isEmpty() || configLocales.contains(LOCALE_ANY);
        boolean bl = clientSupportsAll = clientLocales == null || clientLocales.isEmpty() || clientLocales.contains(LOCALE_ANY);
        if (established != null) {
            boolean clientSupports;
            boolean configSupports = configSupportsAll || this.containsLocale(configLocales, established);
            boolean bl2 = clientSupports = clientSupportsAll || this.containsLocale(clientLocales, established);
            if (configSupports || clientSupports) {
                responseLocales.add(established);
                responseLocale = established;
            }
        } else if (configLocales == null) {
            for (Locale clientLocale : clientLocales) {
                if (clientLocale.equals(LOCALE_ANY)) continue;
                if (responseLocale == null) {
                    responseLocale = clientLocale;
                }
                responseLocales.add(clientLocale);
            }
        } else {
            for (Locale configLocale : configLocales) {
                if (configLocale.equals(LOCALE_ANY) || !clientSupportsAll && !clientLocales.contains(configLocale)) continue;
                responseLocales.add(configLocale);
                if (responseLocale != null) continue;
                responseLocale = configLocale;
            }
        }
        if (responseLocale == null && established == null) {
            responseLocale = Locale.getDefault();
            responseLocales.add(responseLocale);
        }
        this._windowContext.setResponseLocale(responseLocale);
        this._windowContext.setResponseLocales(responseLocales);
        return responseLocales;
    }

    public String getResponseCharacterEncoding() {
        this.getResponseCharacterEncodingsSet();
        return this._windowContext.getResponseCharacterEncoding();
    }

    public Set<String> getResponseCharacterEncodingsSet() {
        boolean clientSupportsAll;
        Set<String> responseEncodings = this._windowContext.getResponseCharacterEncodings();
        String establishedEncoding = this._windowContext.getResponseHandler().getCharacterEncoding();
        if (establishedEncoding != null && responseEncodings != null && responseEncodings.size() > 0 && !responseEncodings.contains(establishedEncoding)) {
            responseEncodings = null;
        }
        if (responseEncodings != null) {
            return responseEncodings;
        }
        responseEncodings = new LinkedHashSet<String>();
        String responseEncoding = null;
        Set<String> clientEncodings = this._connection.getClientCharacterEncodings();
        boolean bl = clientSupportsAll = clientEncodings == null || clientEncodings.isEmpty() || clientEncodings.contains("*");
        if (establishedEncoding != null) {
            if (clientSupportsAll || clientEncodings.contains(establishedEncoding)) {
                responseEncodings.add(establishedEncoding);
                responseEncoding = establishedEncoding;
            }
        } else {
            for (String clientEncoding : clientEncodings) {
                responseEncodings.add(clientEncoding);
                if (responseEncoding != null) continue;
                responseEncoding = clientEncoding;
            }
            if (responseEncoding == null) {
                responseEncoding = System.getProperty("file.encoding");
                responseEncodings.add(responseEncoding);
            }
        }
        this._windowContext.setResponseCharacterEncoding(responseEncoding);
        this._windowContext.setResponseCharacterEncodings(responseEncodings);
        return responseEncodings;
    }

    private String getWildcardContentType(String contentType) {
        int i = contentType.indexOf(47);
        if (i < 0) {
            return null;
        }
        return new StringBuffer().append(contentType.substring(0, i + 1)).append("*").toString();
    }

    public String getResponseContentType() {
        this.getResponseContentTypesSet();
        return this._windowContext.getResponseContentType();
    }

    public Set<String> getResponseContentTypesSet() {
        boolean clientSupportsAll;
        Set<String> responseTypes = this._windowContext.getResponseContentTypes();
        String establishedType = this._windowContext.getResponseHandler().getContentType();
        if (establishedType != null && responseTypes != null && responseTypes.size() > 0 && !responseTypes.contains(establishedType)) {
            responseTypes = null;
        }
        if (responseTypes != null) {
            return responseTypes;
        }
        responseTypes = new LinkedHashSet<String>();
        String responseType = null;
        Window window = this.getWindow();
        Set<String> configTypes = window == null ? null : window.getSupportedContentTypes(this.getPortletMode());
        boolean configSupportsAll = configTypes == null || configTypes.contains("*/*");
        Set<String> clientTypes = this._connection.getClientContentTypes();
        boolean bl = clientSupportsAll = clientTypes == null || clientTypes.isEmpty() || clientTypes.contains("*/*");
        if (establishedType != null) {
            String wildcard = this.getWildcardContentType(establishedType);
            if ((configSupportsAll || configTypes.contains(establishedType) || configTypes.contains(wildcard)) && (clientSupportsAll || clientTypes.contains(establishedType) || clientTypes.contains(wildcard))) {
                responseTypes.add(establishedType);
                responseType = establishedType;
            }
        } else if (configSupportsAll) {
            for (String clientType : clientTypes) {
                if (responseType == null) {
                    responseType = clientType;
                }
                responseTypes.add(clientType);
            }
        } else {
            Iterator<String> iter = configTypes.iterator();
            boolean configHasWildcard = false;
            while (iter.hasNext()) {
                String configType = iter.next();
                boolean isUsableConfigType = false;
                if (configType.indexOf(42) > -1) {
                    configHasWildcard = true;
                } else if (clientSupportsAll || clientTypes.contains(configType)) {
                    isUsableConfigType = true;
                } else {
                    String wildcardConfigType = this.getWildcardContentType(configType);
                    if (wildcardConfigType != null && clientTypes.contains(wildcardConfigType)) {
                        isUsableConfigType = true;
                    }
                }
                if (!isUsableConfigType) continue;
                responseTypes.add(configType);
                if (responseType != null) continue;
                responseType = configType;
            }
            if (configHasWildcard) {
                for (String clientType : clientTypes) {
                    boolean isUsableClientType = false;
                    if (configSupportsAll) {
                        isUsableClientType = true;
                    } else {
                        String wildcardClientType;
                        String string = wildcardClientType = clientType.indexOf(42) > -1 ? clientType : this.getWildcardContentType(clientType);
                        if (wildcardClientType != null && configTypes.contains(wildcardClientType)) {
                            isUsableClientType = true;
                        }
                    }
                    if (!isUsableClientType) continue;
                    responseTypes.add(clientType);
                    if (responseType != null) continue;
                    responseType = clientType;
                }
            }
        }
        this._windowContext.setResponseContentType(responseType);
        this._windowContext.setResponseContentTypes(responseTypes);
        return responseTypes;
    }

    public String getContentType() {
        return this._windowContext.getResponseHandler().getContentType();
    }

    public void setContentType(String contentType) {
        if (contentType.equals(this._windowContext.getResponseHandler().getContentType())) {
            return;
        }
        PortletMode currentMode = this.getPortletMode();
        Window window = this._windowContext.getWindow();
        Set<String> configTypes = null;
        if (window != null) {
            configTypes = window.getSupportedContentTypes(currentMode);
        }
        if (configTypes != null && !configTypes.contains(contentType)) {
            throw new IllegalArgumentException(new StringBuffer().append("portlet with namespace `").append(this._windowContext.getNamespace()).append("' does not support content type `").append(contentType).append("'").append(" when in mode `").append(currentMode).append("'").toString());
        }
        this._windowContext.getResponseHandler().setContentType(contentType);
    }

    public Locale getLocale() {
        return this._windowContext.getResponseHandler().getLocale();
    }

    public void addProperty(String key, String value) {
        this._windowContext.getResponseHandler().addProperty(key, value);
    }

    public void setProperty(String key, String value) {
        this._windowContext.getResponseHandler().setProperty(key, value);
    }

    public String getCharacterEncoding() {
        return this._windowContext.getResponseHandler().getCharacterEncoding();
    }

    public PrintWriter getWriter() throws IOException {
        return this._windowContext.getResponseHandler().getWriter();
    }

    public void setBufferSize(int size) {
        this._windowContext.getResponseHandler().setBufferSize(size);
    }

    public int getBufferSize() {
        return this._windowContext.getResponseHandler().getBufferSize();
    }

    public void flushBuffer(boolean flushToClient) throws IOException {
        ResponseHandler parentResponseHandler = this._windowContext.getParentResponseHandler();
        for (ResponseHandler responseHandler = this._windowContext.getResponseHandler(); responseHandler != null && (flushToClient || responseHandler != parentResponseHandler); responseHandler = responseHandler.getSuccessor()) {
            responseHandler.flushBuffer();
        }
    }

    public void reset(boolean resetRenderer) {
        ResponseHandler parentResponseHandler = this._windowContext.getParentResponseHandler();
        RendererResponseHandler renderer = null;
        boolean isWriter = false;
        boolean isOutputStream = false;
        for (ResponseHandler responseHandler = this._windowContext.getResponseHandler(); responseHandler != null && responseHandler != parentResponseHandler; responseHandler = responseHandler.getSuccessor()) {
            if (!resetRenderer && responseHandler instanceof RendererResponseHandler) {
                renderer = (RendererResponseHandler)responseHandler;
                isWriter = renderer.isWriter();
                isOutputStream = renderer.isOutputStream();
            }
            responseHandler.reset();
        }
        if (renderer != null) {
            if (isWriter) {
                try {
                    renderer.getWriter();
                }
                catch (IOException ex) {
                    this.setConnectionFailed(ex);
                }
            }
            if (isOutputStream) {
                try {
                    renderer.getOutputStream();
                }
                catch (IOException ex) {
                    this.setConnectionFailed(ex);
                }
            }
        }
    }

    protected void checkAlwaysWriteOrStream() throws IOException {
        ResponseHandler responseHandler;
        if (this._windowContext == null) {
            return;
        }
        ResponseHandler parentResponseHandler = this._windowContext.getParentResponseHandler();
        ResponseHandler next = responseHandler = this._windowContext.getResponseHandler();
        while (next != null && next != parentResponseHandler) {
            if (responseHandler instanceof RendererResponseHandler) {
                RendererResponseHandler renderer = (RendererResponseHandler)next;
                boolean isWriter = renderer.isWriter();
                boolean isOutputStream = renderer.isOutputStream();
                if (!isWriter && !isOutputStream) {
                    String contentType;
                    if (renderer.isAlwaysWrite()) {
                        if (this.getRenderResponse().getContentType() == null) {
                            contentType = renderer.getDefaultContentType();
                            this.getRenderResponse().setContentType(contentType);
                        }
                        responseHandler.getWriter();
                    } else if (renderer.isAlwaysStream()) {
                        if (this.getRenderResponse().getContentType() == null) {
                            contentType = renderer.getDefaultContentType();
                            this.getRenderResponse().setContentType(contentType);
                        }
                        responseHandler.getOutputStream();
                    }
                }
                next = null;
                continue;
            }
            next = next.getSuccessor();
        }
    }

    public void resetBuffer(boolean resetRenderer) {
        ResponseHandler parentResponseHandler = this._windowContext.getParentResponseHandler();
        for (ResponseHandler responseHandler = this._windowContext.getResponseHandler(); responseHandler != null && responseHandler != parentResponseHandler && (resetRenderer || !(responseHandler instanceof RendererResponseHandler)); responseHandler = responseHandler.getSuccessor()) {
            responseHandler.resetBuffer();
        }
    }

    public boolean isCommitted() {
        return this._windowContext.getResponseHandler().isCommitted();
    }

    public OutputStream getPortletOutputStream() throws IOException {
        return this._windowContext.getResponseHandler().getOutputStream();
    }

    public boolean isUserInRole(String role) {
        String effectiveRole;
        Map<String, String> roleRefMap;
        Window window = this.getWindow();
        Map<String, String> map = roleRefMap = window == null ? null : window.getRoleRefMap();
        if (roleRefMap != null && (effectiveRole = roleRefMap.get(role)) != null) {
            role = effectiveRole;
        }
        return this._connection.isUserInRole(role);
    }

    public String getRemoteUser() {
        return this._connection.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this._connection.getUserPrincipal();
    }

    public String getAuthType() {
        return this._connection.getAuthType();
    }

    public boolean isSecure() {
        return this._connection.isSecure();
    }

    public String getRequestedSessionId() {
        return this._connection.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this._connection.isRequestedSessionIdValid();
    }

    public boolean canGuaranteeIntegrity() {
        return this._connection.canGuaranteeIntegrity();
    }

    public boolean canGuaranteeConfidentiality() {
        return this._connection.canGuaranteeConfidentiality();
    }

    public String getContextPath() {
        return this._connection.getContextPath();
    }

    public String getServerName() {
        return this._connection.getServerName();
    }

    public int getServerPort() {
        return this._connection.getServerPort();
    }

    public String getScheme() {
        return this._connection.getScheme();
    }

    public String getProperty(String name) {
        return this._connection.getProperty(name);
    }

    public Enumeration getProperties(String name) {
        return this._connection.getProperties(name);
    }

    public Enumeration getPropertyNames() {
        return this._connection.getPropertyNames();
    }

    public Enumeration getAttributeNames() {
        return this._connection.getAttributeNames();
    }

    public Object getAttribute(String name) {
        if (name.equals("javax.portlet.userinfo")) {
            try {
                return this.getUserAttributeMap();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this._connection.getAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this._connection.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this._connection.removeAttribute(name);
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(false);
    }

    public PortletSession getPortletSession(boolean create) {
        return this._connection.getPortletSession(create);
    }

    public InputStream getSubmitInputStream() throws IOException {
        return this._connection.getSubmitInputStream();
    }

    public void setSubmitCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this._connection.setSubmitCharacterEncoding(enc);
    }

    public String getSubmitCharacterEncoding() {
        return this._connection.getSubmitCharacterEncoding();
    }

    public BufferedReader getSubmitReader() throws UnsupportedEncodingException, IOException {
        return this._connection.getSubmitReader();
    }

    public String getSubmitContentType() {
        return this._connection.getSubmitContentType();
    }

    public int getSubmitContentLength() {
        return this._connection.getSubmitContentLength();
    }

    public String resolveURL(String path) {
        return this._connection.resolveURL(path);
    }

    public String resolveURL(String path, boolean isSecure) throws PortletSecurityException {
        return this._connection.resolveURL(path, isSecure);
    }

    public String encodeURL(String path) {
        return this._connection.encodeURL(path);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isForbidRedirect()) {
            throw new IllegalStateException("sendRedirect() forbidden, portlet mode, window state,  or render parameters were set in action");
        }
        this._connection.sendRedirect(location);
    }
}

