/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic.context;

import com.caucho.portal.generic.Renderer;
import com.caucho.portal.generic.context.AbstractResponseHandler;
import com.caucho.portal.generic.context.ConnectionContext;
import com.caucho.portal.generic.context.ResponseHandler;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class RendererResponseHandler
extends AbstractResponseHandler {
    protected static final Logger log = Logger.getLogger(ClassLiteral.getClass((String)"com/caucho/portal/generic/context/RendererResponseHandler").getName());
    private ConnectionContext _context;
    private Renderer _renderer;
    private RenderRequest _renderRequest;
    private RenderResponse _renderResponse;
    private String _namespace;
    private PrintWriter _writer;
    private boolean _writerIsWrapped;
    private OutputStream _outputStream;
    private boolean _outputStreamIsWrapped;
    private boolean _wasReset;

    public RendererResponseHandler() {
    }

    public RendererResponseHandler(ConnectionContext context, ResponseHandler responseHandler, Renderer renderer, RenderRequest renderRequest, RenderResponse renderResponse, String namespace) {
        this.open(context, responseHandler, renderer, renderRequest, renderResponse, namespace);
    }

    public void open(ConnectionContext context, ResponseHandler responseHandler, Renderer renderer, RenderRequest renderRequest, RenderResponse renderResponse, String namespace) {
        if (this._renderer != null) {
            throw new IllegalStateException("already open");
        }
        super.open(responseHandler);
        this._context = context;
        this._renderer = renderer;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._namespace = namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        try {
            this.finishWriter(false);
            this.finishOutputStream(false);
        }
        catch (Exception ex) {
            this.setError(ex);
        }
        finally {
            this._wasReset = false;
            this._writer = null;
            this._writerIsWrapped = false;
            this._outputStream = null;
            this._outputStreamIsWrapped = false;
            this._namespace = null;
            this._renderRequest = null;
            this._renderResponse = null;
            this._renderer = null;
        }
    }

    public void finishWriter(boolean isDiscarded) throws IOException {
        if (this._writerIsWrapped) {
            PrintWriter writer = this._writer;
            this._writer = null;
            this._writerIsWrapped = false;
            this._renderer.finish(writer, this._renderRequest, this._namespace, isDiscarded);
        }
    }

    public void finishOutputStream(boolean isDiscarded) throws IOException {
        if (this._outputStreamIsWrapped) {
            OutputStream outputStream = this._outputStream;
            this._outputStream = null;
            this._outputStreamIsWrapped = false;
            this._renderer.finish(outputStream, this._renderRequest, this._namespace, isDiscarded);
        }
    }

    public String getDefaultContentType() {
        return this._renderer == null ? null : this._renderer.getDefaultContentType();
    }

    public boolean isAlwaysWrite() {
        return this._renderer != null && this._renderer.isAlwaysWrite();
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter rendererWriter;
        if (this._writer != null) {
            return this._writer;
        }
        PrintWriter writer = super.getWriter();
        if (this._renderer != null && (rendererWriter = this._renderer.getWriter(writer, this._renderRequest, this._namespace)) != null) {
            writer = rendererWriter;
            this._writerIsWrapped = true;
        }
        this._writer = writer;
        return this._writer;
    }

    public boolean isWriter() {
        return this._writerIsWrapped;
    }

    public boolean isAlwaysStream() {
        return this._renderer != null && this._renderer.isAlwaysStream();
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream rendererStream;
        if (this._outputStream != null) {
            return this._outputStream;
        }
        OutputStream outputStream = super.getOutputStream();
        if (this._renderer != null && (rendererStream = this._renderer.getOutputStream(outputStream, this._renderRequest, this._namespace)) != null) {
            outputStream = rendererStream;
            this._outputStreamIsWrapped = true;
        }
        this._outputStream = outputStream;
        return this._outputStream;
    }

    public boolean isOutputStream() {
        return this._outputStreamIsWrapped;
    }

    public void flushBuffer() throws IOException {
        if (!(this._wasReset || this.isWriter() || this.isOutputStream())) {
            if (this._renderer.isAlwaysWrite()) {
                this.getWriter();
            } else if (this._renderer.isAlwaysStream()) {
                this.getOutputStream();
            }
        }
    }

    public void resetBuffer() {
        this._wasReset = true;
        try {
            this.finishWriter(true);
            this.finishOutputStream(true);
        }
        catch (IOException ex) {
            this.setError(ex);
        }
    }

    public void reset() {
        this._wasReset = true;
        try {
            this.finishWriter(true);
            this.finishOutputStream(true);
        }
        catch (IOException ex) {
            this.setError(ex);
        }
    }

    public void reset(boolean renderAgain) {
        try {
            boolean isWriter = this.isWriter();
            boolean isOutputStream = this.isOutputStream();
            this.finishWriter(true);
            this.finishOutputStream(true);
            if (isWriter) {
                this.getWriter();
            }
            if (isOutputStream) {
                this.getOutputStream();
            }
        }
        catch (IOException ex) {
            this.setError(ex);
        }
    }
}

