/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.log.Log;
import com.caucho.security.SecurityContextException;
import com.caucho.security.SecurityContextProvider;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.security.Principal;
import java.util.logging.Logger;

public class SecurityContext {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/security/SecurityContext"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/security/SecurityContext"));
    private static ThreadLocal<SecurityContextProvider> _providers = new ThreadLocal();

    private SecurityContext() {
    }

    public static Principal getUserPrincipal() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.getUserPrincipal();
        }
        return null;
    }

    public static boolean isUserInRole(String roleName) {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.isUserInRole(roleName);
        }
        return false;
    }

    public static boolean isUserInRole(String[] roleSet) {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null && roleSet != null) {
            for (int i = 0; i < roleSet.length; ++i) {
                if (!provider.isUserInRole(roleSet[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTransportSecure() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            return provider.isTransportSecure();
        }
        return false;
    }

    public static void logout() throws SecurityContextException {
        SecurityContextProvider provider = SecurityContext.getProvider();
        if (provider != null) {
            provider.logout();
        }
    }

    public static SecurityContextProvider getProvider() {
        return _providers.get();
    }

    public static SecurityContextProvider setProvider(SecurityContextProvider provider) {
        SecurityContextProvider oldProvider = _providers.get();
        _providers.set(provider);
        return oldProvider;
    }
}

