/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.config.types.Period;
import com.caucho.jca.AbstractResourceAdapter;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.resource.spi.BootstrapContext;

public class PingThread
extends AbstractResourceAdapter
implements Runnable,
AlarmListener {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/admin/PingThread"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/admin/PingThread"));
    private static final ObjectName _threadMBean;
    private String _pingHost;
    private int _pingPort;
    private ArrayList<String> _urlList = new ArrayList();
    private ArrayList<Path> _pathList = new ArrayList();
    private long _initialSleepTime = 900000L;
    private long _sleepTime = 900000L;
    private long _retryTime = 1000L;
    private int _tryCount = 3;
    private long _socketTimeout = 10000L;
    private long _failureTime = 300000L;
    private long _lastPingTime;
    private Alarm _alarm;
    private DynamicClassLoader _loader;
    private MBeanServer _mbeanServer;
    private volatile long _okayTime;
    private volatile boolean _isClosed;
    private volatile boolean _isFailed;

    public String getPingHost() {
        return this._pingHost;
    }

    public void setPingHost(String pingHost) {
        this._pingHost = pingHost;
    }

    public int getPingPort() {
        return this._pingPort;
    }

    public void setPingPort(int pingPort) {
        this._pingPort = pingPort;
    }

    public void addURL(String url) {
        this._urlList.add(url);
    }

    public long getSleepTime() {
        return this._sleepTime;
    }

    public void setSleepTime(Period sleepTime) {
        this._sleepTime = sleepTime.getPeriod();
    }

    public void setInitialSleepTime(Period sleepTime) {
        this._initialSleepTime = sleepTime.getPeriod();
    }

    public long getRetryTime() {
        return this._retryTime;
    }

    public void setRetryTime(Period retryTime) {
        this._retryTime = retryTime.getPeriod();
    }

    public int getTryCount() {
        return this._tryCount;
    }

    public void setTryCount(int tryCount) {
        this._tryCount = tryCount;
    }

    public long getSocketTimeout() {
        return this._socketTimeout;
    }

    public void setSocketTimeout(long timeout) {
        this._socketTimeout = timeout;
    }

    public void init() {
        for (int i = 0; i < this._urlList.size(); ++i) {
            String url = this._urlList.get(i);
            if (url.startsWith("/")) {
                url = this._pingPort > 0 ? "http://" + this._pingHost + ":" + this._pingPort + url : "http://" + this._pingHost + url;
            }
            this._pathList.add(Vfs.lookup(url));
        }
        try {
            InitialContext ic = new InitialContext();
            MBeanServer server = (MBeanServer)ic.lookup("java:comp/env/jmx/MBeanServer");
            if (server.isRegistered(_threadMBean)) {
                this._mbeanServer = server;
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public void start(BootstrapContext cxt) {
        log.fine("ping starting");
        this._loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        this._okayTime = System.currentTimeMillis();
        this._isClosed = false;
        this._alarm = new Alarm("ping", (AlarmListener)this, this._initialSleepTime);
        Thread thread = new Thread((Runnable)this, "ping");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (this._isClosed || this._isFailed) {
            log.fine("alarm closed at " + QDate.formatLocal(System.currentTimeMillis()));
            return;
        }
        log.fine("alarm checking: " + QDate.formatLocal(System.currentTimeMillis()));
        try {
            boolean isValid = true;
            isValid = this.checkJVMDeadlock();
            if (isValid) {
                isValid = this.pingURLs();
            }
            if (isValid) {
                this._okayTime = System.currentTimeMillis();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            if (!this._isClosed && !this._isFailed) {
                this._alarm.queue(this._sleepTime);
            }
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        long startTime = System.currentTimeMillis();
        long okayInterval = this._sleepTime + (long)this._tryCount * this._retryTime;
        while (!this._isClosed) {
            try {
                long now = System.currentTimeMillis();
                if (now >= startTime + this._initialSleepTime + this._failureTime && this._okayTime + okayInterval + this._failureTime < now) {
                    System.err.println("Closing because of ping delay\nnow: " + QDate.formatLocal(now) + "\n" + "last check: " + QDate.formatLocal(this._okayTime) + "\n");
                    System.exit(1);
                }
                thread.interrupted();
                Thread.sleep(60000L);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkJVMDeadlock() throws Exception {
        if (this._mbeanServer == null) {
            return true;
        }
        long[] deadlockedThreads = (long[])this._mbeanServer.invoke(_threadMBean, "findMonitorDeadlockedThreads", new Object[0], new String[0]);
        if (deadlockedThreads == null) {
            return true;
        }
        try {
            log.severe("JDK detected deadlock. Restarting Resin.");
            for (int i = 0; i < deadlockedThreads.length; ++i) {
                Long id = new Long(deadlockedThreads[i]);
                Integer maxDepth = new Integer(Integer.MAX_VALUE);
                Object info = this._mbeanServer.invoke(_threadMBean, "getThreadInfo", new Object[]{id, maxDepth}, new String[]{"long", "int"});
                log.severe(this.threadInfoToString(info));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            System.exit(0);
        }
    }

    private String threadInfoToString(Object info) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        StackTraceElement[] stackTrace;
        String lockOwnerName;
        if (info == null) {
            return "null";
        }
        String s = info.toString();
        Class<?> cl = info.getClass();
        Method m = cl.getMethod("getLockName", new Class[0]);
        String lockName = (String)m.invoke(info, new Object[0]);
        if (lockName != null) {
            s = s + "\n  waiting for " + lockName;
        }
        if ((lockOwnerName = (String)(m = cl.getMethod("getLockOwnerName", new Class[0])).invoke(info, new Object[0])) != null) {
            s = s + "\n  owned by " + lockOwnerName;
        }
        if ((stackTrace = (StackTraceElement[])(m = cl.getMethod("getStackTrace", new Class[0])).invoke(info, new Object[0])) != null) {
            for (int i = 0; i < stackTrace.length; ++i) {
                s = s + "\n\t" + stackTrace[i];
            }
        }
        return s;
    }

    private boolean pingURLs() throws Exception {
        boolean isValid = true;
        for (int i = this._pathList.size() - 1; i >= 0; --i) {
            Path url = this._pathList.get(i);
            boolean isOkay = false;
            for (int j = 0; !isOkay && j < this._tryCount; ++j) {
                Object status = null;
                try {
                    isOkay = this.checkPing(url, j);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                if (isOkay) continue;
                Thread.currentThread();
                Thread.sleep(this._retryTime);
            }
            if (isOkay) continue;
            isValid = false;
            this.pingFailed(url);
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkPing(Path url, int count) throws Exception {
        if (this._socketTimeout > 0L) {
            url.setAttribute("socket-timeout", new Integer((int)this._socketTimeout));
        }
        ReadStream is = url.openRead();
        try {
            String status = (String)is.getAttribute("status");
            if (log.isLoggable(Level.FINE)) {
                log.fine("ping " + url + " " + status);
            }
            if (status != null && status.equals("200")) {
                boolean bl = true;
                return bl;
            }
            this.pingFailedOnce(url, count, is);
            boolean bl = false;
            return bl;
        }
        finally {
            is.close();
        }
    }

    protected void pingFailedOnce(Path url, int count, ReadStream is) throws Exception {
        int ch;
        String status = (String)is.getAttribute("status");
        CharBuffer cb = new CharBuffer();
        while ((ch = is.read()) >= 0) {
            cb.append((char)ch);
        }
        log.warning(L.l("ping {0} failed ({1}) status: {2}\n{3}", String.valueOf(url), String.valueOf(count), status, cb));
    }

    protected void pingFailed(Path url) throws Exception {
        this._isFailed = true;
        log.severe(L.l("pinging {0} failed.  Shutting down.", url));
        this._loader.destroy();
        System.exit(1);
    }

    public void stop() {
        log.fine("ping stopping");
        if (!this._isFailed) {
            this._isClosed = true;
        }
        this._alarm.dequeue();
    }

    static {
        try {
            _threadMBean = new ObjectName("java.lang:type=Threading");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

