/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.jmx.Jmx;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.server.cluster.ClusterContainer;
import com.caucho.server.cluster.ClusterGroup;
import com.caucho.server.cluster.ClusterPort;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.StoreManager;
import com.caucho.server.cluster.mbean.ClusterMBean;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements EnvironmentListener,
ClusterMBean {
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/cluster/ClusterGroup"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/Cluster"));
    protected static final EnvironmentLocal<String> _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    protected static final EnvironmentLocal<Cluster> _clusterLocal = new EnvironmentLocal("caucho.cluster");
    private String _id = "";
    private String _serverId = "";
    private ObjectName _objectName;
    private ClusterServer[] _serverList = new ClusterServer[0];
    private ClusterGroup _defaultGroup;
    private ArrayList<ClusterGroup> _groupList = new ArrayList();
    private StoreManager _clusterStore;
    private long _clientLiveTime = 30000L;
    private long _clientDeadTime = 15000L;
    private long _clientReadTimeout = 60000L;
    private long _clientWriteTimeout = 60000L;
    private String _ref;
    private volatile boolean _isClosed;

    public Cluster() {
        Environment.addEnvironmentListener(this);
    }

    public static Cluster getLocal() {
        Cluster cluster = _clusterLocal.get();
        return cluster;
    }

    public static Cluster getCluster(ClassLoader loader) {
        Cluster cluster = _clusterLocal.get(loader);
        return cluster;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setClusterRef(String ref) {
        this._ref = ref;
    }

    void addServer(ClusterServer server) throws ConfigException {
        if (this._serverList.length <= server.getIndex()) {
            int newLength = server.getIndex() + 1;
            ClusterServer[] newList = new ClusterServer[newLength];
            System.arraycopy(this._serverList, 0, newList, 0, this._serverList.length);
            this._serverList = newList;
        }
        if (this._serverList[server.getIndex()] != null) {
            throw new ConfigException(L.l("Cluster server `{0}' conflicts with a previous server.", server.getIndex()));
        }
        this._serverList[server.getIndex()] = server;
    }

    public ClusterGroup createGroup() {
        ClusterGroup group = new ClusterGroup();
        group.setCluster(this);
        this._groupList.add(group);
        return group;
    }

    public void addPort(ClusterPort port) throws Exception {
        this.createDefaultGroup().addPort(port);
    }

    public void addSrun(ClusterPort port) throws Exception {
        this.addPort(port);
    }

    ClusterGroup createDefaultGroup() {
        if (this._defaultGroup == null) {
            this._defaultGroup = this.createGroup();
        }
        return this._defaultGroup;
    }

    public StoreManager getStore() {
        return this._clusterStore;
    }

    void setStore(StoreManager store) {
        this._clusterStore = store;
    }

    public void setClientLiveTime(Period period) {
        this._clientLiveTime = period.getPeriod();
    }

    public long getClientLiveTime() {
        return this._clientLiveTime;
    }

    public void setClientDeadTime(Period period) {
        this._clientDeadTime = period.getPeriod();
    }

    public long getClientDeadTime() {
        return this._clientDeadTime;
    }

    public void setClientReadTimeout(Period period) {
        this._clientReadTimeout = period.getPeriod();
    }

    public long getClientReadTimeout() {
        return this._clientReadTimeout;
    }

    public void setClientWriteTimeout(Period period) {
        this._clientWriteTimeout = period.getPeriod();
    }

    public long getClientWriteTimeout() {
        return this._clientWriteTimeout;
    }

    public StoreManager createJdbcStore() throws ConfigException {
        StoreManager store = null;
        try {
            Class<?> cl = Class.forName("com.caucho.server.cluster.JdbcStore");
            store = (StoreManager)cl.newInstance();
            store.setCluster(this);
            this.setStore(store);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (store == null) {
            throw new ConfigException(L.l("'jdbc' persistent sessions are available in Resin Professional.  See http://www.caucho.com for information and licensing."));
        }
        return store;
    }

    public StoreManager createClusterStore() throws ConfigException {
        StoreManager store = null;
        try {
            Class<?> cl = Class.forName("com.caucho.server.cluster.ClusterStore");
            store = (StoreManager)cl.newInstance();
            store.setCluster(this);
            this.setStore(store);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (store == null) {
            throw new ConfigException(L.l("'cluster' persistent sessions are available in Resin Professional.  See http://www.caucho.com for information and licensing."));
        }
        return store;
    }

    public void init() throws ConfigException {
        ClusterContainer container = ClusterContainer.create();
        if (this._ref != null) {
            Cluster cluster = container.findCluster(this._ref);
            if (cluster == null) {
                throw new ConfigException(L.l("'{0}' is an unknown cluster-ref.", this._ref));
            }
            _clusterLocal.set(cluster);
        } else {
            container.addCluster(this);
            _clusterLocal.set(this);
        }
        try {
            String name = this._id;
            if (name == null || name.equals("")) {
                name = "default";
            }
            this._objectName = Jmx.getObjectName(new StringBuffer().append("type=Cluster,name=").append(name).toString());
            Jmx.register((Object)this, this._objectName);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public static String getServerId() {
        return _serverIdLocal.get();
    }

    @Override
    public ObjectName getObjectName() {
        return this._objectName;
    }

    public ClusterServer getSelfServer() {
        this._serverId = _serverIdLocal.get();
        return this.getServer(this._serverId);
    }

    public ClusterServer[] getServerList() {
        return this._serverList;
    }

    @Override
    public ObjectName[] getClientObjectNames() {
        ObjectName[] objectNames = new ObjectName[this._serverList.length];
        for (int i = 0; i < this._serverList.length; ++i) {
            ClusterServer client = this._serverList[i];
            objectNames[i] = client.getObjectName();
        }
        return objectNames;
    }

    public ClusterServer getServer(String serverId) {
        for (int i = 0; i < this._serverList.length; ++i) {
            ClusterServer server = this._serverList[i];
            if (server == null || !server.getId().equals(serverId)) continue;
            return server;
        }
        return null;
    }

    public ClusterServer getServer(int index) {
        for (int i = 0; i < this._serverList.length; ++i) {
            ClusterServer server = this._serverList[i];
            if (server == null || server.getIndex() != index) continue;
            return server;
        }
        return null;
    }

    public ArrayList<ClusterPort> getServerPorts(String serverId) {
        ArrayList<ClusterPort> ports = new ArrayList<ClusterPort>();
        for (int i = 0; i < this._serverList.length; ++i) {
            ClusterPort port;
            ClusterServer server = this._serverList[i];
            if (server == null || !(port = server.getClusterPort()).getServerId().equals(serverId)) continue;
            ports.add(port);
        }
        return ports;
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        try {
            if (this._clusterStore != null) {
                this._clusterStore.start();
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        try {
            this.close();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        for (int i = 0; i < this._serverList.length; ++i) {
            ClusterServer server = this._serverList[i];
            try {
                if (server == null) continue;
                server.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("Cluster[").append(this._id).append("]").toString();
    }
}

