/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.jmx.Jmx;
import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterClient;
import com.caucho.server.cluster.ClusterGroup;
import com.caucho.server.cluster.ClusterPort;
import com.caucho.server.cluster.ClusterStream;
import com.caucho.server.cluster.mbean.ClusterClientMBean;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class ClusterServer
implements ClusterClientMBean {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/ClusterServer"));
    private ObjectName _objectName;
    private Cluster _cluster;
    private ClusterGroup _group;
    private ClusterPort _port;
    private int _groupIndex;
    private Path _tcpPath;
    private ClusterClient _client;

    public void setCluster(Cluster cluster) {
        this._cluster = cluster;
    }

    public Cluster getCluster() {
        return this._cluster;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public void setGroup(ClusterGroup group) {
        this._group = group;
    }

    public ClusterGroup getGroup() {
        return this._group;
    }

    public void setPort(ClusterPort port) {
        this._port = port;
    }

    public ClusterPort getClusterPort() {
        return this._port;
    }

    public String getId() {
        return this._port.getServerId();
    }

    public int getIndex() {
        return this._port.getIndex();
    }

    public String getHost() {
        return this._port.getHost();
    }

    public int getPort() {
        return this._port.getPort();
    }

    public boolean isBackup() {
        return this._port.isBackup();
    }

    public int getGroupIndex() {
        return this._groupIndex;
    }

    public void setGroupIndex(int index) {
        this._groupIndex = index;
    }

    public long getReadTimeout() {
        return this._cluster.getClientReadTimeout();
    }

    public long getWriteTimeout() {
        return this._cluster.getClientWriteTimeout();
    }

    public long getTimeout() {
        return this.getReadTimeout();
    }

    public long getLiveTime() {
        return this._cluster.getClientLiveTime();
    }

    public long getDeadTime() {
        return this._cluster.getClientDeadTime();
    }

    public int getActiveCount() {
        return this._client.getActiveCount();
    }

    public void init() throws Exception {
        String host = this.getHost();
        if (host == null) {
            host = "localhost";
        }
        this._tcpPath = this._port.isSSL() ? Vfs.lookup("tcps://" + host + ":" + this.getPort()) : Vfs.lookup("tcp://" + host + ":" + this.getPort());
        this._client = new ClusterClient(this);
        try {
            String clusterName = this._cluster.getId();
            if (clusterName == null || clusterName.equals("")) {
                clusterName = "default";
            }
            this._objectName = Jmx.getObjectName("type=ClusterClient,Cluster=" + clusterName + ",host=" + host + ",port=" + this.getPort());
            Jmx.register((Object)this, this._objectName);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public boolean isDead() {
        return this._client.isDead();
    }

    public ClusterClient getClient() {
        return this._client;
    }

    ReadWritePair openTCPPair() throws IOException {
        return this._tcpPath.openReadWrite();
    }

    public void wake() {
        this._client.wake();
    }

    public boolean canConnect() {
        try {
            this.wake();
            ClusterStream stream = this._client.open();
            if (stream != null) {
                stream.close();
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
    }

    public void close() {
        this._client.close();
    }

    public String toString() {
        return "ClusterServer[id=" + this._port.getServerId() + " index=" + this._port.getIndex() + " host=" + this._port.getHost() + ":" + this._port.getPort() + " cluster=" + this._cluster.getId() + "]";
    }
}

