/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.ClusterClient;
import com.caucho.util.Alarm;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterStream {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/ClusterStream"));
    private ClusterClient _srun;
    private ReadStream _is;
    private WriteStream _os;
    private long _freeTime;

    ClusterStream(ClusterClient srun, ReadStream is, WriteStream os) {
        this._srun = srun;
        this._is = is;
        this._os = os;
    }

    public ClusterClient getServer() {
        return this._srun;
    }

    public ReadStream getReadStream() {
        return this._is;
    }

    public WriteStream getWriteStream() {
        return this._os;
    }

    public long getFreeTime() {
        return this._freeTime;
    }

    public void setFreeTime(long freeTime) {
        this._freeTime = freeTime;
    }

    public void free() {
        this._freeTime = Alarm.getCurrentTime();
        this._srun.free(this);
    }

    public void close() {
        ReadStream is = this._is;
        this._is = null;
        WriteStream os = this._os;
        this._os = null;
        if (is != null) {
            this._srun.close(this);
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }
}

